/*
 * Decompiled with CFR 0.152.
 */
package de.mdelab.sdm.interpreter.core.expressions;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class CompositeClassLoader
extends ClassLoader {
    private final Set<ClassLoader> classLoaders;

    public CompositeClassLoader(ClassLoader classLoader) {
        assert (classLoader != null);
        this.classLoaders = Collections.synchronizedSet(new LinkedHashSet());
        this.addClassLoader(classLoader);
    }

    public void addClassLoader(ClassLoader classLoader) {
        this.classLoaders.add(classLoader);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        for (ClassLoader classLoader : this.classLoaders) {
            try {
                return classLoader.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException();
    }
}

