/*
 * Decompiled with CFR 0.152.
 */
package de.mdelab.sdm.interpreter.core.expressions;

import de.mdelab.sdm.interpreter.core.SDMException;
import de.mdelab.sdm.interpreter.core.expressions.CompositeClassLoader;
import de.mdelab.sdm.interpreter.core.expressions.ExpressionInterpreter;
import de.mdelab.sdm.interpreter.core.facade.IExpressionFacade;
import de.mdelab.sdm.interpreter.core.facade.MetamodelFacadeFactory;
import de.mdelab.sdm.interpreter.core.notifications.NotificationEmitter;
import de.mdelab.sdm.interpreter.core.notifications.Notifier;
import de.mdelab.sdm.interpreter.core.variables.Variable;
import de.mdelab.sdm.interpreter.core.variables.VariablesScope;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ExpressionInterpreterManager<Activity, ActivityNode, ActivityEdge, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression>
extends Notifier<Activity, ActivityNode, ActivityEdge, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression> {
    private final IExpressionFacade<Expression> expressionFacade;
    private final Map<String, Map<String, ExpressionInterpreter<Expression, Classifier>>> expressionInterpreters;
    private final MetamodelFacadeFactory<Activity, ActivityNode, ActivityEdge, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression> facadeFactory;
    private final CompositeClassLoader classLoader;

    public ExpressionInterpreterManager(MetamodelFacadeFactory<Activity, ActivityNode, ActivityEdge, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression> facadeFactory, ClassLoader classLoader, NotificationEmitter<Activity, ActivityNode, ActivityEdge, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression> notificationEmitter) {
        super(notificationEmitter);
        assert (facadeFactory != null);
        this.facadeFactory = facadeFactory;
        this.expressionFacade = facadeFactory.getExpressionFacade();
        this.classLoader = new CompositeClassLoader(classLoader);
        this.expressionInterpreters = new ConcurrentHashMap<String, Map<String, ExpressionInterpreter<Expression, Classifier>>>();
    }

    public MetamodelFacadeFactory<Activity, ActivityNode, ActivityEdge, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression> getFacadeFactory() {
        return this.facadeFactory;
    }

    public CompositeClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Variable<Classifier> evaluateExpression(Expression expression, Classifier contextClassifier, Object contextInstance, VariablesScope<?, ?, ?, ?, ?, ?, Classifier, ?, Expression> variablesScope) throws SDMException {
        this.getNotificationEmitter().evaluatingExpression(expression, variablesScope, this);
        ExpressionInterpreter<Expression, Classifier> expressionInterpreter = this.getExpressionInterpreter(this.expressionFacade.getExpressionLanguage(expression), this.expressionFacade.getExpressionLanguageVersion(expression));
        if (expressionInterpreter == null) {
            throw new SDMException("There is no expression interpreter for language '" + this.expressionFacade.getExpressionLanguage(expression) + "' version '" + this.expressionFacade.getExpressionLanguageVersion(expression) + "'.");
        }
        Variable<Classifier> result = expressionInterpreter.evaluateExpression(expression, contextClassifier, contextInstance, variablesScope);
        this.getNotificationEmitter().evaluatedExpression(expression, result.getValue(), variablesScope, this);
        return result;
    }

    public synchronized void registerExpressionInterpreter(ExpressionInterpreter<Expression, Classifier> expressionInterpreter, String expressionLanguage, String expressionLanguageVersion) throws SDMException {
        Map<String, ExpressionInterpreter<Expression, Classifier>> map = this.expressionInterpreters.get(expressionLanguage);
        if (map == null) {
            map = new ConcurrentHashMap<String, ExpressionInterpreter<Expression, Classifier>>();
            this.expressionInterpreters.put(expressionLanguage, map);
        }
        if (map.containsKey(expressionLanguageVersion)) {
            throw new SDMException("An expression interpreter for expression language '" + expressionLanguage + "' version '" + expressionLanguageVersion + "' is already registered.");
        }
        map.put(expressionLanguageVersion, expressionInterpreter);
        expressionInterpreter.setExpressionInterpreterManager(this);
    }

    protected ExpressionInterpreter<Expression, Classifier> getExpressionInterpreter(String expressionLanguage, String expressionLanguageVersion) {
        Map<String, ExpressionInterpreter<Expression, Classifier>> map = this.expressionInterpreters.get(expressionLanguage);
        if (map != null) {
            return map.get(expressionLanguageVersion);
        }
        return null;
    }
}

