/*
 * Decompiled with CFR 0.152.
 */
package de.mdelab.sdm.interpreter.core.patternmatcher.patternPartBased;

import de.mdelab.sdm.interpreter.core.SDMException;
import de.mdelab.sdm.interpreter.core.expressions.ExpressionInterpreterManager;
import de.mdelab.sdm.interpreter.core.facade.IClassifierFacade;
import de.mdelab.sdm.interpreter.core.facade.IInstanceFacade;
import de.mdelab.sdm.interpreter.core.facade.IStoryPatternFacade;
import de.mdelab.sdm.interpreter.core.facade.IStoryPatternObjectFacade;
import de.mdelab.sdm.interpreter.core.facade.MetamodelFacadeFactory;
import de.mdelab.sdm.interpreter.core.notifications.NotificationEmitter;
import de.mdelab.sdm.interpreter.core.patternmatcher.MatchingStrategy;
import de.mdelab.sdm.interpreter.core.patternmatcher.StoryPatternMatcher;
import de.mdelab.sdm.interpreter.core.patternmatcher.patternPartBased.CheckPatternPartTransaction;
import de.mdelab.sdm.interpreter.core.patternmatcher.patternPartBased.ECheckResult;
import de.mdelab.sdm.interpreter.core.patternmatcher.patternPartBased.MatchPatternPartTransaction;
import de.mdelab.sdm.interpreter.core.patternmatcher.patternPartBased.MatchState;
import de.mdelab.sdm.interpreter.core.patternmatcher.patternPartBased.MatchStoryPatternObjectTransaction;
import de.mdelab.sdm.interpreter.core.patternmatcher.patternPartBased.MatchTransaction;
import de.mdelab.sdm.interpreter.core.patternmatcher.patternPartBased.PatternPart;
import de.mdelab.sdm.interpreter.core.patternmatcher.patternPartBased.PatternPartTransaction;
import de.mdelab.sdm.interpreter.core.variables.Variable;
import de.mdelab.sdm.interpreter.core.variables.VariablesScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public abstract class PatternPartBasedMatcher<Activity, ActivityNode, ActivityEdge, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression>
extends StoryPatternMatcher<Activity, ActivityNode, ActivityEdge, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression> {
    protected final IStoryPatternObjectFacade<StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression> spoFacade;
    protected final IStoryPatternFacade<StoryPattern, StoryPatternObject, StoryPatternLink, Expression> spFacade;
    protected final IClassifierFacade<Classifier> classifierFacade;
    protected final IInstanceFacade<StoryPatternLink, Classifier, Feature, Expression> instanceFacade;
    protected final Map<StoryPatternObject, Set<Object>> matchingHistory;
    protected final Set<StoryPatternObject> boundSPO;
    protected final Set<StoryPatternObject> unboundSPO;
    protected final Set<PatternPart<StoryPatternObject, StoryPatternLink, Classifier, Expression>> checkedPatternParts;
    protected final Set<PatternPart<StoryPatternObject, StoryPatternLink, Classifier, Expression>> uncheckedPatternParts;
    protected final Set<Object> boundInstanceObjects;
    public final Stack<MatchTransaction> matchingStack;
    protected final Map<StoryPatternObject, List<PatternPart<StoryPatternObject, StoryPatternLink, Classifier, Expression>>> spoToPatternPartsMap;
    protected final Map<PatternPart<StoryPatternObject, StoryPatternLink, Classifier, Expression>, MatchState> patternPartMatchStates;

    public PatternPartBasedMatcher(StoryPattern storyPattern, VariablesScope<Activity, ActivityNode, ActivityEdge, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression> variablesScope, MatchingStrategy<StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression> matchingStrategy, MetamodelFacadeFactory<Activity, ActivityNode, ActivityEdge, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression> facadeFactory, ExpressionInterpreterManager<Activity, ActivityNode, ActivityEdge, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression> expressionInterpreterManager, NotificationEmitter<Activity, ActivityNode, ActivityEdge, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression> notificationEmitter) throws SDMException {
        super(storyPattern, variablesScope, matchingStrategy, facadeFactory, expressionInterpreterManager, notificationEmitter);
        this.getNotificationEmitter().storyPatternInitializationStarted(this.getStoryPattern(), this.getVariablesScope(), this);
        this.spFacade = facadeFactory.getStoryPatternFacade();
        this.spoFacade = facadeFactory.getStoryPatternObjectFacade();
        this.classifierFacade = facadeFactory.getClassifierFacade();
        this.instanceFacade = facadeFactory.getInstanceFacade();
        this.matchingHistory = new HashMap<StoryPatternObject, Set<Object>>();
        this.matchingStack = new Stack();
        this.boundSPO = new HashSet<StoryPatternObject>();
        this.unboundSPO = new HashSet<StoryPatternObject>();
        this.checkedPatternParts = new HashSet<PatternPart<StoryPatternObject, StoryPatternLink, Classifier, Expression>>();
        this.uncheckedPatternParts = new HashSet<PatternPart<StoryPatternObject, StoryPatternLink, Classifier, Expression>>();
        this.boundInstanceObjects = new HashSet<Object>();
        this.spoToPatternPartsMap = new HashMap<StoryPatternObject, List<PatternPart<StoryPatternObject, StoryPatternLink, Classifier, Expression>>>();
        this.patternPartMatchStates = new HashMap<PatternPart<StoryPatternObject, StoryPatternLink, Classifier, Expression>, MatchState>();
        this.initializePatternParts();
        this.getNotificationEmitter().storyPatternInitializationFinished(this.getStoryPattern(), this.getVariablesScope(), this);
    }

    protected void initializePatternParts() throws SDMException {
        Collection<PatternPart<StoryPatternObject, StoryPatternLink, Classifier, Expression>> patternParts = this.createPatternParts();
        for (PatternPart<StoryPatternObject, StoryPatternLink, Classifier, Expression> patternPart : patternParts) {
            this.uncheckedPatternParts.add(patternPart);
            StoryPatternObject[] StoryPatternObjectArray = patternPart.getStoryPatternObjects();
            int n = StoryPatternObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                StoryPatternObject spo = StoryPatternObjectArray[n2];
                List<PatternPart<StoryPatternObject, StoryPatternLink, Classifier, Expression>> list = this.spoToPatternPartsMap.get(spo);
                if (list == null) {
                    list = new ArrayList<PatternPart<StoryPatternObject, StoryPatternLink, Classifier, Expression>>();
                    this.spoToPatternPartsMap.put(spo, list);
                }
                list.add(patternPart);
                this.unboundSPO.add(spo);
                if (!this.matchingHistory.containsKey(spo)) {
                    this.matchingHistory.put(spo, new HashSet());
                }
                ++n2;
            }
        }
    }

    @Override
    public boolean findNextMatch() throws SDMException {
        this.getNotificationEmitter().storyPatternMatchingStarted(this.getStoryPattern(), this.getVariablesScope(), this);
        VariablesScope mainVariableScope = this.getVariablesScope();
        VariablesScope workingVariableScope = new VariablesScope(this.getNotificationEmitter(), mainVariableScope, Collections.EMPTY_MAP);
        this.setVariablesScope(workingVariableScope);
        boolean secondRun = false;
        if (!this.matchingStack.isEmpty()) {
            this.rollBackLastMatchPatternPartTransaction();
            secondRun = true;
        }
        this.rollBackInvalidStackElements();
        if (this.analyzeStoryPatternObjects() && this.checkAllUncheckedPatternParts() && (this.unboundSPO.size() != 0 || !secondRun) && this.findNextMatchForPattern()) {
            this.getVariablesScope().mergeIntoParentScope();
            this.setVariablesScope(mainVariableScope);
            this.patternPartMatchStates.clear();
            this.getNotificationEmitter().storyPatternMatchingSuccessful(this.getStoryPattern(), this.getVariablesScope(), this);
            return true;
        }
        this.setVariablesScope(mainVariableScope);
        this.getNotificationEmitter().storyPatternMatchingFailed(this.getStoryPattern(), this.getVariablesScope(), this);
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean analyzeStoryPatternObjects() throws SDMException {
        for (StoryPatternObject spo : new HashSet<StoryPatternObject>(this.unboundSPO)) {
            boolean bound = this.spoFacade.isBound(spo);
            if (!bound && this.spoFacade.isMaybeBound(spo)) {
                bound = this.getVariablesScope().variableExists(this.spoFacade.getName(spo));
            }
            if (bound) {
                Expression assignmentExpression = this.spoFacade.getAssignmentExpression(spo);
                Variable variable = null;
                if (assignmentExpression != null) {
                    Variable<Object> result = this.getExpressionInterpreterManager().evaluateExpression(this.spoFacade.getAssignmentExpression(spo), null, null, this.getVariablesScope());
                    if (result == null) throw new SDMException("The expression '" + this.spoFacade.getAssignmentExpression(spo) + "' could not be evaluated.");
                    variable = this.getVariablesScope().createVariable(this.spoFacade.getName(spo), this.spoFacade.getClassifier(spo), result.getValue());
                } else {
                    variable = this.getVariablesScope().getVariable(this.spoFacade.getName(spo));
                    if (variable == null) {
                        this.getNotificationEmitter().storyPatternObjectNotBound(spo, this.getVariablesScope(), this);
                        return false;
                    }
                }
                if (variable.getValue() != null && this.checkTypeConformance(this.spoFacade.getClassifier(spo), variable.getValue()) && this.checkIsomorphism(variable.getValue()) && this.checkStoryPatternObjectConstraints(spo, variable.getValue())) {
                    MatchStoryPatternObjectTransaction<StoryPatternObject> matchStoryPatternObjectTransaction = new MatchStoryPatternObjectTransaction<StoryPatternObject>(spo, variable.getValue(), this.unboundSPO, this.boundSPO, this.boundInstanceObjects);
                    matchStoryPatternObjectTransaction.commit();
                    this.matchingStack.push(matchStoryPatternObjectTransaction);
                    this.getNotificationEmitter().storyPatternObjectBound(spo, variable.getValue(), this.getVariablesScope(), this);
                    continue;
                }
                this.getNotificationEmitter().storyPatternObjectNotBound(spo, this.getVariablesScope(), this);
                return false;
            }
            this.getVariablesScope().deleteVariable(this.spoFacade.getName(spo));
        }
        return true;
    }

    protected void rollBackInvalidStackElements() throws SDMException {
        for (MatchTransaction matchTransaction : this.matchingStack) {
            MatchTransaction mt;
            if (matchTransaction instanceof MatchStoryPatternObjectTransaction) {
                mt = (MatchStoryPatternObjectTransaction)matchTransaction;
                Variable variable = this.getVariablesScope().getVariable(this.spoFacade.getName(((MatchStoryPatternObjectTransaction)mt).getStoryPatternObject()));
                if (variable != null && variable.getValue() == ((MatchStoryPatternObjectTransaction)mt).getInstanceObject() && this.checkStoryPatternObjectConstraints(((MatchStoryPatternObjectTransaction)mt).getStoryPatternObject(), ((MatchStoryPatternObjectTransaction)mt).getInstanceObject())) continue;
                this.rollBack(matchTransaction);
                this.rollBackLastMatchPatternPartTransaction();
                break;
            }
            if (matchTransaction instanceof MatchPatternPartTransaction || matchTransaction instanceof CheckPatternPartTransaction) {
                mt = (PatternPartTransaction)matchTransaction;
                boolean variablesExist = true;
                StoryPatternObject[] StoryPatternObjectArray = ((PatternPartTransaction)mt).getPatternPart().getStoryPatternObjects();
                int n = StoryPatternObjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object spo = StoryPatternObjectArray[n2];
                    if (!this.getVariablesScope().variableExists(this.spoFacade.getName(spo))) {
                        variablesExist = false;
                        break;
                    }
                    ++n2;
                }
                if (variablesExist && ((PatternPartTransaction)mt).getPatternPart().check() == ECheckResult.OK) continue;
                this.rollBack(matchTransaction);
                if (matchTransaction instanceof MatchPatternPartTransaction) break;
                this.rollBackLastMatchPatternPartTransaction();
                break;
            }
            throw new UnsupportedOperationException();
        }
    }

    protected boolean findNextMatchForPattern() throws SDMException {
        boolean match = true;
        MatchingStrategy matchingStrategy = this.getMatchingStrategy();
        while (true) {
            PatternPart nextPatternPart;
            if ((nextPatternPart = matchingStrategy.getNextPatternPartForMatching(this.uncheckedPatternParts)) != null) {
                MatchPatternPartTransaction matchPatternPartTransaction = new MatchPatternPartTransaction(nextPatternPart, this.uncheckedPatternParts, this.checkedPatternParts);
                matchPatternPartTransaction.commit();
                this.matchingStack.push(matchPatternPartTransaction);
                MatchState matchState = this.patternPartMatchStates.get(nextPatternPart);
                if (matchState == null) {
                    matchState = nextPatternPart.createMatchState();
                    this.patternPartMatchStates.put(nextPatternPart, matchState);
                }
                match = nextPatternPart.match(matchState);
                switch (nextPatternPart.getMatchType()) {
                    case MANDATORY: {
                        break;
                    }
                    case OPTIONAL: {
                        match = true;
                    }
                }
                if (match) continue;
                this.patternPartMatchStates.remove(nextPatternPart);
                this.rollBack(matchPatternPartTransaction);
                this.rollBackLastMatchPatternPartTransaction();
                if (!this.matchingStack.isEmpty()) {
                    continue;
                }
            }
            if (match && !(match = this.checkStoryPatternConstraints())) {
                this.rollBackLastMatchPatternPartTransaction();
            }
            if (this.matchingStack.isEmpty() || match) break;
        }
        return match;
    }

    public boolean checkStoryPatternObjectConstraints(StoryPatternObject spo, Object instanceObject) throws SDMException {
        assert (spo != null);
        for (Expression constraint : this.spoFacade.getConstraints(spo)) {
            Variable result = this.getExpressionInterpreterManager().evaluateExpression(constraint, this.spoFacade.getClassifier(spo), instanceObject, this.getVariablesScope());
            if (((Boolean)result.getValue()).booleanValue()) {
                this.getNotificationEmitter().storyPatternObjectConstraintHolds(constraint, spo, this.getVariablesScope(), this);
                continue;
            }
            this.getNotificationEmitter().storyPatternObjectConstraintViolated(constraint, spo, this.getVariablesScope(), this);
            return false;
        }
        return true;
    }

    protected boolean checkStoryPatternConstraints() throws SDMException {
        for (Expression constraint : this.spFacade.getConstraints(this.getStoryPattern())) {
            Variable<Object> result = this.getExpressionInterpreterManager().evaluateExpression(constraint, null, null, this.getVariablesScope());
            if (result.getValue() != Boolean.TRUE) {
                this.getNotificationEmitter().storyPatternConstraintViolated(constraint, this.getStoryPattern(), this.getVariablesScope(), this);
                return false;
            }
            this.getNotificationEmitter().storyPatternConstraintHolds(constraint, this.getStoryPattern(), this.getVariablesScope(), this);
        }
        return true;
    }

    public boolean checkIsomorphism(Object instanceObject) {
        assert (instanceObject != null);
        return !this.boundInstanceObjects.contains(instanceObject);
    }

    public boolean checkTypeConformance(Classifier classifier, Object instanceObject) {
        assert (classifier != null);
        assert (instanceObject != null);
        return this.classifierFacade.isInstance(classifier, instanceObject);
    }

    public boolean checkHistory(StoryPatternObject storyPatternObject, Object instanceObject) {
        assert (storyPatternObject != null);
        assert (instanceObject != null);
        return !this.matchingHistory.get(storyPatternObject).contains(instanceObject);
    }

    public boolean matchStoryPatternObject(StoryPatternObject storyPatternObject, Object instanceObject) throws SDMException {
        assert (storyPatternObject != null);
        assert (this.unboundSPO.contains(storyPatternObject));
        assert (!this.boundSPO.contains(storyPatternObject));
        int stackSize = this.matchingStack.size();
        if (instanceObject != null && this.checkIsomorphism(instanceObject) && this.checkTypeConformance(this.spoFacade.getClassifier(storyPatternObject), instanceObject) && this.checkHistory(storyPatternObject, instanceObject)) {
            MatchStoryPatternObjectTransaction<StoryPatternObject> matchStoryPatternObjectTransaction = new MatchStoryPatternObjectTransaction<StoryPatternObject>(storyPatternObject, instanceObject, this.unboundSPO, this.boundSPO, this.boundInstanceObjects);
            matchStoryPatternObjectTransaction.commit();
            this.matchingStack.push(matchStoryPatternObjectTransaction);
            this.matchingHistory.get(storyPatternObject).add(instanceObject);
            this.getVariablesScope().createVariable(this.spoFacade.getName(storyPatternObject), this.spoFacade.getClassifier(storyPatternObject), instanceObject);
            if (this.checkUncheckedPatternParts(storyPatternObject) && this.checkStoryPatternObjectConstraints(storyPatternObject, instanceObject)) {
                return true;
            }
            this.rollBack(matchStoryPatternObjectTransaction);
            assert (stackSize == this.matchingStack.size());
            return false;
        }
        assert (stackSize == this.matchingStack.size());
        return false;
    }

    public void rollBack(MatchTransaction matchTransaction) {
        assert (matchTransaction != null);
        MatchTransaction mt = null;
        while (!this.matchingStack.isEmpty() && mt != matchTransaction) {
            mt = this.matchingStack.pop();
            if (mt instanceof MatchStoryPatternObjectTransaction) {
                MatchStoryPatternObjectTransaction mspot = (MatchStoryPatternObjectTransaction)mt;
                this.getVariablesScope().deleteVariable(this.spoFacade.getName(mspot.getStoryPatternObject()));
                this.getNotificationEmitter().storyPatternObjectBindingRevoked(mspot.getStoryPatternObject(), mspot.getInstanceObject(), this.getVariablesScope(), this);
                for (StoryPatternObject s : this.unboundSPO) {
                    this.matchingHistory.get(s).clear();
                }
            }
            mt.rollBack();
        }
    }

    public void rollBackLastMatchPatternPartTransaction() {
        int i = this.matchingStack.size() - 1;
        while (i >= 0) {
            MatchTransaction mt = (MatchTransaction)this.matchingStack.get(i);
            this.rollBack(mt);
            if (mt instanceof MatchPatternPartTransaction) {
                return;
            }
            --i;
        }
        if (!this.matchingStack.isEmpty()) {
            this.rollBack((MatchTransaction)this.matchingStack.get(0));
        }
    }

    public void rollBackLastMatchTransaction() {
        this.rollBack(this.matchingStack.peek());
    }

    public void rollBackLastMatchStoryPatternObjectTransaction() {
        while (!(this.matchingStack.peek() instanceof MatchStoryPatternObjectTransaction)) {
            this.rollBack(this.matchingStack.peek());
        }
        this.rollBack(this.matchingStack.peek());
    }

    protected ECheckResult checkPatternPart(PatternPart<StoryPatternObject, StoryPatternLink, Classifier, Expression> patternPart) throws SDMException {
        assert (patternPart != null);
        ECheckResult result = ECheckResult.OK;
        result = patternPart.check();
        block0 : switch (patternPart.getMatchType()) {
            case OPTIONAL: {
                switch (result) {
                    case OK: 
                    case UNKNOWN: {
                        break block0;
                    }
                    case FAIL: {
                        result = ECheckResult.OK;
                    }
                }
            }
        }
        if (result == ECheckResult.OK) {
            CheckPatternPartTransaction<StoryPatternObject, StoryPatternLink, Classifier, Expression> checkPatternPartTransaction = new CheckPatternPartTransaction<StoryPatternObject, StoryPatternLink, Classifier, Expression>(patternPart, this.uncheckedPatternParts, this.checkedPatternParts);
            checkPatternPartTransaction.commit();
            this.matchingStack.push(checkPatternPartTransaction);
        }
        return result;
    }

    protected boolean checkUncheckedPatternParts(StoryPatternObject storyPatternObject) throws SDMException {
        for (PatternPart<StoryPatternObject, StoryPatternLink, Classifier, Expression> patternPart : this.spoToPatternPartsMap.get(storyPatternObject)) {
            if (!this.uncheckedPatternParts.contains(patternPart) || this.checkPatternPart(patternPart) != ECheckResult.FAIL) continue;
            return false;
        }
        return true;
    }

    protected boolean checkAllUncheckedPatternParts() throws SDMException {
        for (PatternPart<StoryPatternObject, StoryPatternLink, Classifier, Expression> patternPart : new ArrayList<PatternPart<StoryPatternObject, StoryPatternLink, Classifier, Expression>>(this.uncheckedPatternParts)) {
            if (this.checkPatternPart(patternPart) != ECheckResult.FAIL) continue;
            return false;
        }
        return true;
    }

    public boolean isBound(StoryPatternObject storyPatternObject) {
        return this.boundSPO.contains(storyPatternObject);
    }

    public Object getInstanceObject(StoryPatternObject storyPatternObject) {
        assert (this.getVariablesScope().variableExists(this.spoFacade.getName(storyPatternObject)));
        return this.getVariablesScope().getVariable(this.spoFacade.getName(storyPatternObject)).getValue();
    }

    @Override
    public void applyMatch() throws SDMException {
        this.getNotificationEmitter().storyPatternApplicationStarted(this.getStoryPattern(), this.getVariablesScope(), this);
        Collection<AttributeAssignmentTuple> assignments = this.calculateNewAttributeValues(this.spFacade.getStoryPatternObjects(this.getStoryPattern()));
        this.deleteElements();
        this.createElements();
        this.assignAttributeValues(assignments);
        this.getNotificationEmitter().storyPatternApplicationFinished(this.getStoryPattern(), this.getVariablesScope(), this);
    }

    protected Collection<AttributeAssignmentTuple> calculateNewAttributeValues(Collection<StoryPatternObject> storyPatternObjects) throws SDMException {
        LinkedList<AttributeAssignmentTuple> returnValues = new LinkedList<AttributeAssignmentTuple>();
        for (StoryPatternObject spo : storyPatternObjects) {
            Map<Feature, Expression> map = this.spoFacade.getAttributeAssignments(spo);
            if (map == null) continue;
            for (Map.Entry<Feature, Expression> entry : map.entrySet()) {
                Variable spoVariable = this.getVariablesScope().getVariable(this.spoFacade.getName(spo));
                assert (spoVariable != null || this.spoFacade.isCreate(spo));
                Variable<Object> attributeValueVariable = null;
                attributeValueVariable = spoVariable == null ? this.getExpressionInterpreterManager().evaluateExpression(entry.getValue(), null, null, this.getVariablesScope()) : this.getExpressionInterpreterManager().evaluateExpression(entry.getValue(), this.spoFacade.getClassifier(spo), spoVariable.getValue(), this.getVariablesScope());
                assert (attributeValueVariable != null);
                AttributeAssignmentTuple at = new AttributeAssignmentTuple();
                at.storyPatternObject = spo;
                at.feature = entry.getKey();
                at.newValue = attributeValueVariable.getValue();
                returnValues.add(at);
            }
        }
        return returnValues;
    }

    protected void deleteElements() {
        HashMap<StoryPatternObject, Object> deletedObjects = new HashMap<StoryPatternObject, Object>();
        for (StoryPatternObject StoryPatternObject : this.boundSPO) {
            if (!this.spoFacade.isDestroy(StoryPatternObject)) continue;
            Variable variable = this.getVariablesScope().getVariable(this.spoFacade.getName(StoryPatternObject));
            assert (variable != null);
            deletedObjects.put(StoryPatternObject, variable.getValue());
        }
        for (PatternPart patternPart : this.checkedPatternParts) {
            patternPart.destroyObjects();
        }
        for (PatternPart patternPart : this.checkedPatternParts) {
            patternPart.destroyLinks(deletedObjects);
        }
    }

    protected void createElements() throws SDMException {
        for (StoryPatternObject StoryPatternObject : this.spoToPatternPartsMap.keySet()) {
            if (!this.spoFacade.isCreate(StoryPatternObject) || this.spoFacade.isOptional(StoryPatternObject)) continue;
            this.getVariablesScope().deleteVariable(this.spoFacade.getName(StoryPatternObject));
        }
        for (PatternPart patternPart : this.checkedPatternParts) {
            patternPart.createObjects();
            patternPart.createLinks();
        }
    }

    protected void assignAttributeValues(Collection<AttributeAssignmentTuple> assignments) throws SDMException {
        for (AttributeAssignmentTuple at : assignments) {
            Variable variable = this.getVariablesScope().getVariable(this.spoFacade.getName(at.storyPatternObject));
            assert (variable != null);
            this.instanceFacade.setAttributeValue(variable.getValue(), at.feature, at.newValue);
            this.getNotificationEmitter().attributeValueSet(at.storyPatternObject, variable.getValue(), at.feature, at.newValue, this.getVariablesScope(), this);
        }
    }

    protected abstract Collection<PatternPart<StoryPatternObject, StoryPatternLink, Classifier, Expression>> createPatternParts();

    protected class AttributeAssignmentTuple {
        public StoryPatternObject storyPatternObject;
        public Feature feature;
        public Object newValue;

        protected AttributeAssignmentTuple() {
        }
    }
}

