/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.dao.impl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.palladiosimulator.edp2.dao.MeasurementsDao;
import org.palladiosimulator.edp2.dao.MeasurementsDaoRegistry;

public class MeasurementsDaoRegistryImpl
implements MeasurementsDaoRegistry {
    private static final Logger LOGGER = Logger.getLogger(MeasurementsDaoRegistryImpl.class.getCanonicalName());
    private ConcurrentMap<String, MeasurementsDao<?, ?>> registeredDaos = new ConcurrentHashMap();

    @Override
    public void deregister(String uuid) {
        if (!this.isRegistered(uuid)) {
            String msg = "Tried to deregister a DAO which was not registered. UUID was " + uuid + ".";
            LOGGER.log(Level.SEVERE, msg);
            throw new IllegalArgumentException(msg);
        }
        this.registeredDaos.remove(uuid);
    }

    @Override
    public boolean isRegistered(String uuid) {
        return this.registeredDaos.containsKey(uuid);
    }

    @Override
    public void register(MeasurementsDao<?, ?> dao, String uuid) {
        if (this.isRegistered(uuid)) {
            String msg = "Tried to register a DAO which was already registered. UUID was " + uuid + ".";
            LOGGER.log(Level.SEVERE, msg);
            throw new IllegalArgumentException(msg);
        }
        this.registeredDaos.put(uuid, dao);
    }

    @Override
    public MeasurementsDao<?, ?> getMeasurementsDao(String uuid) {
        return (MeasurementsDao)this.registeredDaos.get(uuid);
    }

    @Override
    public Set<String> getRegisteredUuids() {
        HashSet<String> returnSet = new HashSet<String>();
        Iterator listIterator = this.registeredDaos.keySet().iterator();
        while (listIterator.hasNext()) {
            returnSet.add((String)listIterator.next());
        }
        return this.registeredDaos.keySet();
    }
}

