/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.variables.functions;

import de.uka.ipd.sdq.probfunction.math.ILognormalDistribution;
import de.uka.ipd.sdq.probfunction.math.IPDFFactory;
import de.uka.ipd.sdq.probfunction.math.IRandomGenerator;
import de.uka.ipd.sdq.simucomframework.variables.converter.NumberConverter;
import de.uka.ipd.sdq.simucomframework.variables.functions.AbstractProbDistFunction;
import java.util.List;

public class LogNormDistFunction
extends AbstractProbDistFunction {
    public LogNormDistFunction(IRandomGenerator randomGen, IPDFFactory factory) {
        super(randomGen, factory);
    }

    @Override
    public boolean checkParameters(List<Object> parameters) {
        if (parameters.size() != 2) {
            return false;
        }
        if (NumberConverter.toDouble(parameters.get(1)) <= 0.0) {
            return false;
        }
        NumberConverter.toDouble(parameters.get(0));
        return true;
    }

    @Override
    public Object evaluate(List<Object> parameters) {
        double mu = NumberConverter.toDouble(parameters.get(0));
        double sigma = NumberConverter.toDouble(parameters.get(1));
        ILognormalDistribution distribution = this.factory.createLognormalDistribution(mu, sigma);
        return distribution.inverseF(this.randomGen.random());
    }
}

