/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.variables.functions;

import de.uka.ipd.sdq.simucomframework.variables.functions.IFunction;
import java.util.List;
import org.apache.log4j.Logger;

public class MinFunction
implements IFunction {
    private static final Logger LOGGER = Logger.getLogger(MinFunction.class);
    public static final String MIN_FUNCTION_NAME = "Min";

    @Override
    public boolean checkParameters(List<Object> parameters) {
        if (parameters.size() != 2) {
            return false;
        }
        boolean valid = false;
        valid = this.parameterIsNumber(parameters.get(0)) || parameters.get(0) instanceof String;
        valid &= this.parameterIsNumber(parameters.get(1));
        return valid &= parameters.get(0).getClass().isInstance(parameters.get(1));
    }

    private boolean parameterIsNumber(Object obj) {
        boolean valid = false;
        if (obj instanceof Integer || obj instanceof Long || obj instanceof Float || obj instanceof Double) {
            valid = true;
        }
        return valid;
    }

    @Override
    public Object evaluate(List<Object> parameters) {
        if (parameters.get(0) instanceof Double || parameters.get(1) instanceof Double) {
            return Math.min((Double)parameters.get(0), (Double)parameters.get(1));
        }
        if (parameters.get(0) instanceof Long || parameters.get(1) instanceof Long) {
            return Math.min((Long)parameters.get(0), (Long)parameters.get(1));
        }
        if (parameters.get(0) instanceof Integer || parameters.get(1) instanceof Integer) {
            return Math.min((Integer)parameters.get(0), (Integer)parameters.get(1));
        }
        if (parameters.get(0) instanceof Float || parameters.get(1) instanceof Float) {
            return Float.valueOf(Math.min(((Float)parameters.get(0)).floatValue(), ((Float)parameters.get(1)).floatValue()));
        }
        if (parameters.get(0) instanceof String) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"String/Enum-based parameter was provided to Min function. The parameter will be returned directly.");
            }
            return parameters.get(0);
        }
        throw new IllegalArgumentException("Both parameters must have the same type and have one of the type Integer, Long, Float, or Double.");
    }
}

