/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.variables.functions;

import de.uka.ipd.sdq.probfunction.math.IPDFFactory;
import de.uka.ipd.sdq.probfunction.math.IRandomGenerator;
import de.uka.ipd.sdq.probfunction.math.IUniformDistribution;
import de.uka.ipd.sdq.simucomframework.variables.converter.NumberConverter;
import de.uka.ipd.sdq.simucomframework.variables.functions.AbstractProbDistFunction;
import java.util.List;

public class UniDoubleDistFunction
extends AbstractProbDistFunction {
    public UniDoubleDistFunction(IRandomGenerator random, IPDFFactory factory) {
        super(random, factory);
    }

    @Override
    public boolean checkParameters(List<Object> parameters) {
        if (parameters.size() != 2) {
            return false;
        }
        return !(NumberConverter.toDouble(parameters.get(0)) > NumberConverter.toDouble(parameters.get(1)));
    }

    @Override
    public Object evaluate(List<Object> parameters) {
        double a = NumberConverter.toDouble(parameters.get(0));
        double b = NumberConverter.toDouble(parameters.get(1));
        IUniformDistribution distribution = this.factory.createUniformDistribution(a, b);
        return distribution.inverseF(this.randomGen.random());
    }
}

