/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.probfunction.math.apache.impl;

import de.uka.ipd.sdq.probfunction.math.IDiscretePDF;
import de.uka.ipd.sdq.probfunction.math.IProbabilityDensityFunction;
import de.uka.ipd.sdq.probfunction.math.IRandomGenerator;
import de.uka.ipd.sdq.probfunction.math.IUnit;
import de.uka.ipd.sdq.probfunction.math.exception.DomainNotNumbersException;
import de.uka.ipd.sdq.probfunction.math.exception.FunctionNotInFrequencyDomainException;
import de.uka.ipd.sdq.probfunction.math.exception.FunctionNotInTimeDomainException;
import de.uka.ipd.sdq.probfunction.math.exception.FunctionsInDifferenDomainsException;
import de.uka.ipd.sdq.probfunction.math.exception.IncompatibleUnitsException;
import de.uka.ipd.sdq.probfunction.math.exception.InvalidSampleValueException;
import de.uka.ipd.sdq.probfunction.math.exception.NegativeDistanceException;
import de.uka.ipd.sdq.probfunction.math.exception.ProbabilityFunctionException;
import de.uka.ipd.sdq.probfunction.math.exception.ProbabilitySumNotOneException;
import de.uka.ipd.sdq.probfunction.math.exception.UnitNameNotSetException;
import de.uka.ipd.sdq.probfunction.math.exception.UnitNotSetException;
import de.uka.ipd.sdq.probfunction.math.exception.UnknownPDFTypeException;
import de.uka.ipd.sdq.probfunction.math.impl.DefaultRandomGenerator;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.AbstractIntegerDistribution;

public abstract class AbstractDiscretePDF
implements IDiscretePDF {
    protected AbstractIntegerDistribution internalFunction = null;
    protected IRandomGenerator sampleDrawer = new DefaultRandomGenerator();

    @Override
    public double cdf(int x) {
        try {
            return this.internalFunction.cumulativeProbability(x);
        }
        catch (MathException e) {
            throw new ProbabilityFunctionException(e.getLocalizedMessage());
        }
    }

    public double getCoefficientOfVariance() {
        return this.getStandardDeviation() / this.getArithmeticMeanValue();
    }

    @Override
    public double getVariance() {
        double std = this.getStandardDeviation();
        return std * std;
    }

    @Override
    public double getProbabilitySum() {
        return 1.0;
    }

    @Override
    public double probability(int x) {
        return this.internalFunction.probability(x);
    }

    @Override
    public boolean isInFrequencyDomain() {
        return false;
    }

    @Override
    public boolean isInTimeDomain() {
        return true;
    }

    public double cdf(double x) {
        try {
            return this.internalFunction.cumulativeProbability(x);
        }
        catch (MathException e) {
            throw new ProbabilityFunctionException(e.getLocalizedMessage());
        }
    }

    @Override
    public double drawSample() {
        if (this.sampleDrawer == null) {
            throw new ProbabilityFunctionException("RNG was not set!");
        }
        try {
            return this.internalFunction.inverseCumulativeProbability(this.sampleDrawer.random());
        }
        catch (MathException e) {
            throw new ProbabilityFunctionException(e.getLocalizedMessage());
        }
    }

    @Override
    public int inverseF(double u) {
        try {
            return this.internalFunction.inverseCumulativeProbability(u);
        }
        catch (MathException e) {
            e.printStackTrace();
            throw new ProbabilityFunctionException(e.getLocalizedMessage());
        }
    }

    @Override
    public IUnit getUnit() {
        return null;
    }

    @Override
    public IProbabilityDensityFunction add(IProbabilityDensityFunction pdf) throws FunctionsInDifferenDomainsException, UnknownPDFTypeException, IncompatibleUnitsException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IProbabilityDensityFunction div(IProbabilityDensityFunction pdf) throws FunctionsInDifferenDomainsException, UnknownPDFTypeException, IncompatibleUnitsException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IProbabilityDensityFunction getCumulativeFunction() throws FunctionNotInTimeDomainException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IProbabilityDensityFunction getFourierTransform() throws FunctionNotInTimeDomainException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IProbabilityDensityFunction getInverseFourierTransform() throws FunctionNotInFrequencyDomainException {
        throw new UnsupportedOperationException();
    }

    @Override
    public double greaterThan(IProbabilityDensityFunction pdf) throws ProbabilityFunctionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public double lessThan(IProbabilityDensityFunction pdf) throws ProbabilityFunctionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IProbabilityDensityFunction mult(IProbabilityDensityFunction pdf) throws FunctionsInDifferenDomainsException, UnknownPDFTypeException, IncompatibleUnitsException {
        throw new UnsupportedOperationException();
    }

    @Override
    public double probabilisticEquals(IProbabilityDensityFunction pdf) throws ProbabilityFunctionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IProbabilityDensityFunction scale(double scalar) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IProbabilityDensityFunction shiftDomain(double scalar) throws DomainNotNumbersException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IProbabilityDensityFunction stretchDomain(double scalar) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IProbabilityDensityFunction sub(IProbabilityDensityFunction pdf) throws FunctionsInDifferenDomainsException, UnknownPDFTypeException, IncompatibleUnitsException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkConstrains() throws NegativeDistanceException, ProbabilitySumNotOneException, FunctionNotInTimeDomainException, UnitNotSetException, UnitNameNotSetException, InvalidSampleValueException {
        throw new UnsupportedOperationException();
    }
}

