/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.probfunction.math.apache.impl;

import de.uka.ipd.sdq.probfunction.math.random.IRandomStream;
import org.apache.commons.math.random.RandomGenerator;
import org.apache.log4j.Logger;

public class ApacheMathRandomGenerator
implements IRandomStream {
    private static final Logger LOGGER = Logger.getLogger(ApacheMathRandomGenerator.class);
    protected RandomGenerator rng;

    public ApacheMathRandomGenerator(RandomGenerator rng) {
        this.rng = rng;
    }

    @Override
    public void setSeed(int[] seed) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Random number generator about to get initialized");
            StringBuffer sb = new StringBuffer();
            int[] nArray = seed;
            int n = seed.length;
            int n2 = 0;
            while (n2 < n) {
                int s = nArray[n2];
                sb.append(String.valueOf(s) + " ");
                ++n2;
            }
            LOGGER.debug((Object)("Seed is " + sb.toString()));
        }
        this.rng.setSeed(seed);
    }

    @Override
    public double nextDouble() {
        return this.rng.nextDouble();
    }

    @Override
    public void setSeed(long[] seed) {
        int[] intSeed = new int[seed.length];
        int i = 0;
        while (i < seed.length) {
            long s = seed[i];
            if (s < Integer.MIN_VALUE || s > Integer.MAX_VALUE) {
                throw new IllegalArgumentException(String.valueOf(s) + " cannot be cast to int without changing its value.");
            }
            intSeed[i] = (int)s;
            ++i;
        }
        this.setSeed(intSeed);
    }
}

