/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.editors.sirius.ui.wizard.model;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RepresentationCreationPage
extends WizardPage
implements SelectionListener,
ModifyListener {
    private static final String PAGE_NAME = "Model creation";
    private static final String ENABLE = "Create representation";
    private static final String REPRESENTATION_NAME = "Representation name:";
    private static final String TITLE = "Create representation";
    private static final String MESSAGE = "Select whether you want to create a representation";
    private String DEFAULT_REPRESENTATION_NAME = "new representation";
    private Button enabledCheckbox;
    private Text representationNameInput;
    private Composite representationComposite;

    protected RepresentationCreationPage() {
        super(PAGE_NAME);
        this.setTitle("Create representation");
        this.setMessage(MESSAGE);
    }

    public boolean isPageComplete() {
        return !this.enabledCheckbox.getSelection() || this.representationNameInput.getText() != null && !this.representationNameInput.getText().equals("");
    }

    private void setEnabled(boolean enabled) {
        this.enabledCheckbox.setSelection(enabled);
        this.representationComposite.setEnabled(enabled);
    }

    public void setDefaultRepresentationName(String defaultRepresentationName) {
        this.DEFAULT_REPRESENTATION_NAME = defaultRepresentationName;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.enabledCheckbox = new Button(composite, 32);
        this.enabledCheckbox.setLayoutData((Object)new GridData(32));
        this.enabledCheckbox.setText("Create representation");
        this.enabledCheckbox.addSelectionListener((SelectionListener)this);
        this.representationComposite = new Composite(composite, 2048);
        this.representationComposite.setEnabled(false);
        this.representationComposite.setLayoutData((Object)new GridData(768));
        GridLayout representationLayout = new GridLayout();
        representationLayout.marginHeight = 10;
        representationLayout.marginWidth = 10;
        this.representationComposite.setLayout((Layout)representationLayout);
        Label label = new Label(this.representationComposite, 0);
        label.setText(REPRESENTATION_NAME);
        label.setLayoutData((Object)new GridData(256));
        this.representationNameInput = new Text(this.representationComposite, 2052);
        this.representationNameInput.setLayoutData((Object)new GridData(768));
        this.representationNameInput.addModifyListener((ModifyListener)this);
        this.representationNameInput.setText(this.DEFAULT_REPRESENTATION_NAME);
        this.setEnabled(true);
        this.setControl((Control)composite);
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.enabledCheckbox.equals(e.getSource())) {
            this.setEnabled(((Button)e.getSource()).getSelection());
        }
        this.getWizard().getContainer().updateButtons();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public String getRepresentationName() {
        return this.representationNameInput.getText();
    }

    public boolean isRepresentationCreationEnabled() {
        return this.enabledCheckbox.getSelection();
    }

    public void modifyText(ModifyEvent e) {
        this.getWizard().getContainer().updateButtons();
    }
}

