/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.editors.sirius.custom.externaljavaactions;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.tools.api.ui.IExternalJavaAction;
import org.eclipse.ui.PlatformUI;
import org.palladiosimulator.architecturaltemplates.AT;
import org.palladiosimulator.architecturaltemplates.api.ArchitecturalTemplateAPI;
import org.palladiosimulator.architecturaltemplates.ui.dialogs.ArchitecturalTemplateSelectionDialog;
import org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment;
import org.palladiosimulator.pcm.system.System;

public class AddATAction
implements IExternalJavaAction {
    private static final String DIALOG_MESSAGE = "Select the Architectural Template to be applied";

    public void execute(Collection<? extends EObject> selections, Map<String, Object> parameters) {
        ArchitecturalTemplateSelectionDialog profileSelectionDialog = new ArchitecturalTemplateSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        profileSelectionDialog.setElements((Object[])ArchitecturalTemplateAPI.getRegisteredArchitecturalTemplates().toArray(new AT[ArchitecturalTemplateAPI.getRegisteredArchitecturalTemplates().size()]));
        profileSelectionDialog.setMessage(DIALOG_MESSAGE);
        if (profileSelectionDialog.open() != 0) {
            return;
        }
        AT at = profileSelectionDialog.getResultArchitecturalTemplate();
        EObject eObject = selections.iterator().next();
        if (eObject instanceof System) {
            System system = (System)eObject;
            ArchitecturalTemplateAPI.applyArchitecturalTemplate((System)system, (AT)at);
        } else if (eObject instanceof ResourceEnvironment) {
            ResourceEnvironment resourceenvironment = (ResourceEnvironment)eObject;
            ArchitecturalTemplateAPI.applyArchitecturalTemplate((ResourceEnvironment)resourceenvironment, (AT)at);
        } else {
            throw new RuntimeException("Unsupported eObject: " + eObject);
        }
    }

    public boolean canExecute(Collection<? extends EObject> selections) {
        if (selections.size() != 1) {
            return false;
        }
        Iterator<? extends EObject> iterator = selections.iterator();
        if (iterator.hasNext()) {
            EObject object = iterator.next();
            return object instanceof System || object instanceof ResourceEnvironment;
        }
        return false;
    }
}

