/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.editors.sirius.custom.externaljavaactions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.tools.api.ui.IExternalJavaAction;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.palladiosimulator.editors.sirius.custom.util.SiriusCustomUtil;

public class OpenRepresentation
implements IExternalJavaAction {
    public void execute(Collection<? extends EObject> selections, Map<String, Object> parameters) {
        EObject semantic = (EObject)parameters.get("element");
        Session session = SessionManager.INSTANCE.getSession(semantic);
        String viewpointName = (String)parameters.get("Viewpoint");
        String representationDescriptionName = (String)parameters.get("RepresentationDescription");
        String diagramName = (String)parameters.get("Diagram name");
        ArrayList<String> selectedViewpoints = new ArrayList<String>();
        selectedViewpoints.add(viewpointName);
        SiriusCustomUtil.selectViewpoints(session, selectedViewpoints, false, (IProgressMonitor)new NullProgressMonitor());
        Viewpoint viewpoint = SiriusCustomUtil.getSelectedViewpointByName(session, viewpointName);
        RepresentationDescription description = SiriusCustomUtil.findDescription(viewpoint, representationDescriptionName);
        Collection representations = DialectManager.INSTANCE.getRepresentations(semantic, session);
        if (representations.isEmpty()) {
            String representationName = null;
            representationName = diagramName != null && !diagramName.isEmpty() ? diagramName : (description.getLabel() == null ? description.getName() : description.getLabel());
            DRepresentation representation = SiriusCustomUtil.createRepresentation(session, representationName, description, semantic, (IProgressMonitor)new NullProgressMonitor());
            DialectUIManager.INSTANCE.openEditor(session, representation, (IProgressMonitor)new NullProgressMonitor());
        } else {
            for (DRepresentation representation : representations) {
                DialectUIManager.INSTANCE.openEditor(session, representation, (IProgressMonitor)new NullProgressMonitor());
            }
        }
    }

    public boolean canExecute(Collection<? extends EObject> selections) {
        return true;
    }
}

