/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.converter;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.dataflowanalysis.dfd.datadictionary.AND;
import org.dataflowanalysis.dfd.datadictionary.DataDictionary;
import org.dataflowanalysis.dfd.datadictionary.Label;
import org.dataflowanalysis.dfd.datadictionary.LabelReference;
import org.dataflowanalysis.dfd.datadictionary.LabelType;
import org.dataflowanalysis.dfd.datadictionary.NOT;
import org.dataflowanalysis.dfd.datadictionary.OR;
import org.dataflowanalysis.dfd.datadictionary.TRUE;
import org.dataflowanalysis.dfd.datadictionary.Term;
import org.dataflowanalysis.dfd.datadictionary.datadictionaryFactory;

public class BehaviorConverter {
    private final datadictionaryFactory ddFactory = datadictionaryFactory.eINSTANCE;
    private DataDictionary dataDictionary;
    private final Logger logger = Logger.getLogger(BehaviorConverter.class);
    private final String LOGICAL_AND = "&&";
    private final String LOGICAL_OR = "||";
    private final String LOGICAL_NOT = "!";

    public BehaviorConverter(DataDictionary dataDictionary) {
        this.dataDictionary = dataDictionary;
    }

    public Term stringToTerm(String expression) {
        List<String> tokens = this.tokenize(expression);
        Stack<Term> operands = new Stack<Term>();
        Stack<String> operators = new Stack<String>();
        for (String token : tokens) {
            if (token.equals("(")) {
                operators.push(token);
                continue;
            }
            if (token.equals(")")) {
                while (!operators.isEmpty() && !((String)operators.peek()).equals("(")) {
                    this.performOperation(operands, (String)operators.pop());
                }
                operators.pop();
                continue;
            }
            if (this.isOperator(token)) {
                while (!operators.isEmpty() && this.precedence((String)operators.peek()) >= this.precedence(token)) {
                    this.performOperation(operands, (String)operators.pop());
                }
                operators.push(token);
                continue;
            }
            operands.push(this.createTerm(token));
        }
        while (!operators.isEmpty()) {
            this.performOperation(operands, (String)operators.pop());
        }
        return (Term)operands.pop();
    }

    public String termToString(Term term) {
        return this.termToString(term, false);
    }

    private boolean isOperator(String token) {
        return token.equals("&&") || token.equals("||") || token.equals("!");
    }

    private int precedence(String operator) {
        switch (operator) {
            case "||": {
                return 1;
            }
            case "&&": {
                return 2;
            }
            case "!": {
                return 3;
            }
        }
        return -1;
    }

    private void performOperation(Stack<Term> operands, String operator) {
        switch (operator) {
            case "&&": 
            case "||": {
                Term right = operands.pop();
                Term left = operands.pop();
                AND operation = operator.equals("&&") ? this.ddFactory.createAND() : this.ddFactory.createOR();
                operation.getTerms().add(left);
                operation.getTerms().add(right);
                operands.push((Term)operation);
                break;
            }
            case "!": {
                Term negated = operands.pop();
                NOT notOperation = this.ddFactory.createNOT();
                notOperation.setNegatedTerm(negated);
                operands.push((Term)notOperation);
                break;
            }
            default: {
                this.logger.error((Object)"Unknow operator");
                throw new IllegalArgumentException(operator);
            }
        }
    }

    private Term createTerm(String token) {
        if (token.equals("TRUE")) {
            return this.ddFactory.createTRUE();
        }
        if (token.equals("FALSE")) {
            NOT ddFalse = this.ddFactory.createNOT();
            ddFalse.setNegatedTerm((Term)this.ddFactory.createTRUE());
            return ddFalse;
        }
        String typeName = token.split("\\.")[0];
        String valueName = token.split("\\.")[1];
        Optional optionalValue = Optional.ofNullable(this.dataDictionary).flatMap(dd -> dd.getLabelTypes().stream().filter(labelType -> labelType.getEntityName().equals(typeName)).flatMap(labelType -> labelType.getLabel().stream()).filter(label -> label.getEntityName().equals(valueName)).findAny());
        Label value = optionalValue.orElseGet(() -> {
            Label label = this.ddFactory.createLabel();
            label.setEntityName(token);
            return label;
        });
        LabelReference labelReference = this.ddFactory.createLabelReference();
        labelReference.setLabel(value);
        return labelReference;
    }

    private String termToString(Term term, boolean isNested) {
        if (term instanceof LabelReference) {
            LabelReference labelReference = (LabelReference)term;
            Label label = labelReference.getLabel();
            return ((LabelType)label.eContainer()).getEntityName() + "." + label.getEntityName();
        }
        if (term instanceof TRUE) {
            return "TRUE";
        }
        if (term instanceof AND) {
            AND and = (AND)term;
            List operands = and.getTerms();
            String result = this.termToString((Term)operands.get(0), true) + " && " + this.termToString((Term)operands.get(1), true);
            return isNested ? "(" + result + ")" : result;
        }
        if (term instanceof OR) {
            OR or = (OR)term;
            List operands = or.getTerms();
            String result = this.termToString((Term)operands.get(0), true) + " || " + this.termToString((Term)operands.get(1), true);
            return isNested ? "(" + result + ")" : result;
        }
        if (term instanceof NOT) {
            NOT not = (NOT)term;
            if (not.getNegatedTerm() instanceof TRUE) {
                return "FALSE";
            }
            if (not.getNegatedTerm() instanceof LabelReference) {
                return "!" + this.termToString(not.getNegatedTerm(), false);
            }
            return "!" + this.termToString(not.getNegatedTerm(), true);
        }
        throw new IllegalArgumentException("Unknown term type");
    }

    private List<String> tokenize(String expression) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder token = new StringBuilder();
        int i = 0;
        while (i < expression.length()) {
            char current = expression.charAt(i);
            if (!Character.isWhitespace(current)) {
                if (current == '(' || current == ')') {
                    if (token.length() > 0) {
                        tokens.add(token.toString());
                        token.setLength(0);
                    }
                    tokens.add(Character.toString(current));
                } else if (current == '&' || current == '|' || current == '!') {
                    if (token.length() > 0) {
                        tokens.add(token.toString());
                        token.setLength(0);
                    }
                    token.append(current);
                    if ((current == '&' || current == '|') && i + 1 < expression.length() && expression.charAt(i + 1) == current) {
                        ++i;
                        token.append(current);
                    }
                    tokens.add(token.toString());
                    token.setLength(0);
                } else {
                    token.append(current);
                }
            }
            ++i;
        }
        if (token.length() > 0) {
            tokens.add(token.toString());
        }
        return tokens;
    }
}

