/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.converter;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dataflowanalysis.analysis.dfd.resource.DFDURIResourceProvider;
import org.dataflowanalysis.analysis.utils.ResourceUtils;
import org.dataflowanalysis.converter.DataFlowDiagramAndDictionary;
import org.dataflowanalysis.converter.FileNameOnlyURIHandler;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceFactoryImpl;
import tools.mdsd.library.standalone.initialization.StandaloneInitializationException;
import tools.mdsd.library.standalone.initialization.StandaloneInitializerBuilder;

public abstract class Converter {
    protected ObjectMapper objectMapper;
    protected File file;
    protected final Logger logger = Logger.getLogger(Converter.class);

    public Converter() {
        this.objectMapper = new ObjectMapper();
    }

    public DataFlowDiagramAndDictionary loadDFD(String project, String inputDataFlowDiagram, String inputDataDictionary, Class<?> activator) throws StandaloneInitializationException {
        StandaloneInitializerBuilder.builder().registerProjectURI(activator, project).build().init();
        URI dfdURI = ResourceUtils.createRelativePluginURI((String)inputDataFlowDiagram, (String)project);
        URI ddURI = ResourceUtils.createRelativePluginURI((String)inputDataDictionary, (String)project);
        DFDURIResourceProvider provider = new DFDURIResourceProvider(dfdURI, ddURI);
        provider.loadRequiredResources();
        return new DataFlowDiagramAndDictionary(provider.getDataFlowDiagram(), provider.getDataDictionary());
    }

    public void storeDFD(DataFlowDiagramAndDictionary complete, String outputFile) {
        String fileEnding = ".json";
        String truncatedOutputFile = outputFile.endsWith(fileEnding) ? outputFile.substring(0, outputFile.length() - fileEnding.length()) : outputFile;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource dfdResource = this.createAndAddResource(truncatedOutputFile + ".dataflowdiagram", new String[]{"dataflowdiagram"}, (ResourceSet)resourceSet);
        Resource ddResource = this.createAndAddResource(truncatedOutputFile + ".datadictionary", new String[]{"datadictionary"}, (ResourceSet)resourceSet);
        dfdResource.getContents().add((Object)complete.dataFlowDiagram());
        ddResource.getContents().add((Object)complete.dataDictionary());
        this.saveResource(dfdResource);
        this.saveResource(ddResource);
    }

    private Resource createAndAddResource(String outputFile, String[] fileextensions, ResourceSet resourceSet) {
        String[] stringArray = fileextensions;
        int n = fileextensions.length;
        int n2 = 0;
        while (n2 < n) {
            String fileextension = stringArray[n2];
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(fileextension, new XMLResourceFactoryImpl());
            ++n2;
        }
        URI uri = URI.createFileURI((String)outputFile);
        return resourceSet.createResource(uri);
    }

    private void saveResource(Resource resource) {
        Map saveOptions = ((XMLResource)resource).getDefaultSaveOptions();
        saveOptions.put("URI_HANDLER", new FileNameOnlyURIHandler());
        try {
            resource.save(saveOptions);
        }
        catch (IOException e) {
            this.logger.error((Object)"Error saving DataFlowDiagram");
            throw new RuntimeException(e);
        }
    }
}

