/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.converter;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.log4j.Logger;
import org.dataflowanalysis.analysis.core.AbstractTransposeFlowGraph;
import org.dataflowanalysis.analysis.core.AbstractVertex;
import org.dataflowanalysis.analysis.core.TransposeFlowGraphFinder;
import org.dataflowanalysis.analysis.dfd.DFDConfidentialityAnalysis;
import org.dataflowanalysis.analysis.dfd.core.DFDTransposeFlowGraphFinder;
import org.dataflowanalysis.analysis.dfd.simple.DFDSimpleTransposeFlowGraphFinder;
import org.dataflowanalysis.converter.BehaviorConverter;
import org.dataflowanalysis.converter.Converter;
import org.dataflowanalysis.converter.DataFlowDiagramAndDictionary;
import org.dataflowanalysis.converter.webdfd.Annotation;
import org.dataflowanalysis.converter.webdfd.Child;
import org.dataflowanalysis.converter.webdfd.Constraint;
import org.dataflowanalysis.converter.webdfd.Model;
import org.dataflowanalysis.converter.webdfd.Port;
import org.dataflowanalysis.converter.webdfd.Value;
import org.dataflowanalysis.converter.webdfd.WebEditorDfd;
import org.dataflowanalysis.converter.webdfd.WebEditorLabel;
import org.dataflowanalysis.converter.webdfd.WebEditorLabelType;
import org.dataflowanalysis.dfd.datadictionary.AbstractAssignment;
import org.dataflowanalysis.dfd.datadictionary.Assignment;
import org.dataflowanalysis.dfd.datadictionary.DataDictionary;
import org.dataflowanalysis.dfd.datadictionary.ForwardingAssignment;
import org.dataflowanalysis.dfd.datadictionary.Label;
import org.dataflowanalysis.dfd.datadictionary.LabelType;
import org.dataflowanalysis.dfd.datadictionary.Pin;
import org.dataflowanalysis.dfd.datadictionary.SetAssignment;
import org.dataflowanalysis.dfd.datadictionary.UnsetAssignment;
import org.dataflowanalysis.dfd.dataflowdiagram.DataFlowDiagram;
import org.dataflowanalysis.dfd.dataflowdiagram.External;
import org.dataflowanalysis.dfd.dataflowdiagram.Flow;
import org.dataflowanalysis.dfd.dataflowdiagram.Node;
import org.dataflowanalysis.dfd.dataflowdiagram.Process;
import org.dataflowanalysis.dfd.dataflowdiagram.Store;
import tools.mdsd.library.standalone.initialization.StandaloneInitializationException;

public class DataFlowDiagramConverter
extends Converter {
    private Map<Pin, List<String>> inputPinToFlowNamesMap;
    private final Logger logger = Logger.getLogger(DataFlowDiagramConverter.class);
    protected static final String DELIMITER_PIN_NAME = "|";
    protected static final String DELIMITER_MULTI_PIN = ",";
    protected static final String DELIMITER_MULTI_LABEL = ",";
    private static final String CONTROL_FLOW_NAME = "~";
    private BehaviorConverter behaviorConverter;

    public WebEditorDfd dfdToWeb(String project, String inputDataFlowDiagram, String inputDataDictionary, Class<?> activator) throws StandaloneInitializationException {
        DataFlowDiagramAndDictionary complete = this.loadDFD(project, inputDataFlowDiagram, inputDataDictionary, activator);
        return this.processDfd(complete.dataFlowDiagram(), complete.dataDictionary(), this.createNodeAnnotationMap(complete, null, null), false);
    }

    public WebEditorDfd dfdToWeb(DataFlowDiagramAndDictionary complete) {
        return this.processDfd(complete.dataFlowDiagram(), complete.dataDictionary(), this.createNodeAnnotationMap(complete, null, null), false);
    }

    public WebEditorDfd dfdToWebAndAnalyzeAndAnnotate(String project, String inputDataFlowDiagram, String inputDataDictionary, Class<?> activator, List<Predicate<? super AbstractVertex<?>>> conditions) throws StandaloneInitializationException {
        DataFlowDiagramAndDictionary complete = this.loadDFD(project, inputDataFlowDiagram, inputDataDictionary, activator);
        return this.processDfd(complete.dataFlowDiagram(), complete.dataDictionary(), this.createNodeAnnotationMap(complete, conditions, null), false);
    }

    public WebEditorDfd dfdToWebAndAnalyzeAndAnnotate(DataFlowDiagramAndDictionary complete, List<Predicate<? super AbstractVertex<?>>> conditions) {
        return this.processDfd(complete.dataFlowDiagram(), complete.dataDictionary(), this.createNodeAnnotationMap(complete, conditions, null), false);
    }

    public WebEditorDfd dfdToWebAndAnalyzeAndAnnotateWithCustomTFGFinder(String project, String inputDataFlowDiagram, String inputDataDictionary, Class<?> activator, List<Predicate<? super AbstractVertex<?>>> conditions, Class<? extends TransposeFlowGraphFinder> finderClass) throws StandaloneInitializationException {
        DataFlowDiagramAndDictionary complete = this.loadDFD(project, inputDataFlowDiagram, inputDataDictionary, activator);
        return this.processDfd(complete.dataFlowDiagram(), complete.dataDictionary(), this.createNodeAnnotationMap(complete, conditions, finderClass), false);
    }

    public WebEditorDfd dfdToWebAndAnalyzeAndAnnotateWithCustomTFGFinderAndSetReadOnly(String project, String inputDataFlowDiagram, String inputDataDictionary, Class<?> activator, List<Predicate<? super AbstractVertex<?>>> conditions, Class<? extends TransposeFlowGraphFinder> finderClass) throws StandaloneInitializationException {
        DataFlowDiagramAndDictionary complete = this.loadDFD(project, inputDataFlowDiagram, inputDataDictionary, activator);
        return this.processDfd(complete.dataFlowDiagram(), complete.dataDictionary(), this.createNodeAnnotationMap(complete, conditions, finderClass), true);
    }

    public WebEditorDfd dfdToWeb(DataFlowDiagramAndDictionary complete, Map<Node, Annotation> annotations) {
        return this.processDfd(complete.dataFlowDiagram(), complete.dataDictionary(), annotations, false);
    }

    public WebEditorDfd dfdToWebAndAnalyzeAndAnnotateWithCustomTFGFinder(DataFlowDiagramAndDictionary complete, List<Predicate<? super AbstractVertex<?>>> conditions, Class<? extends TransposeFlowGraphFinder> finderClass) {
        return this.processDfd(complete.dataFlowDiagram(), complete.dataDictionary(), this.createNodeAnnotationMap(complete, conditions, finderClass), false);
    }

    public WebEditorDfd dfdToWebAndAnalyzeAndAnnotateWithCustomTFGFinderAndSetReadOnly(DataFlowDiagramAndDictionary complete, List<Predicate<? super AbstractVertex<?>>> conditions, Class<? extends TransposeFlowGraphFinder> finderClass) {
        return this.processDfd(complete.dataFlowDiagram(), complete.dataDictionary(), this.createNodeAnnotationMap(complete, conditions, finderClass), true);
    }

    public void storeWeb(WebEditorDfd web, String outputFile) {
        this.objectMapper = new ObjectMapper();
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        try {
            this.objectMapper.writeValue(new File(outputFile), (Object)web);
        }
        catch (IOException e) {
            this.logger.error((Object)"Could not store web dfd:", (Throwable)e);
        }
    }

    private Map<Node, Annotation> createNodeAnnotationMap(DataFlowDiagramAndDictionary complete, List<Predicate<? super AbstractVertex<?>>> conditions, Class<? extends TransposeFlowGraphFinder> finderClass) {
        Object finder = finderClass == null ? new DFDTransposeFlowGraphFinder(complete.dataDictionary(), complete.dataFlowDiagram()) : (finderClass.equals(DFDSimpleTransposeFlowGraphFinder.class) ? new DFDSimpleTransposeFlowGraphFinder(complete.dataDictionary(), complete.dataFlowDiagram()) : new DFDTransposeFlowGraphFinder(complete.dataDictionary(), complete.dataFlowDiagram()));
        List<AbstractTransposeFlowGraph> collection = finder.findTransposeFlowGraphs();
        collection = collection.stream().map(AbstractTransposeFlowGraph::evaluate).toList();
        HashMap<Node, Annotation> mapNodeToAnnotations = new HashMap<Node, Annotation>();
        HashMap mapNodeToPropagatedLabels = new HashMap();
        collection.stream().forEach(tfg -> tfg.getVertices().forEach(vertex -> {
            Node node = (Node)vertex.getReferencedElement();
            mapNodeToPropagatedLabels.putIfAbsent(node, new HashSet());
            Set label = (Set)mapNodeToPropagatedLabels.get(node);
            vertex.getAllOutgoingDataCharacteristics().forEach(characteristic -> characteristic.getAllCharacteristics().forEach(value -> label.add(value.getTypeName() + "." + value.getValueName())));
        }));
        mapNodeToPropagatedLabels.keySet().forEach(key -> {
            StringBuilder builder = new StringBuilder();
            builder.append("PropagatedLabels:").append("\n");
            ((Set)mapNodeToPropagatedLabels.get(key)).forEach(value -> builder.append((String)value).append("\n"));
            if (!((Set)mapNodeToPropagatedLabels.get(key)).isEmpty()) {
                mapNodeToAnnotations.put((Node)key, new Annotation(builder.toString(), "tag", "#FFFFFF"));
            }
        });
        if (conditions == null) {
            return mapNodeToAnnotations;
        }
        DFDConfidentialityAnalysis analysis = new DFDConfidentialityAnalysis(null, null, null);
        int i = 0;
        while (i < conditions.size()) {
            Predicate<? super AbstractVertex<?>> condition = conditions.get(i);
            if (condition != null) {
                for (AbstractTransposeFlowGraph tfg2 : collection) {
                    List violations = analysis.queryDataFlow(tfg2, condition);
                    for (AbstractVertex vertex : violations) {
                        Node node = (Node)vertex.getReferencedElement();
                        StringBuilder builder = new StringBuilder();
                        if (mapNodeToAnnotations.get(node) != null) {
                            builder.append(((Annotation)mapNodeToAnnotations.get(node)).message()).append("\n");
                        }
                        builder.append("Violation: Constraint ").append(i).append(" violated.").append("\n");
                        mapNodeToAnnotations.put(node, new Annotation(builder.toString(), "bolt", "#ff0000"));
                    }
                }
            }
            ++i;
        }
        return mapNodeToAnnotations;
    }

    private void createLabelTypesAndValues(List<WebEditorLabelType> labelTypes, DataDictionary dataDictionary) {
        for (LabelType labelType : dataDictionary.getLabelTypes()) {
            ArrayList<Value> values = new ArrayList<Value>();
            for (Label label : labelType.getLabel()) {
                values.add(new Value(label.getId(), label.getEntityName()));
            }
            labelTypes.add(new WebEditorLabelType(labelType.getId(), labelType.getEntityName(), values));
        }
    }

    private WebEditorDfd processDfd(DataFlowDiagram dataFlowDiagram, DataDictionary dataDictionary, Map<Node, Annotation> mapNodeToAnnotation, boolean readOnly) {
        this.inputPinToFlowNamesMap = new HashMap<Pin, List<String>>();
        ArrayList<Child> children = new ArrayList<Child>();
        ArrayList<WebEditorLabelType> labelTypes = new ArrayList<WebEditorLabelType>();
        this.behaviorConverter = new BehaviorConverter(dataDictionary);
        this.createLabelTypesAndValues(labelTypes, dataDictionary);
        this.createFlows(dataFlowDiagram, children);
        this.createNodes(dataFlowDiagram, children, mapNodeToAnnotation);
        return new WebEditorDfd(new Model("graph", "root", children), labelTypes, readOnly ? "view" : "edit", new ArrayList<Constraint>());
    }

    private void createNodes(DataFlowDiagram dataFlowDiagram, List<Child> children, Map<Node, Annotation> mapNodeToAnnotation) {
        for (Node node : dataFlowDiagram.getNodes()) {
            String type;
            String text = node.getEntityName();
            String id = node.getId();
            if (node instanceof Process) {
                type = "node:function";
            } else if (node instanceof Store) {
                type = "node:storage";
            } else if (node instanceof External) {
                type = "node:input-output";
            } else {
                type = "error";
                this.logger.error((Object)"Unrecognized node type");
            }
            ArrayList<WebEditorLabel> labels = new ArrayList<WebEditorLabel>();
            for (Label label : node.getProperties()) {
                String labelId = label.getId();
                String labelTypeId = ((LabelType)label.eContainer()).getId();
                labels.add(new WebEditorLabel(labelTypeId, labelId));
            }
            ArrayList<Port> ports = new ArrayList<Port>();
            node.getBehavior().getInPin().forEach(pin -> {
                boolean bl = ports.add(new Port(null, pin.getId(), "port:dfd-input", new ArrayList<Object>()));
            });
            Map<Pin, List<AbstractAssignment>> mapPinToAssignments = this.mapping(node);
            node.getBehavior().getOutPin().forEach(pin -> {
                boolean bl = ports.add(new Port(this.createBehaviorString((List)mapPinToAssignments.get(pin)), pin.getId(), "port:dfd-output", new ArrayList<Object>()));
            });
            if (mapNodeToAnnotation == null) {
                children.add(new Child(text, labels, ports, id, type, null, null, null, new ArrayList<Child>()));
                continue;
            }
            children.add(new Child(text, labels, ports, id, type, null, null, mapNodeToAnnotation.get(node), new ArrayList<Child>()));
        }
    }

    private void createFlows(DataFlowDiagram dataFlowDiagram, List<Child> children) {
        HashMap<Flow, String> controlFlowNameMap = this.createControlFlowNameMap(dataFlowDiagram);
        for (Flow flow : dataFlowDiagram.getFlows()) {
            this.fillPinToFlowNamesMap(this.inputPinToFlowNamesMap, flow, controlFlowNameMap);
            children.add(this.createFlow(flow, controlFlowNameMap));
        }
    }

    private HashMap<Flow, String> createControlFlowNameMap(DataFlowDiagram dataFlowDiagram) {
        HashMap<Flow, String> controlFlowNameMap = new HashMap<Flow, String>();
        dataFlowDiagram.getNodes().forEach(node -> {
            List<Flow> controlFlows = dataFlowDiagram.getFlows().stream().filter(flow -> flow.getDestinationNode().equals(node)).filter(flow -> flow.getEntityName().equals("")).toList();
            Object controlFlowName = CONTROL_FLOW_NAME;
            for (Flow flow2 : controlFlows) {
                controlFlowNameMap.put(flow2, (String)controlFlowName);
                controlFlowName = (String)controlFlowName + CONTROL_FLOW_NAME;
            }
        });
        return controlFlowNameMap;
    }

    private Child createFlow(Flow flow, HashMap<Flow, String> controlFlowNameMap) {
        String id = flow.getId();
        String type = "edge:arrow";
        String sourceId = flow.getSourcePin().getId();
        String targetId = flow.getDestinationPin().getId();
        String text = controlFlowNameMap.getOrDefault(flow, flow.getEntityName());
        return new Child(text, null, null, id, type, sourceId, targetId, null, new ArrayList<Child>());
    }

    private Map<Pin, List<AbstractAssignment>> mapping(Node node) {
        HashMap<Pin, List<AbstractAssignment>> mapPinToAssignments = new HashMap<Pin, List<AbstractAssignment>>();
        for (AbstractAssignment assignment : node.getBehavior().getAssignment()) {
            if (mapPinToAssignments.containsKey(assignment.getOutputPin())) {
                ((List)mapPinToAssignments.get(assignment.getOutputPin())).add(assignment);
                continue;
            }
            ArrayList<AbstractAssignment> list = new ArrayList<AbstractAssignment>();
            list.add(assignment);
            mapPinToAssignments.put(assignment.getOutputPin(), list);
        }
        return mapPinToAssignments;
    }

    private String createBehaviorString(List<AbstractAssignment> abstractAssignments) {
        if (abstractAssignments == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (AbstractAssignment abstractAssignment : abstractAssignments) {
            if (abstractAssignment instanceof ForwardingAssignment) {
                ForwardingAssignment forwardingAssignment = (ForwardingAssignment)abstractAssignment;
                builder.append("forward ");
                builder.append(this.getStringFromInputPins(forwardingAssignment.getInputPins()));
            } else if (abstractAssignment instanceof SetAssignment) {
                SetAssignment setAssignment = (SetAssignment)abstractAssignment;
                builder.append("set ");
                builder.append(this.getStringFromOutLabels(setAssignment.getOutputLabels()));
            } else if (abstractAssignment instanceof UnsetAssignment) {
                UnsetAssignment unsetAssignment = (UnsetAssignment)abstractAssignment;
                builder.append("unset ");
                builder.append(this.getStringFromOutLabels(unsetAssignment.getOutputLabels()));
            } else if (abstractAssignment instanceof Assignment) {
                Assignment assignment = (Assignment)abstractAssignment;
                builder.append("assign ");
                builder.append(this.getStringFromOutLabels(assignment.getOutputLabels()));
                builder.append(" if ");
                builder.append(this.behaviorConverter.termToString(assignment.getTerm()));
                if (!assignment.getInputPins().isEmpty()) {
                    builder.append(" from ");
                    builder.append(this.getStringFromInputPins(assignment.getInputPins()));
                }
            }
            builder.append("\n");
        }
        return builder.toString().trim();
    }

    private String getStringFromInputPins(List<Pin> inputPins) {
        ArrayList pinNamesAsString = new ArrayList();
        inputPins.forEach(pin -> {
            List flowNames = this.inputPinToFlowNamesMap.get(pin).stream().sorted().toList();
            String pinName = String.join((CharSequence)DELIMITER_PIN_NAME, flowNames);
            pinNamesAsString.add(pinName);
        });
        return String.join((CharSequence)",", pinNamesAsString);
    }

    private String getStringFromOutLabels(List<Label> outLabels) {
        ArrayList outLabelsAsStrings = new ArrayList();
        outLabels.forEach(label -> outLabelsAsStrings.add(((LabelType)label.eContainer()).getEntityName() + "." + label.getEntityName()));
        return String.join((CharSequence)",", outLabelsAsStrings);
    }

    private void fillPinToFlowNamesMap(Map<Pin, List<String>> map, Flow flow, HashMap<Flow, String> controlFlowNameMap) {
        if (map.containsKey(flow.getDestinationPin())) {
            map.get(flow.getDestinationPin()).add(controlFlowNameMap.getOrDefault(flow, flow.getEntityName()));
        } else {
            ArrayList<String> flowNames = new ArrayList<String>();
            flowNames.add(controlFlowNameMap.getOrDefault(flow, flow.getEntityName()));
            map.put(flow.getDestinationPin(), flowNames);
        }
    }
}

