/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.converter;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.dataflowanalysis.converter.Converter;
import org.dataflowanalysis.converter.DataFlowDiagramAndDictionary;
import org.dataflowanalysis.converter.microsecend.ExternalEntity;
import org.dataflowanalysis.converter.microsecend.InformationFlow;
import org.dataflowanalysis.converter.microsecend.MicroSecEnd;
import org.dataflowanalysis.converter.microsecend.Service;
import org.dataflowanalysis.dfd.datadictionary.Assignment;
import org.dataflowanalysis.dfd.datadictionary.Behavior;
import org.dataflowanalysis.dfd.datadictionary.DataDictionary;
import org.dataflowanalysis.dfd.datadictionary.ForwardingAssignment;
import org.dataflowanalysis.dfd.datadictionary.Label;
import org.dataflowanalysis.dfd.datadictionary.LabelType;
import org.dataflowanalysis.dfd.datadictionary.Pin;
import org.dataflowanalysis.dfd.datadictionary.TRUE;
import org.dataflowanalysis.dfd.datadictionary.Term;
import org.dataflowanalysis.dfd.datadictionary.datadictionaryFactory;
import org.dataflowanalysis.dfd.dataflowdiagram.DataFlowDiagram;
import org.dataflowanalysis.dfd.dataflowdiagram.External;
import org.dataflowanalysis.dfd.dataflowdiagram.Flow;
import org.dataflowanalysis.dfd.dataflowdiagram.Node;
import org.dataflowanalysis.dfd.dataflowdiagram.dataflowdiagramFactory;

public class MicroSecEndConverter
extends Converter {
    private final dataflowdiagramFactory dfdFactory = dataflowdiagramFactory.eINSTANCE;
    private final datadictionaryFactory ddFactory = datadictionaryFactory.eINSTANCE;
    private Map<String, Node> nodesMap;
    private Map<Node, List<String>> nodeToLabelNamesMap;
    private Map<Node, Map<String, List<String>>> nodeToLabelTypeNamesMap;
    private Map<String, Map<String, Label>> labelMap;
    private Map<String, LabelType> labelTypeMap;
    private Map<Pin, List<Label>> outpinToFlowLabelMap;
    private int idCounter;

    public DataFlowDiagramAndDictionary microToDfd(String inputFile) {
        return this.microToDfd(this.loadMicro(inputFile).get());
    }

    public DataFlowDiagramAndDictionary microToDfd(MicroSecEnd inputFile) {
        return this.processMicro(inputFile);
    }

    public Optional<MicroSecEnd> loadMicro(String inputFile) {
        this.objectMapper = new ObjectMapper();
        this.file = new File(inputFile);
        try {
            MicroSecEnd result = (MicroSecEnd)this.objectMapper.readValue(this.file, MicroSecEnd.class);
            return Optional.ofNullable(result);
        }
        catch (IOException e) {
            this.logger.error((Object)"Could not load MicroSecEnd:", (Throwable)e);
            return Optional.empty();
        }
    }

    public Optional<DataFlowDiagramAndDictionary> plantToDFD(String inputFile) {
        String name = inputFile.split("\\.")[0];
        int exitCode = this.runPythonScript(inputFile, "json", name + ".json");
        if (exitCode == 0) {
            return Optional.ofNullable(this.microToDfd(name + ".json"));
        }
        return Optional.empty();
    }

    public int runPythonScript(String in, String format, String out) {
        String[] command = new String[]{"python3", "convert_model.py", in, format, "-op", out};
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        try {
            Process process = processBuilder.start();
            return process.waitFor();
        }
        catch (IOException | InterruptedException e) {
            this.logger.error((Object)"Make sure python3 is installed and set in PATH", (Throwable)e);
            return -1;
        }
    }

    private DataFlowDiagramAndDictionary processMicro(MicroSecEnd micro) {
        this.nodesMap = new HashMap<String, Node>();
        this.nodeToLabelNamesMap = new HashMap<Node, List<String>>();
        this.labelMap = new HashMap<String, Map<String, Label>>();
        this.labelTypeMap = new HashMap<String, LabelType>();
        this.nodeToLabelTypeNamesMap = new HashMap<Node, Map<String, List<String>>>();
        this.outpinToFlowLabelMap = new HashMap<Pin, List<Label>>();
        this.idCounter = 0;
        DataFlowDiagram dfd = this.dfdFactory.createDataFlowDiagram();
        DataDictionary dd = this.ddFactory.createDataDictionary();
        dfd.setId(Integer.toString(this.idCounter++));
        dd.setId(Integer.toString(this.idCounter++));
        this.createExternalEntities(micro, dfd);
        this.createProcesses(micro, dfd);
        LabelType stereotype = this.ddFactory.createLabelType();
        stereotype.setEntityName("Stereotype");
        stereotype.setId(Integer.toString(this.idCounter++));
        dd.getLabelTypes().add(stereotype);
        this.labelTypeMap.put(stereotype.getEntityName(), stereotype);
        this.labelMap.put(stereotype.getEntityName(), new HashMap());
        this.createBehavior(dd, stereotype);
        this.createFlows(micro, dfd, dd, stereotype);
        this.createNodeAssignments();
        this.createForwardingAssignments();
        return new DataFlowDiagramAndDictionary(dfd, dd);
    }

    private void createProcesses(MicroSecEnd micro, DataFlowDiagram dfd) {
        for (Service service : micro.services()) {
            org.dataflowanalysis.dfd.dataflowdiagram.Process process = this.dfdFactory.createProcess();
            process.setEntityName(service.name());
            process.setId(Integer.toString(this.idCounter++));
            dfd.getNodes().add(process);
            this.nodesMap.put(service.name(), (Node)process);
            this.nodeToLabelNamesMap.put((Node)process, service.stereotypes());
            this.nodeToLabelTypeNamesMap.put((Node)process, service.taggedValues());
        }
    }

    private void createExternalEntities(MicroSecEnd micro, DataFlowDiagram dfd) {
        for (ExternalEntity ee : micro.externalEntities()) {
            External external = this.dfdFactory.createExternal();
            external.setEntityName(ee.name());
            external.setId(Integer.toString(this.idCounter++));
            dfd.getNodes().add(external);
            this.nodesMap.put(ee.name(), (Node)external);
            this.nodeToLabelNamesMap.put((Node)external, ee.stereotypes());
            this.nodeToLabelTypeNamesMap.put((Node)external, ee.taggedValues());
        }
    }

    private void createBehavior(DataDictionary dd, LabelType stereotype) {
        for (Node node : this.nodesMap.values()) {
            Behavior behaviour = this.ddFactory.createBehavior();
            behaviour.setId(Integer.toString(this.idCounter++));
            node.setBehavior(behaviour);
            Assignment assignment = this.ddFactory.createAssignment();
            assignment.setId(Integer.toString(this.idCounter++));
            assignment.getOutputLabels().addAll(this.createLabels(this.nodeToLabelNamesMap.get(node), dd, stereotype));
            behaviour.getAssignment().add(assignment);
            node.getProperties().addAll(assignment.getOutputLabels());
            node.getProperties().addAll(this.createTaggedValueLabels(this.nodeToLabelTypeNamesMap.get(node), dd));
            dd.getBehavior().add(behaviour);
        }
    }

    private void createFlows(MicroSecEnd micro, DataFlowDiagram dfd, DataDictionary dd, LabelType stereotype) {
        for (InformationFlow iflow : micro.informationFlows()) {
            Node source = this.nodesMap.get(iflow.sender());
            Node dest = this.nodesMap.get(iflow.receiver());
            Flow flow = this.dfdFactory.createFlow();
            flow.setSourceNode(source);
            flow.setDestinationNode(dest);
            flow.setEntityName(iflow.sender());
            Pin inPin = dest.getBehavior().getInPin().stream().findFirst().orElseGet(() -> this.createInPin(dest));
            Pin outPin = this.ddFactory.createPin();
            outPin.setId(Integer.toString(this.idCounter++));
            source.getBehavior().getOutPin().add(outPin);
            flow.setDestinationPin(inPin);
            flow.setSourcePin(outPin);
            flow.setId(Integer.toString(this.idCounter++));
            dfd.getFlows().add(flow);
            ArrayList<Label> flowLabels = new ArrayList<Label>();
            flowLabels.addAll(this.createLabels(iflow.stereotypes(), dd, stereotype));
            flowLabels.addAll(this.createTaggedValueLabels(iflow.taggedValues(), dd));
            this.outpinToFlowLabelMap.put(outPin, flowLabels);
        }
    }

    private Pin createInPin(Node dest) {
        Pin inPin = this.ddFactory.createPin();
        inPin.setId(Integer.toString(this.idCounter++));
        dest.getBehavior().getInPin().add(inPin);
        return inPin;
    }

    private void createNodeAssignments() {
        for (Node node : this.nodesMap.values()) {
            Behavior behaviour = node.getBehavior();
            Assignment template = (Assignment)behaviour.getAssignment().get(0);
            if (!behaviour.getOutPin().isEmpty()) {
                for (Pin outPin : behaviour.getOutPin()) {
                    Assignment assignment = this.ddFactory.createAssignment();
                    assignment.setId(Integer.toString(this.idCounter++));
                    assignment.getInputPins().addAll(behaviour.getInPin());
                    assignment.setOutputPin(outPin);
                    assignment.getOutputLabels().addAll(template.getOutputLabels());
                    assignment.getOutputLabels().addAll((Collection)this.outpinToFlowLabelMap.get(outPin));
                    TRUE ddTrue = this.ddFactory.createTRUE();
                    ddTrue.setId(Integer.toString(this.idCounter++));
                    assignment.setTerm((Term)ddTrue);
                    behaviour.getAssignment().add(assignment);
                }
            }
            behaviour.getAssignment().remove(template);
        }
    }

    private void createForwardingAssignments() {
        for (Node node : this.nodesMap.values()) {
            Behavior behaviour = node.getBehavior();
            if (behaviour.getInPin().isEmpty()) continue;
            for (Pin pin : behaviour.getOutPin()) {
                ForwardingAssignment assignment = this.ddFactory.createForwardingAssignment();
                assignment.setId(Integer.toString(this.idCounter++));
                assignment.setOutputPin(pin);
                assignment.getInputPins().addAll(behaviour.getInPin());
                behaviour.getAssignment().add(assignment);
            }
        }
    }

    private List<Label> createLabels(List<String> labelNames, DataDictionary dd, LabelType labelType) {
        ArrayList<Label> labels = new ArrayList<Label>();
        String labelTypeName = labelType.getEntityName();
        for (String labelName : labelNames) {
            if (this.labelMap.get(labelTypeName).containsKey(labelName)) {
                labels.add(this.labelMap.get(labelTypeName).get(labelName));
                continue;
            }
            Label label = this.ddFactory.createLabel();
            label.setEntityName(labelName);
            label.setId(Integer.toString(this.idCounter++));
            labelType.getLabel().add(label);
            labels.add(label);
            this.labelMap.get(labelTypeName).put(labelName, label);
        }
        return labels;
    }

    private List<Label> createTaggedValueLabels(Map<String, List<String>> taggedValues, DataDictionary dd) {
        ArrayList<Label> labels = new ArrayList<Label>();
        for (String labelTypeName : taggedValues.keySet()) {
            LabelType labelType;
            List<String> labelNames = taggedValues.get(labelTypeName);
            if (this.labelTypeMap.containsKey(labelTypeName)) {
                labelType = this.labelTypeMap.get(labelTypeName);
            } else {
                labelType = this.ddFactory.createLabelType();
                labelType.setEntityName(labelTypeName);
                labelType.setId(Integer.toString(this.idCounter++));
                dd.getLabelTypes().add(labelType);
                this.labelTypeMap.put(labelTypeName, labelType);
                this.labelMap.put(labelTypeName, new HashMap());
            }
            labels.addAll(this.createLabels(labelNames, dd, labelType));
        }
        return labels;
    }
}

