/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.converter;

import de.uka.ipd.sdq.stoex.AbstractNamedReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import org.apache.log4j.Level;
import org.dataflowanalysis.analysis.core.AbstractTransposeFlowGraph;
import org.dataflowanalysis.analysis.core.CharacteristicValue;
import org.dataflowanalysis.analysis.core.DataCharacteristic;
import org.dataflowanalysis.analysis.core.FlowGraphCollection;
import org.dataflowanalysis.analysis.pcm.PCMDataFlowConfidentialityAnalysis;
import org.dataflowanalysis.analysis.pcm.PCMDataFlowConfidentialityAnalysisBuilder;
import org.dataflowanalysis.analysis.pcm.core.AbstractPCMVertex;
import org.dataflowanalysis.analysis.pcm.core.seff.CallingSEFFPCMVertex;
import org.dataflowanalysis.analysis.pcm.core.seff.SEFFPCMVertex;
import org.dataflowanalysis.analysis.pcm.core.user.CallingUserPCMVertex;
import org.dataflowanalysis.analysis.pcm.core.user.UserPCMVertex;
import org.dataflowanalysis.analysis.pcm.utils.PCMQueryUtils;
import org.dataflowanalysis.converter.Converter;
import org.dataflowanalysis.converter.DataFlowDiagramAndDictionary;
import org.dataflowanalysis.dfd.datadictionary.AND;
import org.dataflowanalysis.dfd.datadictionary.AbstractAssignment;
import org.dataflowanalysis.dfd.datadictionary.Assignment;
import org.dataflowanalysis.dfd.datadictionary.Behavior;
import org.dataflowanalysis.dfd.datadictionary.DataDictionary;
import org.dataflowanalysis.dfd.datadictionary.ForwardingAssignment;
import org.dataflowanalysis.dfd.datadictionary.Label;
import org.dataflowanalysis.dfd.datadictionary.LabelReference;
import org.dataflowanalysis.dfd.datadictionary.LabelType;
import org.dataflowanalysis.dfd.datadictionary.NOT;
import org.dataflowanalysis.dfd.datadictionary.OR;
import org.dataflowanalysis.dfd.datadictionary.Pin;
import org.dataflowanalysis.dfd.datadictionary.datadictionaryFactory;
import org.dataflowanalysis.dfd.dataflowdiagram.DataFlowDiagram;
import org.dataflowanalysis.dfd.dataflowdiagram.External;
import org.dataflowanalysis.dfd.dataflowdiagram.Flow;
import org.dataflowanalysis.dfd.dataflowdiagram.Node;
import org.dataflowanalysis.dfd.dataflowdiagram.dataflowdiagramFactory;
import org.dataflowanalysis.pcm.extension.dictionary.characterized.DataDictionaryCharacterized.EnumCharacteristicType;
import org.dataflowanalysis.pcm.extension.dictionary.characterized.DataDictionaryCharacterized.Literal;
import org.dataflowanalysis.pcm.extension.dictionary.characterized.DataDictionaryCharacterized.expressions.And;
import org.dataflowanalysis.pcm.extension.dictionary.characterized.DataDictionaryCharacterized.expressions.False;
import org.dataflowanalysis.pcm.extension.dictionary.characterized.DataDictionaryCharacterized.expressions.Or;
import org.dataflowanalysis.pcm.extension.dictionary.characterized.DataDictionaryCharacterized.expressions.Term;
import org.dataflowanalysis.pcm.extension.dictionary.characterized.DataDictionaryCharacterized.expressions.True;
import org.dataflowanalysis.pcm.extension.model.confidentiality.ConfidentialityVariableCharacterisation;
import org.dataflowanalysis.pcm.extension.model.confidentiality.expression.LhsEnumCharacteristicReference;
import org.dataflowanalysis.pcm.extension.model.confidentiality.expression.NamedEnumCharacteristicReference;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.pcm.seff.AbstractAction;
import org.palladiosimulator.pcm.seff.AbstractBranchTransition;
import org.palladiosimulator.pcm.seff.BranchAction;
import org.palladiosimulator.pcm.seff.ExternalCallAction;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;
import org.palladiosimulator.pcm.seff.SetVariableAction;
import org.palladiosimulator.pcm.seff.StartAction;
import org.palladiosimulator.pcm.seff.StopAction;
import org.palladiosimulator.pcm.usagemodel.AbstractUserAction;
import org.palladiosimulator.pcm.usagemodel.EntryLevelSystemCall;
import org.palladiosimulator.pcm.usagemodel.Start;
import org.palladiosimulator.pcm.usagemodel.Stop;

public class PCMConverter
extends Converter {
    private final Map<AbstractPCMVertex<?>, Node> dfdNodeMap = new HashMap();
    private final Map<AbstractPCMVertex<?>, AbstractTransposeFlowGraph> pcmFlowMap = new HashMap();
    private DataDictionary dataDictionary;
    private DataFlowDiagram dataFlowDiagram;
    private Set<String> takenIds = new HashSet<String>();

    public DataFlowDiagramAndDictionary pcmToDFD(String modelLocation, String usageModelPath, String allocationPath, String nodeCharPath, Class<? extends Plugin> activator) {
        this.logger.setLevel(Level.TRACE);
        PCMDataFlowConfidentialityAnalysis analysis = new PCMDataFlowConfidentialityAnalysisBuilder().standalone().modelProjectName(modelLocation).usePluginActivator(activator).useUsageModel(usageModelPath).useAllocationModel(allocationPath).useNodeCharacteristicsModel(nodeCharPath).build();
        analysis.setLoggerLevel(Level.TRACE);
        analysis.initializeAnalysis();
        FlowGraphCollection flowGraph = analysis.findFlowGraphs();
        flowGraph.evaluate();
        return this.processPalladio(flowGraph);
    }

    public DataFlowDiagramAndDictionary pcmToDFD(String modelLocation, String usageModelPath, String allocationPath, String nodeCharPath) {
        this.logger.setLevel(Level.TRACE);
        PCMDataFlowConfidentialityAnalysis analysis = new PCMDataFlowConfidentialityAnalysisBuilder().standalone().modelProjectName(modelLocation).useUsageModel(usageModelPath).useAllocationModel(allocationPath).useNodeCharacteristicsModel(nodeCharPath).build();
        analysis.setLoggerLevel(Level.TRACE);
        analysis.initializeAnalysis();
        FlowGraphCollection flowGraph = analysis.findFlowGraphs();
        flowGraph.evaluate();
        return this.processPalladio(flowGraph);
    }

    public DataFlowDiagramAndDictionary pcmToDFD(FlowGraphCollection flowGraph) {
        return this.processPalladio(flowGraph);
    }

    public static String computeCompleteName(AbstractPCMVertex<?> vertex) {
        if (vertex instanceof CallingSEFFPCMVertex) {
            CallingSEFFPCMVertex cast = (CallingSEFFPCMVertex)vertex;
            if (cast.isCalling()) {
                return "Calling " + ((ExternalCallAction)cast.getReferencedElement()).getEntityName();
            }
            return "Returning " + ((ExternalCallAction)cast.getReferencedElement()).getEntityName();
        }
        if (vertex instanceof CallingUserPCMVertex) {
            CallingUserPCMVertex cast = (CallingUserPCMVertex)vertex;
            if (cast.isCalling()) {
                return "Calling " + ((EntryLevelSystemCall)cast.getReferencedElement()).getEntityName();
            }
            return "Returning " + ((EntryLevelSystemCall)cast.getReferencedElement()).getEntityName();
        }
        if (vertex instanceof SEFFPCMVertex) {
            Optional seff;
            SEFFPCMVertex cast = (SEFFPCMVertex)vertex;
            Object elementName = ((AbstractAction)cast.getReferencedElement()).getEntityName();
            if (cast.getReferencedElement() instanceof StartAction) {
                seff = PCMQueryUtils.findParentOfType((EObject)cast.getReferencedElement(), ResourceDemandingSEFF.class, (boolean)false);
                if (seff.isPresent()) {
                    elementName = "Beginning " + ((ResourceDemandingSEFF)seff.get()).getDescribedService__SEFF().getEntityName();
                }
                if (cast.isBranching() && seff.isPresent()) {
                    BranchAction branchAction = (BranchAction)PCMQueryUtils.findParentOfType((EObject)cast.getReferencedElement(), BranchAction.class, (boolean)false).orElseThrow(() -> new IllegalStateException("Cannot find branch action"));
                    AbstractBranchTransition branchTransition = (AbstractBranchTransition)PCMQueryUtils.findParentOfType((EObject)cast.getReferencedElement(), AbstractBranchTransition.class, (boolean)false).orElseThrow(() -> new IllegalStateException("Cannot find branch transition"));
                    elementName = "Branching " + ((ResourceDemandingSEFF)seff.get()).getDescribedService__SEFF().getEntityName() + "." + branchAction.getEntityName() + "." + branchTransition.getEntityName();
                }
            }
            if (cast.getReferencedElement() instanceof StopAction && (seff = PCMQueryUtils.findParentOfType((EObject)cast.getReferencedElement(), ResourceDemandingSEFF.class, (boolean)false)).isPresent()) {
                elementName = "Ending " + ((ResourceDemandingSEFF)seff.get()).getDescribedService__SEFF().getEntityName();
            }
            return elementName;
        }
        if (vertex instanceof UserPCMVertex) {
            UserPCMVertex cast = (UserPCMVertex)vertex;
            if (cast.getReferencedElement() instanceof Start || cast.getReferencedElement() instanceof Stop) {
                return cast.getEntityNameOfScenarioBehaviour();
            }
            return ((AbstractUserAction)cast.getReferencedElement()).getEntityName();
        }
        return vertex.getReferencedElement().getEntityName();
    }

    private DataFlowDiagramAndDictionary processPalladio(FlowGraphCollection flowGraphCollection) {
        this.dataDictionary = datadictionaryFactory.eINSTANCE.createDataDictionary();
        this.dataFlowDiagram = dataflowdiagramFactory.eINSTANCE.createDataFlowDiagram();
        for (AbstractTransposeFlowGraph transposeFlowGraph : flowGraphCollection.getTransposeFlowGraphs()) {
            transposeFlowGraph.getVertices().stream().filter(it -> it instanceof AbstractPCMVertex).map(it -> (AbstractPCMVertex)it).forEach(it -> this.processVertex((AbstractPCMVertex<? extends Entity>)it, transposeFlowGraph));
        }
        for (AbstractTransposeFlowGraph transposeFlowGraph : flowGraphCollection.getTransposeFlowGraphs()) {
            transposeFlowGraph.getVertices().stream().filter(it -> it instanceof AbstractPCMVertex).map(it -> (AbstractPCMVertex)it).forEach(it -> this.createFlowsForVertex((AbstractPCMVertex<? extends Entity>)it));
        }
        for (AbstractTransposeFlowGraph transposeFlowGraph : flowGraphCollection.getTransposeFlowGraphs()) {
            transposeFlowGraph.getVertices().stream().filter(it -> it instanceof AbstractPCMVertex).map(it -> (AbstractPCMVertex)it).forEach(it -> this.createBehavior((AbstractPCMVertex<? extends Entity>)it));
        }
        flowGraphCollection.getTransposeFlowGraphs().stream().map(it -> it.getSink()).forEach(sink -> {
            Node node = this.dfdNodeMap.get(sink);
            node.getBehavior().getOutPin().clear();
            node.getBehavior().getAssignment().clear();
        });
        return new DataFlowDiagramAndDictionary(this.dataFlowDiagram, this.dataDictionary);
    }

    private void processVertex(AbstractPCMVertex<? extends Entity> pcmVertex, AbstractTransposeFlowGraph transposeFlowGraph) {
        this.pcmFlowMap.put(pcmVertex, transposeFlowGraph);
        Node node = this.getDFDNode(pcmVertex);
        this.createPinsFromVertex(node, pcmVertex);
    }

    private void createFlowsForVertex(AbstractPCMVertex<? extends Entity> pcmVertex) {
        pcmVertex.getPreviousElements().forEach(previousElement -> this.createFlows((AbstractPCMVertex<? extends Entity>)previousElement, pcmVertex));
    }

    private void createBehavior(AbstractPCMVertex<? extends Entity> pcmVertex) {
        Node node = this.getDFDNode(pcmVertex);
        this.convertBehavior(pcmVertex, node, this.dataDictionary);
    }

    private void createPinsFromVertex(Node node, AbstractPCMVertex<? extends Entity> pcmVertex) {
        Behavior behaviour = node.getBehavior();
        pcmVertex.getAllIncomingDataCharacteristics().forEach(idc -> {
            Pin pin = datadictionaryFactory.eINSTANCE.createPin();
            pin.setEntityName(idc.getVariableName());
            behaviour.getInPin().add(pin);
        });
        pcmVertex.getAllOutgoingDataCharacteristics().forEach(odc -> {
            Pin pin = datadictionaryFactory.eINSTANCE.createPin();
            pin.setEntityName(odc.getVariableName());
            behaviour.getOutPin().add(pin);
        });
    }

    private void createFlows(AbstractPCMVertex<? extends Entity> sourceVertex, AbstractPCMVertex<? extends Entity> destinationVertex) {
        List<String> intersectingDataCharacteristics = sourceVertex.getAllOutgoingDataCharacteristics().stream().map(odc -> odc.getVariableName()).filter(odc -> destinationVertex.getAllIncomingDataCharacteristics().stream().map(idc -> idc.getVariableName()).toList().contains(odc)).toList();
        if (intersectingDataCharacteristics.size() == 0) {
            this.createEmptyFlowForNoDataCharacteristics(sourceVertex, destinationVertex);
        } else {
            this.createFlowForListOfCharacteristics(sourceVertex, destinationVertex, intersectingDataCharacteristics);
        }
    }

    private void createFlowForListOfCharacteristics(AbstractPCMVertex<? extends Entity> sourceVertex, AbstractPCMVertex<? extends Entity> destinationVertex, List<String> intersectingDataCharacteristics) {
        Node sourceNode = this.dfdNodeMap.get(sourceVertex);
        Node destinationNode = this.dfdNodeMap.get(destinationVertex);
        for (String dataCharacteristic : intersectingDataCharacteristics) {
            Flow flow = dataflowdiagramFactory.eINSTANCE.createFlow();
            Pin inPin = destinationNode.getBehavior().getInPin().stream().filter(pin -> pin.getEntityName().equals(dataCharacteristic)).toList().get(0);
            Pin outPin = sourceNode.getBehavior().getOutPin().stream().filter(pin -> pin.getEntityName().equals(dataCharacteristic)).toList().get(0);
            flow.setEntityName(dataCharacteristic);
            flow.setDestinationNode(destinationNode);
            flow.setSourceNode(sourceNode);
            flow.setDestinationPin(inPin);
            flow.setSourcePin(outPin);
            this.dataFlowDiagram.getFlows().add(flow);
        }
    }

    private void createEmptyFlowForNoDataCharacteristics(AbstractPCMVertex<? extends Entity> sourceVertex, AbstractPCMVertex<? extends Entity> destinationVertex) {
        Node sourceNode = this.dfdNodeMap.get(sourceVertex);
        Node destinationNode = this.dfdNodeMap.get(destinationVertex);
        Flow flow = dataflowdiagramFactory.eINSTANCE.createFlow();
        Pin inPin = datadictionaryFactory.eINSTANCE.createPin();
        Pin outPin = datadictionaryFactory.eINSTANCE.createPin();
        inPin.setEntityName("");
        outPin.setEntityName("");
        flow.setDestinationNode(destinationNode);
        flow.setSourceNode(sourceNode);
        flow.setDestinationPin(inPin);
        flow.setSourcePin(outPin);
        flow.setEntityName("");
        this.dataFlowDiagram.getFlows().add(flow);
        sourceNode.getBehavior().getOutPin().add(outPin);
        destinationNode.getBehavior().getInPin().add(inPin);
        Assignment assignment = datadictionaryFactory.eINSTANCE.createAssignment();
        assignment.setTerm((org.dataflowanalysis.dfd.datadictionary.Term)datadictionaryFactory.eINSTANCE.createTRUE());
        assignment.setOutputPin(outPin);
    }

    private Node getDFDNode(AbstractPCMVertex<? extends Entity> pcmVertex) {
        Node dfdNode = this.dfdNodeMap.get(pcmVertex);
        if (dfdNode == null) {
            dfdNode = this.createCorrespondingDFDNode(pcmVertex);
            this.addNodeCharacteristicsToNode(dfdNode, pcmVertex.getAllVertexCharacteristics());
            this.dfdNodeMap.put(pcmVertex, dfdNode);
        }
        return dfdNode;
    }

    private Node createCorrespondingDFDNode(AbstractPCMVertex<? extends Entity> pcmVertex) {
        External node;
        if (pcmVertex instanceof UserPCMVertex) {
            node = dataflowdiagramFactory.eINSTANCE.createExternal();
        } else if (pcmVertex instanceof SEFFPCMVertex) {
            node = dataflowdiagramFactory.eINSTANCE.createProcess();
        } else {
            this.logger.error((Object)"Unregcognized palladio element");
            return null;
        }
        Behavior behaviour = datadictionaryFactory.eINSTANCE.createBehavior();
        node.setEntityName(PCMConverter.computeCompleteName(pcmVertex));
        Object id = pcmVertex.getReferencedElement().getId();
        int occurrences = 1;
        while (this.takenIds.contains(id)) {
            id = pcmVertex.getReferencedElement().getId() + "_" + occurrences;
            ++occurrences;
        }
        node.setId((String)id);
        this.takenIds.add((String)id);
        node.setBehavior(behaviour);
        this.dataDictionary.getBehavior().add(behaviour);
        this.dataFlowDiagram.getNodes().add(node);
        return node;
    }

    private void addNodeCharacteristicsToNode(Node node, List<CharacteristicValue> charValues) {
        for (CharacteristicValue charValue : charValues) {
            LabelType type = this.getOrCreateLabelType(charValue.getTypeName());
            Label label = this.getOrCreateDFDLabel(charValue.getValueName(), type);
            if (node.getProperties().contains(label)) continue;
            node.getProperties().add(label);
        }
    }

    private LabelType getOrCreateLabelType(String name) {
        LabelType type = this.dataDictionary.getLabelTypes().stream().filter(f -> f.getEntityName().equals(name)).findFirst().orElseGet(() -> this.createLabelType(name));
        return type;
    }

    private Label getOrCreateDFDLabel(String labelName, LabelType type) {
        Label label = type.getLabel().stream().filter(f -> f.getEntityName().equals(labelName)).findFirst().orElseGet(() -> this.createLabel(labelName, type));
        return label;
    }

    private Label createLabel(String name, LabelType type) {
        Label label = datadictionaryFactory.eINSTANCE.createLabel();
        label.setEntityName(name);
        type.getLabel().add(label);
        return label;
    }

    private LabelType createLabelType(String name) {
        LabelType type = datadictionaryFactory.eINSTANCE.createLabelType();
        type.setEntityName(name);
        this.dataDictionary.getLabelTypes().add(type);
        return type;
    }

    private List<ConfidentialityVariableCharacterisation> getVariableCharacterizations(AbstractPCMVertex<?> vertex) {
        Entity entity;
        Entity entity2;
        Entity entity3;
        Entity entity4 = vertex.getReferencedElement();
        if (entity4 instanceof SetVariableAction) {
            SetVariableAction setVariableAction = (SetVariableAction)entity4;
            return setVariableAction.getLocalVariableUsages_SetVariableAction().stream().map(VariableUsage::getVariableCharacterisation_VariableUsage).flatMap(Collection::stream).filter(ConfidentialityVariableCharacterisation.class::isInstance).map(ConfidentialityVariableCharacterisation.class::cast).toList();
        }
        Entity entity5 = vertex.getReferencedElement();
        if (entity5 instanceof ExternalCallAction) {
            CallingSEFFPCMVertex callingSEFFPCMVertex;
            ExternalCallAction externalCallAction = (ExternalCallAction)entity5;
            if (vertex instanceof CallingSEFFPCMVertex && (callingSEFFPCMVertex = (CallingSEFFPCMVertex)vertex).isCalling()) {
                return externalCallAction.getInputVariableUsages__CallAction().stream().map(VariableUsage::getVariableCharacterisation_VariableUsage).flatMap(Collection::stream).filter(ConfidentialityVariableCharacterisation.class::isInstance).map(ConfidentialityVariableCharacterisation.class::cast).toList();
            }
        }
        if ((entity3 = vertex.getReferencedElement()) instanceof ExternalCallAction) {
            CallingSEFFPCMVertex callingSEFFPCMVertex;
            ExternalCallAction externalCallAction = (ExternalCallAction)entity3;
            if (vertex instanceof CallingSEFFPCMVertex && (callingSEFFPCMVertex = (CallingSEFFPCMVertex)vertex).isReturning()) {
                return externalCallAction.getReturnVariableUsage__CallReturnAction().stream().map(VariableUsage::getVariableCharacterisation_VariableUsage).flatMap(Collection::stream).filter(ConfidentialityVariableCharacterisation.class::isInstance).map(ConfidentialityVariableCharacterisation.class::cast).toList();
            }
        }
        if ((entity2 = vertex.getReferencedElement()) instanceof EntryLevelSystemCall) {
            CallingUserPCMVertex callingUserPCMVertex;
            EntryLevelSystemCall entryLevelSystemCall = (EntryLevelSystemCall)entity2;
            if (vertex instanceof CallingUserPCMVertex && (callingUserPCMVertex = (CallingUserPCMVertex)vertex).isCalling()) {
                return entryLevelSystemCall.getInputParameterUsages_EntryLevelSystemCall().stream().map(VariableUsage::getVariableCharacterisation_VariableUsage).flatMap(Collection::stream).filter(ConfidentialityVariableCharacterisation.class::isInstance).map(ConfidentialityVariableCharacterisation.class::cast).toList();
            }
        }
        if ((entity = vertex.getReferencedElement()) instanceof EntryLevelSystemCall) {
            CallingUserPCMVertex callingUserPCMVertex;
            EntryLevelSystemCall entryLevelSystemCall = (EntryLevelSystemCall)entity;
            if (vertex instanceof CallingUserPCMVertex && (callingUserPCMVertex = (CallingUserPCMVertex)vertex).isReturning()) {
                return entryLevelSystemCall.getOutputParameterUsages_EntryLevelSystemCall().stream().map(VariableUsage::getVariableCharacterisation_VariableUsage).flatMap(Collection::stream).filter(ConfidentialityVariableCharacterisation.class::isInstance).map(ConfidentialityVariableCharacterisation.class::cast).toList();
            }
        }
        return List.of();
    }

    private List<AbstractAssignment> getAssignments(AbstractPCMVertex<?> vertex, Node node) {
        if (vertex instanceof UserPCMVertex && vertex.getReferencedElement() instanceof Start) {
            return List.of();
        }
        ArrayList<AbstractAssignment> assignments = new ArrayList<AbstractAssignment>();
        if (vertex.getAllIncomingDataCharacteristics().isEmpty()) {
            vertex.getAllOutgoingDataCharacteristics().forEach(it -> {
                Pin outPin = node.getBehavior().getOutPin().stream().filter(pin -> pin.getEntityName().equals(it.getVariableName())).findAny().orElseThrow();
                Assignment assignment = datadictionaryFactory.eINSTANCE.createAssignment();
                assignment.setTerm((org.dataflowanalysis.dfd.datadictionary.Term)datadictionaryFactory.eINSTANCE.createTRUE());
                assignment.setOutputPin(outPin);
                assignment.getOutputLabels().addAll(it.getAllCharacteristics().stream().map(characteristicValue -> {
                    LabelType type = this.getOrCreateLabelType(characteristicValue.getTypeName());
                    return this.getOrCreateDFDLabel(characteristicValue.getValueName(), type);
                }).toList());
                assignments.add((AbstractAssignment)assignment);
            });
        }
        List<DataCharacteristic> dataCharacteristicsForwarded = vertex.getAllIncomingDataCharacteristics().stream().filter(it -> vertex.getAllOutgoingDataCharacteristics().stream().anyMatch(ot -> it.getVariableName().equals(ot.getVariableName()))).toList();
        for (DataCharacteristic dataCharacteristic : dataCharacteristicsForwarded) {
            assignments.add(this.forwardCharacteristic(node, vertex, dataCharacteristic));
        }
        if (dataCharacteristicsForwarded.isEmpty() && vertex.getAllIncomingDataCharacteristics().isEmpty() && vertex.getAllOutgoingDataCharacteristics().isEmpty() && (!(vertex instanceof UserPCMVertex) || ((AbstractUserAction)vertex.getReferencedElement()).getScenarioBehaviour_AbstractUserAction().getUsageScenario_SenarioBehaviour() == null)) {
            assignments.add(this.preserveControlFlow(node, vertex));
        }
        return assignments;
    }

    private AbstractAssignment forwardCharacteristic(Node node, AbstractPCMVertex<?> vertex, DataCharacteristic dataCharacteristic) {
        ForwardingAssignment assignment = datadictionaryFactory.eINSTANCE.createForwardingAssignment();
        Pin inPin = node.getBehavior().getInPin().stream().filter(it -> it.getEntityName().equals(dataCharacteristic.getVariableName())).findAny().orElseThrow(() -> {
            this.logger.error((Object)("Cannot find required in-pin " + dataCharacteristic.getVariableName() + " at vertex with name " + String.valueOf(vertex)));
            return new NoSuchElementException();
        });
        Pin outPin = node.getBehavior().getOutPin().stream().filter(it -> it.getEntityName().equals(dataCharacteristic.getVariableName())).findAny().orElseThrow(() -> {
            this.logger.error((Object)("Cannot find required out-pin " + dataCharacteristic.getVariableName() + " at vertex with name " + String.valueOf(vertex)));
            return new NoSuchElementException();
        });
        assignment.getInputPins().add(inPin);
        assignment.setOutputPin(outPin);
        return assignment;
    }

    private AbstractAssignment preserveControlFlow(Node node, AbstractPCMVertex<?> vertex) {
        ForwardingAssignment assignment = datadictionaryFactory.eINSTANCE.createForwardingAssignment();
        Pin inPin = node.getBehavior().getInPin().stream().filter(it -> it.getEntityName().equals("")).findAny().orElseThrow(() -> {
            this.logger.error((Object)("Cannot find required in-pin with empty name at vertex with name " + String.valueOf(vertex)));
            return new NoSuchElementException();
        });
        Pin outPin = node.getBehavior().getOutPin().stream().filter(it -> it.getEntityName().equals("")).findAny().orElseThrow(() -> {
            this.logger.error((Object)("Cannot find required out-pin with empty name at vertex with name " + String.valueOf(vertex)));
            return new NoSuchElementException();
        });
        assignment.getInputPins().add(inPin);
        assignment.setOutputPin(outPin);
        return assignment;
    }

    private List<AbstractAssignment> processCharacterization(ConfidentialityVariableCharacterisation variableCharacterisation, Behavior behaviour, Node node, AbstractPCMVertex<?> vertex) {
        LhsEnumCharacteristicReference leftHandSide = (LhsEnumCharacteristicReference)variableCharacterisation.getLhs();
        EnumCharacteristicType characteristicType = (EnumCharacteristicType)leftHandSide.getCharacteristicType();
        Literal characteristicValue = leftHandSide.getLiteral();
        AbstractNamedReference reference = variableCharacterisation.getVariableUsage_VariableCharacterisation().getNamedReference__VariableUsage();
        Term rightHandSide = variableCharacterisation.getRhs();
        if (characteristicType == null && characteristicValue == null) {
            return List.of(this.processFullForwardingAssignment(node, rightHandSide, reference));
        }
        if (characteristicValue == null) {
            return this.processHalfForwardingAssignment(node, rightHandSide, reference, vertex, behaviour, characteristicType);
        }
        return List.of(this.processAssignment(node, rightHandSide, behaviour, reference, characteristicType, characteristicValue));
    }

    /*
     * WARNING - void declaration
     */
    private AbstractAssignment processFullForwardingAssignment(Node node, Term rightHandSide, AbstractNamedReference reference) {
        void namedEnumCharacteristicReference;
        if (!(rightHandSide instanceof NamedEnumCharacteristicReference)) {
            return datadictionaryFactory.eINSTANCE.createForwardingAssignment();
        }
        NamedEnumCharacteristicReference namedEnumCharacteristicReference2 = (NamedEnumCharacteristicReference)rightHandSide;
        ForwardingAssignment assignment = datadictionaryFactory.eINSTANCE.createForwardingAssignment();
        Pin outPin = node.getBehavior().getOutPin().stream().filter(it -> it.getEntityName().equals(reference.getReferenceName())).findAny().orElseThrow();
        assignment.setOutputPin(outPin);
        Optional<Pin> inPin = node.getBehavior().getInPin().stream().filter(arg_0 -> PCMConverter.lambda$59((NamedEnumCharacteristicReference)namedEnumCharacteristicReference, arg_0)).findAny();
        if (inPin.isPresent()) {
            assignment.getInputPins().add(inPin.get());
        } else {
            this.logger.warn((Object)"One StoEx references incoming data that is not incoming!");
        }
        return assignment;
    }

    private List<AbstractAssignment> processHalfForwardingAssignment(Node node, Term rightHandSide, AbstractNamedReference reference, AbstractPCMVertex<?> vertex, Behavior behaviour, EnumCharacteristicType characteristicType) {
        ArrayList<AbstractAssignment> assignments = new ArrayList<AbstractAssignment>();
        EList forwardedValues = characteristicType.getType().getLiterals();
        for (Literal value : forwardedValues) {
            Assignment assignment = datadictionaryFactory.eINSTANCE.createAssignment();
            LabelType labelType = this.getOrCreateLabelType(characteristicType.getName());
            Label label = this.getOrCreateDFDLabel(value.getName(), labelType);
            assignment.getOutputLabels().add(label);
            Pin outPin = node.getBehavior().getOutPin().stream().filter(it -> it.getEntityName().equals(reference.getReferenceName())).findAny().orElseThrow();
            assignment.setOutputPin(outPin);
            org.dataflowanalysis.dfd.datadictionary.Term term = this.parseTerm(rightHandSide, this.dataDictionary, label);
            assignment.setTerm(term);
            if (rightHandSide instanceof NamedEnumCharacteristicReference) {
                NamedEnumCharacteristicReference namedEnumCharacteristicReference = (NamedEnumCharacteristicReference)rightHandSide;
                Pin inPin = node.getBehavior().getInPin().stream().filter(it -> it.getEntityName().equals(namedEnumCharacteristicReference.getNamedReference().getReferenceName())).findAny().orElseThrow();
                assignment.getInputPins().add(inPin);
            } else {
                assignment.getInputPins().addAll(behaviour.getInPin());
            }
            assignments.add((AbstractAssignment)assignment);
        }
        return assignments;
    }

    private AbstractAssignment processAssignment(Node node, Term rightHandSide, Behavior behaviour, AbstractNamedReference reference, EnumCharacteristicType characteristicType, Literal characteristicValue) {
        Assignment assignment = datadictionaryFactory.eINSTANCE.createAssignment();
        LabelType labelType = this.getOrCreateLabelType(characteristicType.getName());
        Label label = this.getOrCreateDFDLabel(characteristicValue.getName(), labelType);
        assignment.getOutputLabels().add(label);
        Pin outPin = node.getBehavior().getOutPin().stream().filter(it -> it.getEntityName().equals(reference.getReferenceName())).findAny().orElseThrow();
        assignment.setOutputPin(outPin);
        org.dataflowanalysis.dfd.datadictionary.Term term = this.parseTerm(rightHandSide, this.dataDictionary);
        assignment.setTerm(term);
        if (rightHandSide instanceof NamedEnumCharacteristicReference) {
            NamedEnumCharacteristicReference namedEnumCharacteristicReference = (NamedEnumCharacteristicReference)rightHandSide;
            Pin inPin = node.getBehavior().getInPin().stream().filter(it -> it.getEntityName().equals(namedEnumCharacteristicReference.getNamedReference().getReferenceName())).findAny().orElseThrow();
            assignment.getInputPins().add(inPin);
        } else {
            assignment.getInputPins().addAll(behaviour.getInPin());
        }
        return assignment;
    }

    public void convertBehavior(AbstractPCMVertex<?> pcmVertex, Node node, DataDictionary dataDictionary) {
        List<ConfidentialityVariableCharacterisation> variableCharacterisations = this.getVariableCharacterizations(pcmVertex);
        Behavior behaviour = node.getBehavior();
        List<AbstractAssignment> assignments = this.getAssignments(pcmVertex, node);
        for (ConfidentialityVariableCharacterisation variableCharacterization : variableCharacterisations) {
            assignments.addAll(this.processCharacterization(variableCharacterization, behaviour, node, pcmVertex));
        }
        behaviour.getAssignment().clear();
        behaviour.getAssignment().addAll(assignments);
        behaviour.getOutPin().stream().forEach(pin -> {
            Assignment assignment = datadictionaryFactory.eINSTANCE.createAssignment();
            assignment.setEntityName("Dummy Assignment");
            assignment.getInputPins().addAll(behaviour.getInPin());
            assignment.setOutputPin(pin);
            assignment.setTerm((org.dataflowanalysis.dfd.datadictionary.Term)datadictionaryFactory.eINSTANCE.createTRUE());
            behaviour.getAssignment().add(assignment);
        });
    }

    public org.dataflowanalysis.dfd.datadictionary.Term parseTerm(Term rightHandSide, DataDictionary dataDictionary, Label wildcardLabel) {
        if (rightHandSide instanceof True) {
            return datadictionaryFactory.eINSTANCE.createTRUE();
        }
        if (rightHandSide instanceof False) {
            NOT term = datadictionaryFactory.eINSTANCE.createNOT();
            term.setNegatedTerm((org.dataflowanalysis.dfd.datadictionary.Term)datadictionaryFactory.eINSTANCE.createTRUE());
            return term;
        }
        if (rightHandSide instanceof Or) {
            Or or = (Or)rightHandSide;
            OR term = datadictionaryFactory.eINSTANCE.createOR();
            term.getTerms().add(this.parseTerm(or.getLeft(), dataDictionary, wildcardLabel));
            term.getTerms().add(this.parseTerm(or.getRight(), dataDictionary, wildcardLabel));
            return term;
        }
        if (rightHandSide instanceof And) {
            And and = (And)rightHandSide;
            AND term = datadictionaryFactory.eINSTANCE.createAND();
            term.getTerms().add(this.parseTerm(and.getLeft(), dataDictionary, wildcardLabel));
            term.getTerms().add(this.parseTerm(and.getRight(), dataDictionary, wildcardLabel));
            return term;
        }
        if (rightHandSide instanceof NamedEnumCharacteristicReference) {
            NamedEnumCharacteristicReference characteristicReference = (NamedEnumCharacteristicReference)rightHandSide;
            LabelReference term = datadictionaryFactory.eINSTANCE.createLabelReference();
            LabelType labelType = this.getOrCreateLabelType(characteristicReference.getCharacteristicType().getName());
            if (characteristicReference.getLiteral() != null) {
                Label label = this.getOrCreateDFDLabel(characteristicReference.getLiteral().getName(), labelType);
                term.setLabel(label);
            } else {
                term.setLabel(wildcardLabel);
            }
            return term;
        }
        throw new IllegalStateException();
    }

    public org.dataflowanalysis.dfd.datadictionary.Term parseTerm(Term rightHandSide, DataDictionary dataDictionary) {
        return this.parseTerm(rightHandSide, dataDictionary, null);
    }

    public Map<AbstractPCMVertex<?>, Node> getDfdNodeMap() {
        return this.dfdNodeMap;
    }

    public Map<AbstractPCMVertex<?>, AbstractTransposeFlowGraph> getPcmFlowMap() {
        return this.pcmFlowMap;
    }

    private static /* synthetic */ boolean lambda$59(NamedEnumCharacteristicReference namedEnumCharacteristicReference, Pin it) {
        return it.getEntityName().equals(namedEnumCharacteristicReference.getNamedReference().getReferenceName()) || it.getEntityName().equals("");
    }
}

