/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.converter;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.dataflowanalysis.converter.BehaviorConverter;
import org.dataflowanalysis.converter.Converter;
import org.dataflowanalysis.converter.DataFlowDiagramAndDictionary;
import org.dataflowanalysis.converter.webdfd.Child;
import org.dataflowanalysis.converter.webdfd.Port;
import org.dataflowanalysis.converter.webdfd.Value;
import org.dataflowanalysis.converter.webdfd.WebEditorDfd;
import org.dataflowanalysis.converter.webdfd.WebEditorLabelType;
import org.dataflowanalysis.dfd.datadictionary.Behavior;
import org.dataflowanalysis.dfd.datadictionary.DataDictionary;
import org.dataflowanalysis.dfd.datadictionary.Label;
import org.dataflowanalysis.dfd.datadictionary.LabelType;
import org.dataflowanalysis.dfd.datadictionary.Pin;
import org.dataflowanalysis.dfd.datadictionary.datadictionaryFactory;
import org.dataflowanalysis.dfd.dataflowdiagram.DataFlowDiagram;
import org.dataflowanalysis.dfd.dataflowdiagram.Flow;
import org.dataflowanalysis.dfd.dataflowdiagram.Node;
import org.dataflowanalysis.dfd.dataflowdiagram.dataflowdiagramFactory;

public class WebEditorConverter
extends Converter {
    private final dataflowdiagramFactory dfdFactory;
    private final datadictionaryFactory ddFactory;
    private Map<String, Node> idToNodeMap;
    private final Logger logger = Logger.getLogger(WebEditorConverter.class);
    protected static final String DELIMITER_PIN_NAME = "|";
    protected static final String DELIMITER_MULTI_PIN = ",";
    private BehaviorConverter behaviorConverter;

    public WebEditorConverter() {
        this.dfdFactory = dataflowdiagramFactory.eINSTANCE;
        this.ddFactory = datadictionaryFactory.eINSTANCE;
    }

    public DataFlowDiagramAndDictionary webToDfd(String inputFile) {
        return this.webToDfd(this.loadWeb(inputFile).get());
    }

    public DataFlowDiagramAndDictionary webToDfd(WebEditorDfd inputFile) {
        return this.processWeb(inputFile);
    }

    public Optional<WebEditorDfd> loadWeb(String inputFile) {
        this.objectMapper = new ObjectMapper();
        this.file = new File(inputFile);
        try {
            WebEditorDfd result = (WebEditorDfd)this.objectMapper.readValue(this.file, WebEditorDfd.class);
            return Optional.ofNullable(result);
        }
        catch (IOException e) {
            this.logger.error((Object)"Could not load web dfd:", (Throwable)e);
            return Optional.empty();
        }
    }

    private DataFlowDiagramAndDictionary processWeb(WebEditorDfd webdfd) {
        this.idToNodeMap = new HashMap<String, Node>();
        HashMap<String, Node> pinToNodeMap = new HashMap<String, Node>();
        HashMap<String, Pin> idToPinMap = new HashMap<String, Pin>();
        HashMap<String, Label> idToLabelMap = new HashMap<String, Label>();
        HashMap<Node, Map<Pin, String>> nodeOutpinBehaviorMap = new HashMap<Node, Map<Pin, String>>();
        DataFlowDiagram dataFlowDiagram = this.dfdFactory.createDataFlowDiagram();
        DataDictionary dataDictionary = this.ddFactory.createDataDictionary();
        this.behaviorConverter = new BehaviorConverter(dataDictionary);
        this.createLabelTypes(webdfd, idToLabelMap, dataDictionary);
        this.createNodes(webdfd, pinToNodeMap, idToPinMap, idToLabelMap, nodeOutpinBehaviorMap, dataFlowDiagram, dataDictionary);
        this.createFlows(webdfd, pinToNodeMap, idToPinMap, dataFlowDiagram);
        List<Node> nodesInBehavior = nodeOutpinBehaviorMap.keySet().stream().collect(Collectors.toList());
        nodesInBehavior.forEach(node -> {
            Map outpinBehaviors = (Map)nodeOutpinBehaviorMap.get(node);
            outpinBehaviors.forEach((outpin, behavior) -> this.parseBehavior((Node)node, (Pin)outpin, (String)behavior, dataFlowDiagram, dataDictionary));
        });
        return new DataFlowDiagramAndDictionary(dataFlowDiagram, dataDictionary);
    }

    private void createNodes(WebEditorDfd webdfd, Map<String, Node> pinToNodeMap, Map<String, Pin> pinMap, Map<String, Label> idToLabelMap, Map<Node, Map<Pin, String>> nodeOutpinBehavior, DataFlowDiagram dataFlowDiagram, DataDictionary dataDictionary) {
        for (Child child : webdfd.model().children()) {
            String[] type = child.type().split(":");
            String name = child.text();
            if (!type[0].equals("node")) continue;
            Optional<Object> nodeOptional = switch (type[1]) {
                case "function" -> Optional.of(this.dfdFactory.createProcess());
                case "storage" -> Optional.of(this.dfdFactory.createStore());
                case "input-output" -> Optional.of(this.dfdFactory.createExternal());
                default -> {
                    this.logger.error((Object)("Unrecognized node type: " + type[1]));
                    yield Optional.empty();
                }
            };
            Node node = (Node)nodeOptional.get();
            node.setEntityName(name);
            node.setId(child.id());
            Behavior behaviour = this.ddFactory.createBehavior();
            behaviour.setEntityName(name);
            node.setBehavior(behaviour);
            dataDictionary.getBehavior().add(behaviour);
            this.createPins(pinToNodeMap, pinMap, nodeOutpinBehavior, child, node);
            List<Label> labelsAtNode = child.labels().stream().map(it -> (Label)idToLabelMap.get(it.labelTypeValueId())).toList();
            node.getProperties().addAll(labelsAtNode);
            dataFlowDiagram.getNodes().add(node);
            this.idToNodeMap.put(child.id(), node);
        }
    }

    private void createFlows(WebEditorDfd webdfd, Map<String, Node> pinToNodeMap, Map<String, Pin> pinMap, DataFlowDiagram dataFlowDiagram) {
        webdfd.model().children().stream().filter(child -> child.type().contains("edge:")).forEach(child -> {
            Node source = (Node)pinToNodeMap.get(child.sourceId());
            Node dest = (Node)pinToNodeMap.get(child.targetId());
            Flow flow = this.dfdFactory.createFlow();
            flow.setSourceNode(source);
            flow.setDestinationNode(dest);
            flow.setEntityName(child.text());
            Pin destPin = (Pin)pinMap.get(child.targetId());
            Pin sourcePin = (Pin)pinMap.get(child.sourceId());
            destPin.setEntityName(destPin.getEntityName() + child.text());
            sourcePin.setEntityName(sourcePin.getEntityName() + child.text());
            flow.setDestinationPin(destPin);
            flow.setSourcePin(sourcePin);
            flow.setId(child.id());
            dataFlowDiagram.getFlows().add(flow);
        });
    }

    private void createPins(Map<String, Node> pinToNodeMap, Map<String, Pin> pinMap, Map<Node, Map<Pin, String>> nodeOutpinBehavior, Child child, Node node) {
        for (Port port : child.ports()) {
            switch (port.type()) {
                case "port:dfd-input": {
                    pinMap.put(port.id(), this.createInPin(node, port));
                    break;
                }
                case "port:dfd-output": {
                    pinMap.put(port.id(), this.createOutPin(nodeOutpinBehavior, node, port));
                    break;
                }
                default: {
                    this.logger.error((Object)"Unrecognized port type");
                }
            }
            pinToNodeMap.put(port.id(), node);
        }
    }

    private Pin createOutPin(Map<Node, Map<Pin, String>> nodeOutpinBehavior, Node node, Port port) {
        Pin outPin = this.ddFactory.createPin();
        outPin.setId(port.id());
        outPin.setEntityName(node.getEntityName() + "_out_");
        node.getBehavior().getOutPin().add(outPin);
        if (port.behavior() != null) {
            this.putValue(nodeOutpinBehavior, node, outPin, port.behavior());
        }
        return outPin;
    }

    private Pin createInPin(Node node, Port port) {
        Pin inPin = this.ddFactory.createPin();
        inPin.setId(port.id());
        inPin.setEntityName(node.getEntityName() + "_in_");
        node.getBehavior().getInPin().add(inPin);
        return inPin;
    }

    private void createLabelTypes(WebEditorDfd webdfd, Map<String, Label> idToLabelMap, DataDictionary dataDictionary) {
        for (WebEditorLabelType webLabelType : webdfd.labelTypes()) {
            LabelType labelType = this.ddFactory.createLabelType();
            labelType.setEntityName(webLabelType.name());
            labelType.setId(webLabelType.id());
            for (Value value : webLabelType.values()) {
                this.createLabel(idToLabelMap, labelType, value);
            }
            dataDictionary.getLabelTypes().add(labelType);
        }
    }

    private void createLabel(Map<String, Label> idToLabelMap, LabelType labelType, Value value) {
        Label label = this.ddFactory.createLabel();
        label.setEntityName(value.text());
        label.setId(value.id());
        labelType.getLabel().add(label);
        idToLabelMap.put(label.getId(), label);
    }

    /*
     * Unable to fully structure code
     */
    private void parseBehavior(Node node, Pin outpin, String lines, DataFlowDiagram dfd, DataDictionary dd) {
        behaviorStrings = lines.split("\n");
        behavior = node.getBehavior();
        var11_8 = behaviorStrings;
        var10_9 = behaviorStrings.length;
        var9_10 = 0;
        while (var9_10 < var10_9) {
            behaviorString = var11_8[var9_10];
            try {
                block8: {
                    block7: {
                        block6: {
                            if (!behaviorString.startsWith("forward")) break block6;
                            assignment = this.ddFactory.createForwardingAssignment();
                            inPins = this.getInPinsFromString(behaviorString.split(" ")[1], node, dfd);
                            assignment.getInputPins().addAll(inPins);
                            abstractAssignment = assignment;
                            ** GOTO lbl49
                        }
                        if (!behaviorString.startsWith("set")) break block7;
                        assignment = this.ddFactory.createSetAssignment();
                        outLabels = this.getLabelFromString(behaviorString.split(" ")[1], dd);
                        assignment.getOutputLabels().addAll(outLabels);
                        abstractAssignment = assignment;
                        ** GOTO lbl49
                    }
                    if (!behaviorString.startsWith("unset")) break block8;
                    assignment = this.ddFactory.createUnsetAssignment();
                    outLabels = this.getLabelFromString(behaviorString.split(" ")[1], dd);
                    assignment.getOutputLabels().addAll(outLabels);
                    abstractAssignment = assignment;
                    ** GOTO lbl49
                }
                if (!behaviorString.contains("assign")) {
                    this.logger.error((Object)("Unrecognized assignment: " + behaviorString));
                } else {
                    assignment = this.ddFactory.createAssignment();
                    outLabels = this.getLabelFromString(behaviorString.replaceFirst("assign", "").split(" if ")[0].trim(), dd);
                    remainder = behaviorString.replaceFirst("assign", "").split(" if ")[1].trim();
                    if (remainder.contains(" from ")) {
                        inputPins = this.getInPinsFromString(remainder.split(" from ")[1].trim(), node, dfd);
                        assignment.getInputPins().addAll(inputPins);
                        remainder = remainder.split(" from ")[0].trim();
                    }
                    term = this.behaviorConverter.stringToTerm(remainder);
                    assignment.setTerm(term);
                    assignment.getOutputLabels().addAll(outLabels);
                    abstractAssignment = assignment;
lbl49:
                    // 4 sources

                    abstractAssignment.setOutputPin(outpin);
                    behavior.getAssignment().add(abstractAssignment);
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.logger.error((Object)("Assignment string is invalid: " + behaviorString));
            }
            ++var9_10;
        }
    }

    private List<Label> getLabelFromString(String string, DataDictionary dd) {
        ArrayList<Label> labels = new ArrayList<Label>();
        Arrays.asList(string.split(DELIMITER_MULTI_PIN)).forEach(typeValuePair -> {
            if (typeValuePair == null || typeValuePair.trim().equals("")) {
                return;
            }
            String typeName = typeValuePair.split("\\.")[0];
            String valueName = typeValuePair.split("\\.")[1];
            Label value = dd.getLabelTypes().stream().filter(labelType -> labelType.getEntityName().equals(typeName)).flatMap(labelType -> labelType.getLabel().stream()).filter(label -> label.getEntityName().equals(valueName)).findAny().orElse(null);
            labels.add(value);
        });
        return labels;
    }

    private void putValue(Map<Node, Map<Pin, String>> nestedHashMap, Node node, Pin pin, String value) {
        nestedHashMap.computeIfAbsent(node, k -> new HashMap()).put(pin, value);
    }

    private List<Pin> getInPinsFromString(String pinString, Node node, DataFlowDiagram dfd) {
        ArrayList<Pin> inPins = new ArrayList<Pin>();
        List<String> pinNames = Arrays.asList(pinString.split(",\\s*"));
        List<Flow> flowsToNode = dfd.getFlows().stream().filter(flow -> flow.getDestinationNode() == node).toList();
        HashMap<Pin, List<String>> pinToFlowNames = new HashMap<Pin, List<String>>();
        for (Flow flow2 : flowsToNode) {
            this.fillPinToFlowNamesMap(pinToFlowNames, flow2);
        }
        pinNames.forEach(pinName -> {
            List<String> incomingFlowNames = Arrays.asList(pinName.split(Pattern.quote(DELIMITER_PIN_NAME)));
            pinToFlowNames.keySet().forEach(key -> {
                if (((List)pinToFlowNames.get(key)).containsAll(incomingFlowNames)) {
                    inPins.add((Pin)key);
                }
            });
        });
        return inPins;
    }

    private void fillPinToFlowNamesMap(Map<Pin, List<String>> map, Flow flow) {
        if (map.containsKey(flow.getDestinationPin())) {
            map.get(flow.getDestinationPin()).add(flow.getEntityName());
        } else {
            ArrayList<String> flowNames = new ArrayList<String>();
            flowNames.add(flow.getEntityName());
            map.put(flow.getDestinationPin(), flowNames);
        }
    }
}

