/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.converter.microsecend;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.dataflowanalysis.converter.microsecend.ExternalEntity;
import org.dataflowanalysis.converter.microsecend.InformationFlow;
import org.dataflowanalysis.converter.microsecend.MicroSecEndProcess;
import org.dataflowanalysis.converter.microsecend.Service;

public record MicroSecEnd(List<Service> services, @JsonProperty(value="external_entities") List<ExternalEntity> externalEntities, @JsonProperty(value="information_flows") List<InformationFlow> informationFlows) {
    public void sort() {
        this.services().sort(Comparator.comparing(MicroSecEndProcess::name));
        this.externalEntities().sort(Comparator.comparing(MicroSecEndProcess::name));
        this.informationFlows().sort(Comparator.comparing(InformationFlow::sender).thenComparing(InformationFlow::receiver));
        ArrayList allStereotypes = new ArrayList();
        allStereotypes.add(this.services().stream().flatMap(node -> node.stereotypes().stream()).collect(Collectors.toList()));
        allStereotypes.add(this.externalEntities().stream().flatMap(node -> node.stereotypes().stream()).collect(Collectors.toList()));
        allStereotypes.add(this.informationFlows().stream().flatMap(node -> node.stereotypes().stream()).collect(Collectors.toList()));
        allStereotypes.forEach(stereotype -> Collections.sort(stereotype));
    }
}

