/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.converter.microsecend;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dataflowanalysis.converter.microsecend.TaggedValuesDeserializer;

public abstract class MicroSecEndProcess {
    @JsonProperty(value="name")
    protected String name;
    @JsonProperty(value="stereotypes")
    protected List<String> stereotypes;
    @JsonProperty(value="tagged_values")
    @JsonDeserialize(using=TaggedValuesDeserializer.class)
    protected Map<String, List<String>> taggedValues;

    public MicroSecEndProcess() {
    }

    public MicroSecEndProcess(String name, List<String> stereotypes, Map<String, List<String>> taggedValues) {
        this.name = name;
        this.stereotypes = stereotypes.stream().map(stereotype -> stereotype.trim().replaceAll("[^a-zA-Z0-9_]", "")).collect(Collectors.toList());
        this.taggedValues = taggedValues;
    }

    public String name() {
        return this.name;
    }

    public List<String> stereotypes() {
        return this.stereotypes;
    }

    public Map<String, List<String>> taggedValues() {
        return this.taggedValues;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MicroSecEndProcess other = (MicroSecEndProcess)obj;
        return this.name.equals(other.name) && this.stereotypes.equals(other.stereotypes) && this.taggedValues.equals(other.taggedValues);
    }
}

