/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.converter.microsecend;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TaggedValuesDeserializer
extends JsonDeserializer<Map<String, List<String>>> {
    public Map<String, List<String>> deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        ObjectMapper objectMapper = new ObjectMapper();
        while (parser.nextToken() != JsonToken.END_OBJECT) {
            String fieldName = parser.getCurrentName().trim().replaceAll("[^a-zA-Z0-9_]", "");
            parser.nextToken();
            if (parser.getCurrentToken() == JsonToken.START_ARRAY) {
                List values = (List)objectMapper.readValue(parser, (TypeReference)new TypeReference<List<String>>(){});
                ArrayList<String> sanitizedValues = new ArrayList<String>();
                for (String value : values) {
                    String sanitizedValue = value.trim().replaceAll("[^a-zA-Z0-9_]", "");
                    if (sanitizedValue.equals("")) continue;
                    sanitizedValues.add(sanitizedValue);
                }
                result.put(fieldName, sanitizedValues);
                continue;
            }
            String singleValue = this.getValueAsString((JsonNode)parser.readValueAsTree());
            result.put(fieldName, List.of(singleValue));
        }
        return result;
    }

    private String getValueAsString(JsonNode node) {
        return (node.isTextual() ? node.asText() : node.toString()).trim().replaceAll("[^a-zA-Z0-9_]", "");
    }
}

