/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.converter.webdfd;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Comparator;
import java.util.List;
import org.dataflowanalysis.converter.webdfd.Child;
import org.dataflowanalysis.converter.webdfd.Constraint;
import org.dataflowanalysis.converter.webdfd.Model;
import org.dataflowanalysis.converter.webdfd.Port;
import org.dataflowanalysis.converter.webdfd.WebEditorLabel;
import org.dataflowanalysis.converter.webdfd.WebEditorLabelType;

@JsonIgnoreProperties(ignoreUnknown=true)
public record WebEditorDfd(Model model, List<WebEditorLabelType> labelTypes, String mode, List<Constraint> constraints) {
    public void sort() {
        this.labelTypes().sort(Comparator.comparing(WebEditorLabelType::id));
        List<Child> children = this.model().children();
        children.sort(Comparator.comparing(Child::id));
        for (Child child : children) {
            if (child.labels() != null) {
                child.labels().sort(Comparator.comparing(WebEditorLabel::labelTypeId).thenComparing(WebEditorLabel::labelTypeValueId));
            }
            if (child.ports() == null) continue;
            child.ports().sort(Comparator.comparing(Port::id));
        }
    }
}

