/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.workflow.jobs;

import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ModelLocation;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import de.uka.ipd.sdq.workflow.mdsd.emf.qvto.QVTOTransformationJob;
import de.uka.ipd.sdq.workflow.mdsd.emf.qvto.QVTOTransformationJobConfiguration;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryPackage;

public class EventsTransformationJob
implements IBlackboardInteractingJob<MDSDBlackboard> {
    private static final Logger LOGGER = Logger.getLogger(EventsTransformationJob.class);
    protected static final String TRANSFORMATION_SCRIPT = "platform:/plugin/org.palladiosimulator.pcm.resources/transformations/events/transformation-psm.qvto";
    private MDSDBlackboard blackboard;
    private final String storagePluginId;
    private final String eventMiddlewareFile;
    private final boolean storeTemporaryData;

    public EventsTransformationJob(String storagePluginId, String eventMiddlewareFile, boolean storeTemporaryData) {
        this.storagePluginId = storagePluginId;
        this.eventMiddlewareFile = eventMiddlewareFile;
        this.storeTemporaryData = storeTemporaryData;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        ModelLocation[] modelLocations = this.getRequiredModels(this.blackboard);
        if (this.checkEventGroups(modelLocations)) {
            LOGGER.info((Object)"Skipping Event Transformation: No EventGroup was found");
            return;
        }
        URI scriptFileURI = URI.createURI((String)TRANSFORMATION_SCRIPT);
        QVTOTransformationJobConfiguration qvtoConfig = new QVTOTransformationJobConfiguration();
        qvtoConfig.setInoutModels(modelLocations);
        qvtoConfig.setScriptFileURI(scriptFileURI);
        qvtoConfig.setOptions(new HashMap());
        QVTOTransformationJob job = new QVTOTransformationJob(qvtoConfig);
        job.setBlackboard(this.blackboard);
        job.execute(monitor);
        ResourceSetPartition partition = (ResourceSetPartition)this.blackboard.getPartition("org.palladiosimulator.pcmmodels.partition");
        partition.loadModel(this.eventMiddlewareFile);
        if (this.storeTemporaryData) {
            this.storeModelsToStorageProject(monitor);
        }
    }

    private boolean checkEventGroups(ModelLocation[] modelLocations) {
        boolean skipQVTO = true;
        ModelLocation[] modelLocationArray = modelLocations;
        int n = modelLocations.length;
        int n2 = 0;
        while (n2 < n) {
            Object eventgroup;
            ResourceSetPartition partition;
            List contents;
            Repository repo;
            ModelLocation loc = modelLocationArray[n2];
            URI modelId = loc.getModelID();
            String fileExtension = modelId.fileExtension();
            if (fileExtension != null && fileExtension.equals("repository") && (repo = (Repository)EcoreUtil.getObjectByType((Collection)(contents = (partition = (ResourceSetPartition)this.blackboard.getPartition(loc.getPartitionID())).getContents(modelId)), (EClassifier)RepositoryPackage.eINSTANCE.getRepository())) != null && (eventgroup = EcoreUtil.getObjectByType((Collection)repo.getInterfaces__Repository(), (EClassifier)RepositoryPackage.eINSTANCE.getEventGroup())) != null) {
                skipQVTO = false;
            }
            ++n2;
        }
        return skipQVTO;
    }

    private ModelLocation[] getRequiredModels(MDSDBlackboard blackboard) {
        ModelLocation allocationModelLocation = null;
        ModelLocation systemModelLocation = null;
        ModelLocation repositoryModelLocation = null;
        String pcmModelPartitionId = "org.palladiosimulator.pcmmodels.partition";
        ResourceSetPartition partition = (ResourceSetPartition)blackboard.getPartition("org.palladiosimulator.pcmmodels.partition");
        partition.resolveAllProxies();
        for (Resource r : partition.getResourceSet().getResources()) {
            URI modelURI = r.getURI();
            String fileExtension = modelURI.fileExtension();
            if (fileExtension.equals("allocation")) {
                allocationModelLocation = new ModelLocation("org.palladiosimulator.pcmmodels.partition", modelURI);
            }
            if (fileExtension.equals("system")) {
                systemModelLocation = new ModelLocation("org.palladiosimulator.pcmmodels.partition", modelURI);
            }
            if (!fileExtension.equals("repository") || repositoryModelLocation != null || modelURI.toString().startsWith("pathmap://") || modelURI.toString().contains("PrimitiveTypes.repository")) continue;
            repositoryModelLocation = new ModelLocation("org.palladiosimulator.pcmmodels.partition", modelURI);
        }
        ArrayList<ModelLocation> modelLocations = new ArrayList<ModelLocation>();
        modelLocations.add(allocationModelLocation);
        modelLocations.add(systemModelLocation);
        modelLocations.add(repositoryModelLocation);
        modelLocations.add(this.getEventMiddlewareModel(blackboard));
        return modelLocations.toArray(new ModelLocation[0]);
    }

    private ModelLocation getEventMiddlewareModel(MDSDBlackboard blackboard) {
        ResourceSetPartition pcmPartition = (ResourceSetPartition)blackboard.getPartition("org.palladiosimulator.pcmmodels.partition");
        pcmPartition.resolveAllProxies();
        if (pcmPartition.getResourceSet().getResources().size() > 0) {
            Resource r = (Resource)pcmPartition.getResourceSet().getResources().get(0);
            return new ModelLocation("org.palladiosimulator.pcmmodels.partition", r.getURI());
        }
        return new ModelLocation("org.palladiosimulator.pcmmodels.partition", URI.createURI((String)""));
    }

    public void setBlackboard(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }

    public String getName() {
        return "Add event transformation job";
    }

    public void cleanup(IProgressMonitor monitor) throws CleanupFailedException {
    }

    public static IProject getProject(String projectId) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectId);
    }

    private void storeModelsToStorageProject(IProgressMonitor monitor) {
        IProject storageProject = EventsTransformationJob.getProject(this.storagePluginId);
        try {
            if (!storageProject.exists()) {
                storageProject.create(monitor);
            }
            if (!storageProject.isOpen()) {
                storageProject.open(monitor);
            }
        }
        catch (CoreException e) {
            LOGGER.error((Object)("Error while creating project " + this.storagePluginId + " for storing models."), (Throwable)e);
        }
        EList resources = ((ResourceSetPartition)this.blackboard.getPartition("org.palladiosimulator.pcmmodels.partition")).getResourceSet().getResources();
        IFolder folderForCurrentRun = storageProject.getFolder(new SimpleDateFormat("yyyy-MM-dd'T'HHmmss.SSSZ").format(new Date()));
        if (!folderForCurrentRun.exists()) {
            try {
                folderForCurrentRun.create(true, true, monitor);
            }
            catch (CoreException e) {
                LOGGER.error((Object)"Error while creating folder for storing models.", (Throwable)e);
            }
        }
        for (Resource r : resources) {
            String lastSegment = r.getURI().lastSegment();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                r.save((OutputStream)os, Collections.emptyMap());
                ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
                IFile file = folderForCurrentRun.getFile(lastSegment);
                file.create((InputStream)is, true, monitor);
            }
            catch (IOException e) {
                LOGGER.error((Object)("Error while serializing model " + lastSegment), (Throwable)e);
            }
            catch (CoreException e) {
                LOGGER.error((Object)("Error while persisting model " + lastSegment), (Throwable)e);
            }
        }
    }
}

