/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.workflow.jobs;

import de.uka.ipd.sdq.workflow.jobs.AbstractBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.ICompositeJob;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;

public class LoadModelIntoBlackboardJob
extends AbstractBlackboardInteractingJob<MDSDBlackboard> {
    private final URI modelURI;
    private final String partitionID;

    public static void parseUriAndAddModelLoadJob(String modelUri, ICompositeJob container) {
        LoadModelIntoBlackboardJob.parseUriAndAddModelLoadJob(modelUri, "org.palladiosimulator.pcmmodels.partition", container);
    }

    public static void parseUriAndAddModelLoadJob(String modelUri, String partitionId, ICompositeJob container) {
        if (modelUri == null || modelUri.isBlank()) {
            return;
        }
        if (partitionId == null || partitionId.isBlank()) {
            return;
        }
        URI uri = URI.createURI((String)modelUri);
        container.addJob((IJob)new LoadModelIntoBlackboardJob(uri, partitionId));
    }

    public LoadModelIntoBlackboardJob(URI modelURI, String partitionID) {
        this.modelURI = Objects.requireNonNull(modelURI);
        this.partitionID = Objects.requireNonNull(partitionID);
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        ResourceSetPartition partition = Optional.ofNullable((ResourceSetPartition)((MDSDBlackboard)this.myBlackboard).getPartition(this.partitionID)).orElseThrow(() -> new IllegalStateException(String.format("The blackboard does not contain the requested partition \"%s\"", this.partitionID)));
        if (!partition.getResourceSet().getURIConverter().exists(this.modelURI, Collections.emptyMap())) {
            throw new JobFailedException(String.format("Job %s failed: The model uri \"%s\" does not point to a valid file", this.getName(), this.modelURI));
        }
        partition.loadModel(this.modelURI);
    }

    public void cleanup(IProgressMonitor monitor) throws CleanupFailedException {
    }

    public String getName() {
        return String.format("LoadModelIntoBlackboardJob<%s->%s>", this.modelURI.lastSegment(), this.partitionID);
    }
}

