/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.workflow.jobs;

import de.uka.ipd.sdq.workflow.jobs.ICompositeJob;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.SequentialBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.core.runtime.IProgressMonitor;
import org.palladiosimulator.analyzer.workflow.configurations.AbstractPCMWorkflowRunConfiguration;
import org.palladiosimulator.analyzer.workflow.jobs.LoadModelIntoBlackboardJob;
import org.palladiosimulator.analyzer.workflow.jobs.ResolveAllModelsOfPartitionJob;

public class LoadPCMModelsJob
extends SequentialBlackboardInteractingJob<MDSDBlackboard> {
    private static final Logger LOGGER = Logger.getLogger(LoadPCMModelsJob.class);

    public LoadPCMModelsJob(AbstractPCMWorkflowRunConfiguration configuration) {
        for (String modelFile : configuration.getPCMModelFiles()) {
            LoadModelIntoBlackboardJob.parseUriAndAddModelLoadJob(modelFile, (ICompositeJob)this);
        }
        LoadModelIntoBlackboardJob.parseUriAndAddModelLoadJob(configuration.getRMIMiddlewareFile(), (ICompositeJob)this);
        LoadModelIntoBlackboardJob.parseUriAndAddModelLoadJob(configuration.getEventMiddlewareFile(), (ICompositeJob)this);
        this.add((IJob)new ResolveAllModelsOfPartitionJob("org.palladiosimulator.pcmmodels.partition"));
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        if (LOGGER.isEnabledFor((Priority)Level.INFO)) {
            LOGGER.info((Object)"Loading PCM models");
        }
        super.execute(monitor);
    }

    public String getName() {
        return "Perform PCM Model Load";
    }
}

