/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.workflow.runconfig;

import java.util.ArrayList;
import java.util.List;
import org.palladiosimulator.analyzer.workflow.runconfig.ParameterDescriptor;
import org.palladiosimulator.analyzer.workflow.runconfig.SensitivityAnalysisConfiguration;

public class ExperimentRunDescriptor {
    private String name;
    private ArrayList<ParameterDescriptor> parameterList;

    public ExperimentRunDescriptor(String name, List<SensitivityAnalysisConfiguration> sconfList) {
        this.name = name;
        this.parameterList = new ArrayList();
        for (SensitivityAnalysisConfiguration sac : sconfList) {
            ParameterDescriptor pd = new ParameterDescriptor(sac.getShortName(), sac.getVariable(), sac.getCurrent(), sac.getRunNo());
            this.parameterList.add(pd);
        }
    }

    public String getRunIdentifier() {
        String result = null;
        for (ParameterDescriptor pd : this.parameterList) {
            result = result == null ? "" : String.valueOf(result) + ".";
            result = String.valueOf(result) + pd.getRunNo();
        }
        return result;
    }

    public String getNameExperimentRun() {
        return String.valueOf(this.name) + " No. " + this.getRunIdentifier();
    }

    public List<ParameterDescriptor> getParameters() {
        return this.parameterList;
    }
}

