/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.workflow.runconfig;

import de.uka.ipd.sdq.workflow.launchconfig.ImageRegistryHelper;
import de.uka.ipd.sdq.workflow.launchconfig.LaunchConfigPlugin;
import de.uka.ipd.sdq.workflow.launchconfig.tabs.TabHelper;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.palladiosimulator.analyzer.workflow.ConstantsContainer;

public class ProtocomFileNamesInputTab
extends AbstractLaunchConfigurationTab {
    public static final String PLUGIN_ID = "org.palladiosimulator.analyzer.workflow";
    private static final String FILENAME_TAB_IMAGE_PATH = "icons/filenames_tab.gif";
    protected Text textAllocation;
    protected Text textUsage;
    protected Composite container;
    protected ModifyListener modifyListener;

    public Image getImage() {
        return ImageRegistryHelper.getTabImage((String)PLUGIN_ID, (String)FILENAME_TAB_IMAGE_PATH);
    }

    public void createControl(Composite parent) {
        this.modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProtocomFileNamesInputTab.this.setDirty(true);
                ProtocomFileNamesInputTab.this.updateLaunchConfigurationDialog();
            }
        };
        this.container = new Composite(parent, 0);
        this.setControl((Control)this.container);
        this.container.setLayout((Layout)new GridLayout());
        this.textAllocation = new Text(this.container, 2052);
        TabHelper.createFileInputSection((Composite)this.container, (ModifyListener)this.modifyListener, (String)"Allocation File", (String[])ConstantsContainer.ALLOCATION_EXTENSION, (Text)this.textAllocation, (String)"Select Allocation File", (Shell)this.getShell(), (String)"");
        this.textUsage = new Text(this.container, 2052);
        TabHelper.createFileInputSection((Composite)this.container, (ModifyListener)this.modifyListener, (String)"Usage File", (String[])ConstantsContainer.USAGEMODEL_EXTENSION, (Text)this.textUsage, (String)"Select Usage File", (Shell)this.getShell(), (String)"");
    }

    public String getName() {
        return "Architecture Model(s)";
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.textAllocation.setText(configuration.getAttribute("allocationFile", ""));
        }
        catch (CoreException e) {
            LaunchConfigPlugin.errorLogger((String)this.getName(), (String)"Allocation File", (String)e.getMessage());
        }
        try {
            this.textUsage.setText(configuration.getAttribute("usageFile", ""));
        }
        catch (CoreException e) {
            LaunchConfigPlugin.errorLogger((String)this.getName(), (String)"Usage File", (String)e.getMessage());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("allocationFile", this.textAllocation.getText());
        configuration.setAttribute("usageFile", this.textUsage.getText());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        if (!TabHelper.validateFilenameExtension((String)this.textAllocation.getText(), (String[])ConstantsContainer.ALLOCATION_EXTENSION)) {
            this.setErrorMessage("Allocation is missing.");
            return false;
        }
        if (!TabHelper.validateFilenameExtension((String)this.textUsage.getText(), (String[])ConstantsContainer.USAGEMODEL_EXTENSION)) {
            this.setErrorMessage("Usage is missing.");
            return false;
        }
        return true;
    }

    public boolean canSave() {
        return true;
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public String getId() {
        return "de.uka.ipd.sdq.codegen.runconfig.tabs.ProtocomFileNamesInputTab";
    }
}

