/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.pcm.extension.ui.wizard;

import com.google.inject.Injector;
import java.util.Optional;
import java.util.function.Consumer;
import org.dataflowanalysis.pcm.extension.ui.wizard.ValidatingWizardNewFileCreationPage;
import org.dataflowanalysis.pcm.extension.ui.wizard.WizardUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.xtext.resource.FileExtensionProvider;

public abstract class AbstractXtextFileCreationWizard
extends Wizard
implements INewWizard {
    protected final Injector injector;
    protected final String fileTypeName;
    protected final String fileExtension;
    protected WizardNewFileCreationPage fileCreationPage;
    protected IWorkbench workbench;

    public AbstractXtextFileCreationWizard(Injector injector, String fileTypeName) {
        this.injector = injector;
        this.fileTypeName = fileTypeName;
        this.fileExtension = ((FileExtensionProvider)injector.getInstance(FileExtensionProvider.class)).getPrimaryFileExtension();
    }

    public void addPages() {
        this.addPage((IWizardPage)this.fileCreationPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.setWindowTitle(String.valueOf(this.fileTypeName) + " Creation");
        this.fileCreationPage = new ValidatingWizardNewFileCreationPage(String.valueOf(this.fileTypeName) + " Creation", selection, this::validateFilename);
        this.fileCreationPage.setAllowExistingResources(false);
        this.fileCreationPage.setTitle(String.valueOf(this.fileTypeName) + " Creation");
        this.fileCreationPage.setDescription("Please select the path for creating the " + this.fileTypeName + ".");
    }

    protected boolean validateFilename(String filename, Consumer<String> errorMessageConsumer) {
        Boolean validationResult = Optional.ofNullable(filename).map(fn -> fn.endsWith("." + this.fileExtension)).orElse(false);
        if (!validationResult.booleanValue()) {
            errorMessageConsumer.accept("The file name has to end with ." + this.fileExtension);
        }
        return validationResult;
    }

    protected Optional<DialogPage> getCurrentPage() {
        return Optional.ofNullable(this.getContainer().getCurrentPage()).filter(DialogPage.class::isInstance).map(DialogPage.class::cast);
    }

    public boolean performFinish() {
        IFile file = this.getFileToCreate();
        try {
            WizardUtils.addXtextNature(file.getProject(), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            this.fileCreationPage.setErrorMessage("Could not add required Xtext nature: " + e.getLocalizedMessage());
            return false;
        }
        try {
            this.createXtextFile(file, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            this.fileCreationPage.setErrorMessage("Could not create file: " + e.getLocalizedMessage());
            return false;
        }
        try {
            WizardUtils.openEditor(this.workbench, file);
        }
        catch (PartInitException e) {
            this.fileCreationPage.setErrorMessage("Could not open file: " + e.getLocalizedMessage());
            return false;
        }
        return true;
    }

    protected abstract void createXtextFile(IFile var1, IProgressMonitor var2) throws CoreException;

    protected IFile getFileToCreate() {
        IPath containerPath = this.fileCreationPage.getContainerFullPath();
        IPath fileToCreate = containerPath.append(this.fileCreationPage.getFileName());
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(fileToCreate);
        return file;
    }
}

