/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.servicelevelobjective.edp2.visualization.jfreechart.input.servicelevelobjective;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.measure.Measure;
import javax.measure.unit.Unit;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.general.AbstractDataset;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.XYDataset;
import org.palladiosimulator.edp2.datastream.IDataSource;
import org.palladiosimulator.edp2.datastream.IDataStream;
import org.palladiosimulator.edp2.datastream.configurable.PropertyConfigurable;
import org.palladiosimulator.edp2.util.MetricDescriptionUtility;
import org.palladiosimulator.edp2.visualization.jfreechart.input.AbstractXYVisualizationInput;
import org.palladiosimulator.edp2.visualization.jfreechart.input.JFreeChartVisualizationSingleDatastreamInput;
import org.palladiosimulator.measurementframework.TupleMeasurement;
import org.palladiosimulator.metricspec.BaseMetricDescription;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.MetricSetDescription;
import org.palladiosimulator.metricspec.NumericalBaseMetricDescription;
import org.palladiosimulator.servicelevelobjective.LinearFuzzyThreshold;
import org.palladiosimulator.servicelevelobjective.ServiceLevelObjective;
import org.palladiosimulator.servicelevelobjective.edp2.SLOEDP2UIPlugin;
import org.palladiosimulator.servicelevelobjective.edp2.visualization.jfreechart.input.servicelevelobjective.SLOQualitativePlotInputConfiguration;
import org.palladiosimulator.servicelevelobjective.edp2.visualization.jfreechart.input.servicelevelobjective.SLOQualitativePlotInputFactory;
import org.palladiosimulator.servicelevelobjective.edp2.visualization.wizards.SLOViewsWizard;

public class SLOQualitativePlotInput
extends AbstractXYVisualizationInput {
    private double[][] aggregatedData;
    private ServiceLevelObjective slo;
    private String measuringPointLabel;
    private double timestep = 10.0;

    public String getFactoryId() {
        return SLOQualitativePlotInputFactory.FACTORY_ID;
    }

    public boolean canAccept(IDataSource source) {
        BaseMetricDescription[] mds = MetricDescriptionUtility.toBaseMetricDescriptions((MetricDescription)source.getMetricDesciption());
        if (mds.length != 2) {
            return false;
        }
        BaseMetricDescription[] baseMetricDescriptionArray = mds;
        int n = mds.length;
        int n2 = 0;
        while (n2 < n) {
            BaseMetricDescription md = baseMetricDescriptionArray[n2];
            if (!(md instanceof NumericalBaseMetricDescription)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected PropertyConfigurable createConfiguration() {
        return new SLOQualitativePlotInputConfiguration();
    }

    protected AbstractDataset generateDataset() {
        DefaultXYDataset dataset = new DefaultXYDataset();
        int i = 1;
        for (JFreeChartVisualizationSingleDatastreamInput childInput : this.getInputs()) {
            dataset.addSeries((Comparable)((Object)(String.valueOf(i) + ": " + childInput.getInputName())), this.getXYData(childInput.getDataSource()));
            ++i;
        }
        return dataset;
    }

    private double computeFulfillmentRatio(List<Double> input) {
        Double lowerThreshold;
        Double upperThreshold;
        Double softUpperThreshold = null;
        Double softLowerThreshold = null;
        Unit unit = this.slo.getUpperThreshold().getThresholdLimit().getUnit();
        if (this.slo.getUpperThreshold() instanceof LinearFuzzyThreshold) {
            upperThreshold = this.slo.getUpperThreshold().getThresholdLimit().doubleValue(unit);
            softUpperThreshold = ((LinearFuzzyThreshold)this.slo.getUpperThreshold()).getSoftLimit().doubleValue(unit);
        } else {
            upperThreshold = this.slo.getUpperThreshold().getThresholdLimit().doubleValue(unit);
        }
        if (this.slo.getLowerThreshold() instanceof LinearFuzzyThreshold) {
            lowerThreshold = this.slo.getLowerThreshold().getThresholdLimit().doubleValue(unit);
            softLowerThreshold = ((LinearFuzzyThreshold)this.slo.getLowerThreshold()).getSoftLimit().doubleValue(unit);
        } else {
            lowerThreshold = this.slo.getLowerThreshold().getThresholdLimit().doubleValue(unit);
        }
        double result = this.slo.getUpperThreshold() instanceof LinearFuzzyThreshold && this.slo.getLowerThreshold() instanceof LinearFuzzyThreshold ? this.computeData(upperThreshold, softUpperThreshold, lowerThreshold, softLowerThreshold, input) : (this.slo.getUpperThreshold() instanceof LinearFuzzyThreshold ? this.computeData(upperThreshold, softUpperThreshold, lowerThreshold, null, input) : (this.slo.getLowerThreshold() instanceof LinearFuzzyThreshold ? this.computeData(upperThreshold, null, lowerThreshold, softLowerThreshold, input) : this.computeData(upperThreshold, null, lowerThreshold, null, input)));
        return result;
    }

    private double computeData(Double upper, Double softupper, Double lower, Double softLower, List<Double> input) {
        DescriptiveStatistics stats = new DescriptiveStatistics();
        ArrayList<Double> intermediateResults = new ArrayList<Double>();
        for (Double currentInput : input) {
            Double intermediateRatio = 1.0;
            if (currentInput >= upper || currentInput <= lower) {
                intermediateRatio = 0.0;
            } else if (softupper == null && softLower == null) {
                intermediateRatio = 1.0;
            } else if (softupper != null && currentInput > softupper) {
                intermediateRatio = 1.0 - (currentInput - softupper) / (upper - softupper);
            } else if (softLower != null && currentInput < softLower) {
                intermediateRatio = 1.0 - (softLower - currentInput) / (softLower - lower);
            }
            intermediateResults.add(intermediateRatio);
        }
        for (Double currentDouble : intermediateResults) {
            stats.addValue(currentDouble.doubleValue());
        }
        double result = stats.getMean();
        stats.clear();
        return result;
    }

    protected Plot generatePlot(PropertyConfigurable config, AbstractDataset dataset) {
        double[][] data;
        SLOViewsWizard wizard = new SLOViewsWizard(this.getInputs());
        WizardDialog wdialog = new WizardDialog(SLOEDP2UIPlugin.INSTANCE.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        wdialog.open();
        this.slo = wizard.getSelectedSLO();
        if (this.slo == null) {
            return null;
        }
        ArrayList<Double> inputList = new ArrayList<Double>();
        if (this.aggregatedData == null) {
            JFreeChartVisualizationSingleDatastreamInput childInput = (JFreeChartVisualizationSingleDatastreamInput)this.getInputs().get(0);
            data = this.getXYData(childInput.getDataSource());
            this.measuringPointLabel = ((JFreeChartVisualizationSingleDatastreamInput)this.getInputs().get(0)).getInputName();
        } else {
            data = this.aggregatedData;
        }
        int maxSimulationTime = (int)data[0][data[0].length - 1];
        double[][] outputData = new double[2][(int)Math.ceil((double)maxSimulationTime / this.timestep)];
        double time = this.timestep;
        int numberOfSteps = 0;
        int index = 0;
        while (time <= (double)maxSimulationTime) {
            int i = 0;
            while (index + i < data[0].length && data[0][index + i] <= time) {
                if (data[0][index + i] > time - this.timestep) {
                    inputList.add(data[1][index + i]);
                }
                ++i;
            }
            index += i;
            outputData[0][numberOfSteps] = time;
            outputData[1][numberOfSteps] = this.computeFulfillmentRatio(inputList);
            inputList.clear();
            ++numberOfSteps;
            if (time + this.timestep > (double)maxSimulationTime && time != (double)maxSimulationTime) {
                time = maxSimulationTime;
                continue;
            }
            time += this.timestep;
        }
        int counter = 0;
        int x = 0;
        while (x < outputData[0].length) {
            if (Double.isNaN(outputData[1][x])) {
                ++counter;
            }
            ++x;
        }
        if (counter > 0) {
            counter = outputData[0].length - counter;
            double[][] resultData = new double[2][counter];
            int x2 = 0;
            int j = 0;
            while (j < outputData[0].length) {
                if (!Double.isNaN(outputData[1][j])) {
                    resultData[0][x2] = outputData[0][j];
                    resultData[1][x2] = outputData[1][j];
                    ++x2;
                }
                ++j;
            }
            outputData = resultData;
        }
        SLOQualitativePlotInputConfiguration configuration = (SLOQualitativePlotInputConfiguration)config;
        XYPlot plot = new XYPlot();
        NumberAxis domainAxis = new NumberAxis(configuration.isShowDomainAxisLabel() ? configuration.getDomainAxisLabel() : null);
        NumberAxis rangeAxis = new NumberAxis("Service Level Objective Fulfillment Ratio");
        plot.setRangeAxis((ValueAxis)rangeAxis);
        plot.setDomainAxis((ValueAxis)domainAxis);
        DefaultXYDataset xyDataset = new DefaultXYDataset();
        Unit unit = this.slo.getUpperThreshold().getThresholdLimit().getUnit();
        StringBuffer label = new StringBuffer();
        label.append("UT= " + this.slo.getUpperThreshold().getThresholdLimit().doubleValue(unit) + "; ");
        if (this.slo.getUpperThreshold() instanceof LinearFuzzyThreshold) {
            label.append("SUT= " + ((LinearFuzzyThreshold)this.slo.getUpperThreshold()).getSoftLimit().doubleValue(unit) + "; ");
        }
        label.append("LT= " + this.slo.getLowerThreshold().getThresholdLimit().doubleValue(unit) + ";");
        if (this.slo.getLowerThreshold() instanceof LinearFuzzyThreshold) {
            label.append(" SLT= " + ((LinearFuzzyThreshold)this.slo.getLowerThreshold()).getSoftLimit().doubleValue(unit) + ";");
        }
        xyDataset.addSeries((Comparable)((Object)("Service Level Objective \"" + this.slo.getName() + "\". " + label + ". Measuring point(s): " + this.measuringPointLabel)), outputData);
        plot.setDataset((XYDataset)xyDataset);
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        renderer.setSeriesLinesVisible(0, configuration.isShowSeriesLine());
        renderer.setSeriesShapesVisible(0, configuration.isShowSeriesShapes());
        renderer.setSeriesPaint(0, (Paint)Color.BLACK);
        renderer.setSeriesStroke(0, (Stroke)new BasicStroke(4.0f));
        plot.setRenderer((XYItemRenderer)renderer);
        this.configureSeriesColors((AbstractRenderer)renderer);
        return plot;
    }

    private double[][] getXYData(IDataSource dataSource) {
        if (!this.canAccept(dataSource)) {
            throw new IllegalArgumentException("XYData has to be a two-dimensional metric set description.");
        }
        IDataStream inputStream = dataSource.getDataStream();
        EList subsumedMetrics = ((MetricSetDescription)inputStream.getMetricDesciption()).getSubsumedMetrics();
        Unit domainUnit = ((NumericalBaseMetricDescription)subsumedMetrics.get(this.getXPos())).getDefaultUnit();
        Unit rangeUnit = ((NumericalBaseMetricDescription)subsumedMetrics.get(this.getYPos())).getDefaultUnit();
        try {
            double[][] result = new double[2][inputStream.size()];
            int i = 0;
            for (TupleMeasurement tuple : inputStream) {
                Measure[] measurement = tuple.asArray();
                result[0][i] = measurement[this.getXPos()].doubleValue(domainUnit);
                result[1][i] = measurement[this.getYPos()].doubleValue(rangeUnit);
                ++i;
            }
            double[][] dArray = result;
            return dArray;
        }
        finally {
            inputStream.close();
        }
    }

    protected Set<String> getPropertyKeysTriggeringUpdate() {
        return Collections.emptySet();
    }

    public void setAggregatedData(double[][] aggregatedData) {
        this.aggregatedData = aggregatedData;
    }

    public void setSlo(ServiceLevelObjective slo) {
        this.slo = slo;
    }

    public void setTimestep(double timestep) {
        this.timestep = timestep;
    }

    public void setMeasuringPointLabel(String measuringPointLabel) {
        this.measuringPointLabel = measuringPointLabel;
    }
}

