/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.servicelevelobjective.edp2.visualization.wizards;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.palladiosimulator.edp2.models.ExperimentData.Measurement;
import org.palladiosimulator.edp2.models.measuringpoint.impl.StringMeasuringPointImpl;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.servicelevelobjective.edp2.visualization.wizards.SLOViewsWizard;

public class SLODialogChooseMeasuringPointsPage
extends WizardPage
implements ISelectionChangedListener {
    private final List<Measurement> measurementsList;
    private TableViewer choiceViewer;
    private List<Measurement> selectedMeasurements;
    private IStatus selectionStatus;
    private final Status statusOK;

    protected SLODialogChooseMeasuringPointsPage(String pageName, List<Measurement> measurementsList) {
        super(pageName);
        this.setPageComplete(false);
        this.measurementsList = measurementsList;
        this.setDescription("Please select at least one measuring point to proceed");
        this.setErrorMessage("Selected measuring points must have same metric type.");
        this.selectionStatus = new Status(1, "not_used", 0, "Please select at least one measuring point to proceed.", null);
        this.statusOK = new Status(0, "not_used", 0, "", null);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        composite.setLayout((Layout)gl);
        Label label = new Label(composite, 0);
        label.setText("Available Choices:");
        SashForm sashForm = new SashForm(composite, 256);
        GridData gd = new GridData(1808);
        gd.widthHint = 200;
        sashForm.setLayoutData((Object)gd);
        this.choiceViewer = new TableViewer((Composite)sashForm, 2050);
        this.initializeChoiceViewer();
        this.setControl((Control)composite);
        this.updatePageStatus();
    }

    private void initializeChoiceViewer() {
        this.choiceViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return SLODialogChooseMeasuringPointsPage.this.measurementsList.toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.choiceViewer.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                if (element != null) {
                    Measurement sequenceElement = (Measurement)element;
                    StringMeasuringPointImpl measuringPoint = (StringMeasuringPointImpl)sequenceElement.getMeasuringType().getMeasuringPoint();
                    StringBuffer result = new StringBuffer();
                    result.append("Measuring Point: " + measuringPoint.getMeasuringPoint() + " (" + sequenceElement.getMeasuringType().getMetric().getName() + ")");
                    return result.toString();
                }
                return null;
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.choiceViewer.setInput(this.measurementsList);
        this.choiceViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selectionStatus = this.statusOK;
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection.isEmpty()) {
            this.selectionStatus = new Status(4, "not_used", 0, "Please select a Visualization to proceed.", null);
        } else {
            List list;
            this.selectedMeasurements = list = selection.toList();
            if (this.checkForSameMetricTypes()) {
                this.setSelectedMeasurementsInWizard(list);
            } else {
                this.setPageComplete(false);
                this.selectionStatus = new Status(4, "not_used", 0, "Selected measuring points must have same metric type.", null);
            }
        }
        this.updatePageStatus();
    }

    private boolean checkForSameMetricTypes() {
        MetricDescription metricType = this.selectedMeasurements.get(0).getMeasuringType().getMetric();
        for (Measurement measurement : this.selectedMeasurements) {
            if (metricType.equals(measurement.getMeasuringType().getMetric())) continue;
            return false;
        }
        return true;
    }

    public IStatus updatePageStatus() {
        Status pageStatus = this.statusOK;
        ((SLOViewsWizard)this.getWizard()).setFinishable(false);
        switch (this.selectionStatus.getSeverity()) {
            case 0: {
                this.setErrorMessage(null);
                this.setMessage(this.selectionStatus.getMessage());
                pageStatus = this.statusOK;
                this.setPageComplete(true);
                break;
            }
            case 2: {
                this.setErrorMessage(null);
                this.setMessage(this.selectionStatus.getMessage(), 2);
                pageStatus = this.selectionStatus;
                break;
            }
            case 1: {
                this.setErrorMessage(null);
                this.setMessage(this.selectionStatus.getMessage(), 1);
                pageStatus = this.selectionStatus;
                break;
            }
            default: {
                this.setErrorMessage(this.selectionStatus.getMessage());
                this.setMessage(null);
                pageStatus = this.selectionStatus;
            }
        }
        return pageStatus;
    }

    private void setSelectedMeasurementsInWizard(List<Measurement> selectedMeasurements) {
        ((SLOViewsWizard)this.getWizard()).setSelectedMeasurements(selectedMeasurements);
    }
}

