/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.modelingfoundations.identifier.util;

import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import tools.mdsd.modelingfoundations.identifier.Entity;
import tools.mdsd.modelingfoundations.identifier.Identifier;
import tools.mdsd.modelingfoundations.identifier.IdentifierPackage;
import tools.mdsd.modelingfoundations.identifier.NamedElement;

public class IdentifierValidator
extends EObjectValidator {
    public static final IdentifierValidator INSTANCE = new IdentifierValidator();
    public static final String DIAGNOSTIC_SOURCE = "tools.mdsd.modelingfoundations.identifier";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;

    protected EPackage getEPackage() {
        return IdentifierPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateIdentifier((Identifier)value, diagnostics, context);
            }
            case 1: {
                return this.validateNamedElement((NamedElement)value, diagnostics, context);
            }
            case 2: {
                return this.validateEntity((Entity)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateIdentifier(Identifier identifier, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(identifier, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(identifier, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(identifier, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(identifier, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(identifier, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(identifier, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(identifier, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(identifier, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(identifier, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIdentifier_identifierIsUnique(identifier, diagnostics, context);
        }
        return result;
    }

    public boolean validateIdentifier_identifierIsUnique(Identifier identifier, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateNamedElement(NamedElement namedElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(namedElement, diagnostics, context);
    }

    public boolean validateEntity(Entity entity, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(entity, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(entity, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(entity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(entity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(entity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(entity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(entity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(entity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(entity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIdentifier_identifierIsUnique(entity, diagnostics, context);
        }
        return result;
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

