/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.architecturaltemplates.jobs.config;

import de.uka.ipd.sdq.workflow.launchconfig.ImageRegistryHelper;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ATExtensionTab
extends AbstractLaunchConfigurationTab {
    public static final String PLUGIN_ID = "org.palladiosimulator.architecturaltemplates.jobs";
    public static final String STORE_COMPLETED_MODELS = "org.palladiosimulator.architecturaltemplates.jobs.config.storeCompletedModels";
    public static final Boolean DEFAULT_STORE_COMPLETED_MODELS = true;
    public static final String MODEL_STORAGE_LOCATION = "org.palladiosimulator.architecturaltemplates.jobs.config.modelStorageLocation";
    public static final String DEFAULT_MODEL_STORAGE_LOCATION = "org.palladiosimulator.architecturaltemplates.temporary";
    public static final String CONFIGURATION_TAB_IMAGE_PATH = "icons/ATLogo15x15.png";
    private Button storeCompletedModelsButton;
    private Text storeLocationField;
    private Label storeLocationLabel;

    public final void createControl(Composite parent) {
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ATExtensionTab.this.updateATTab();
            }

            public void widgetSelected(SelectionEvent e) {
                ATExtensionTab.this.setStorageLocationElementsEnabled(ATExtensionTab.this.storeCompletedModelsButton.getSelection());
                if (ATExtensionTab.this.storeCompletedModelsButton.getSelection()) {
                    ATExtensionTab.this.storeLocationField.setText(ATExtensionTab.DEFAULT_MODEL_STORAGE_LOCATION);
                }
                ATExtensionTab.this.updateATTab();
            }
        };
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout());
        GridData gdModelStorageGroup = new GridData(4, 0x1000000, true, false);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        Group modelStorageGroup = new Group(container, 0);
        modelStorageGroup.setText("Model Storage");
        modelStorageGroup.setLayoutData((Object)gdModelStorageGroup);
        modelStorageGroup.setLayout((Layout)gridLayout);
        this.storeCompletedModelsButton = this.initCheckButton(selectionListener, modelStorageGroup, "Store completed models");
        this.storeLocationLabel = new Label((Composite)modelStorageGroup, 0);
        this.storeLocationLabel.setLayoutData((Object)new GridData(48, -1));
        this.storeLocationLabel.setText("Location:");
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.widthHint = 20;
        this.storeLocationField = new Text((Composite)modelStorageGroup, 2048);
        this.storeLocationField.setLayoutData((Object)gridData);
        this.storeLocationField.setText(DEFAULT_MODEL_STORAGE_LOCATION);
        this.storeLocationField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ATExtensionTab.this.updateATTab();
            }
        });
    }

    private void updateATTab() {
        this.setDirty(true);
        this.updateLaunchConfigurationDialog();
    }

    private void setStorageLocationElementsEnabled(boolean enable) {
        this.storeLocationField.setEnabled(enable);
        this.storeLocationLabel.setEnabled(enable);
    }

    private Button initCheckButton(SelectionListener selectionListener, Group modelStorageGroup, String buttonText) {
        GridData gdStoreCompletedModelsButton = new GridData(4, 0x1000000, true, false, 4, 1);
        Button button = new Button((Composite)modelStorageGroup, 32);
        button.setLayoutData((Object)gdStoreCompletedModelsButton);
        button.setText(buttonText);
        button.addSelectionListener(selectionListener);
        return button;
    }

    public final String getName() {
        return "Architectural Templates";
    }

    public final void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.storeCompletedModelsButton.setSelection(configuration.getAttribute(STORE_COMPLETED_MODELS, DEFAULT_STORE_COMPLETED_MODELS.booleanValue()));
            this.storeLocationField.setText(configuration.getAttribute(MODEL_STORAGE_LOCATION, DEFAULT_MODEL_STORAGE_LOCATION));
            if (this.storeCompletedModelsButton.getSelection()) {
                this.setStorageLocationElementsEnabled(true);
            } else {
                this.setStorageLocationElementsEnabled(false);
            }
        }
        catch (CoreException e) {
            this.storeCompletedModelsButton.setSelection(DEFAULT_STORE_COMPLETED_MODELS.booleanValue());
            this.storeLocationField.setText(DEFAULT_MODEL_STORAGE_LOCATION);
        }
    }

    public final void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(STORE_COMPLETED_MODELS, this.storeCompletedModelsButton.getSelection());
        configuration.setAttribute(MODEL_STORAGE_LOCATION, this.storeLocationField.getText());
    }

    public final void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(STORE_COMPLETED_MODELS, (Object)DEFAULT_STORE_COMPLETED_MODELS);
        configuration.setAttribute(MODEL_STORAGE_LOCATION, DEFAULT_MODEL_STORAGE_LOCATION);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        if (this.storeLocationField.getText().equals("")) {
            this.setErrorMessage("The location for model storage is missing.");
            return false;
        }
        return true;
    }

    public Image getImage() {
        return ImageRegistryHelper.getTabImage((String)PLUGIN_ID, (String)CONFIGURATION_TAB_IMAGE_PATH);
    }
}

