/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.workflow.workbench;

import de.uka.ipd.sdq.workflow.Workflow;
import de.uka.ipd.sdq.workflow.WorkflowExceptionHandler;
import de.uka.ipd.sdq.workflow.configuration.AbstractJobConfiguration;
import de.uka.ipd.sdq.workflow.configuration.InvalidWorkflowJobConfigurationException;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.logging.console.LoggerAppenderStruct;
import de.uka.ipd.sdq.workflow.logging.console.StreamsProxyAppender;
import de.uka.ipd.sdq.workflow.ui.UIBasedWorkflowExceptionHandler;
import de.uka.ipd.sdq.workflow.ui.WorkflowProcess;
import de.uka.ipd.sdq.workflow.workbench.MessageConsoleStreamListener;
import de.uka.ipd.sdq.workflow.workbench.WorkflowStatusListener;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.MessageConsole;

public abstract class AbstractWorkbenchDelegate<WorkflowConfigurationType extends AbstractJobConfiguration, WorkflowType extends Workflow>
implements IActionDelegate {
    protected static final String SHORT_LOG_PATTERN = "[%-10t] %-5p: %m%n";
    protected static final String DETAILED_LOG_PATTERN = "%-8r [%-10t] %-5p: %m [%c]%n";
    private static final Logger LOGGER = Logger.getLogger(AbstractWorkbenchDelegate.class);
    public static final String VERBOSE_LOGGING = "verboseLogging";
    private IWorkbenchWindow window;
    private WorkflowProcess myProcess = null;
    protected final List<WorkflowStatusListener> workflowListener = new ArrayList<WorkflowStatusListener>();
    private IProgressMonitor progressMonitor = new NullProgressMonitor();

    public void run(IAction action) {
        block6: {
            ClassLoader oldClassLoader = this.configureNewClassloader();
            List<LoggerAppenderStruct> loggerList = this.setupProcessAndLogger();
            try {
                this.createAndRunWorkflow();
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
            try {
                this.tearDownProcessAndLogger(loggerList);
            }
            catch (DebugException e) {
                if (!LOGGER.isDebugEnabled()) break block6;
                LOGGER.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    private void tearDownProcessAndLogger(List<LoggerAppenderStruct> loggerList) throws DebugException {
        for (LoggerAppenderStruct l : loggerList) {
            l.getLogger().removeAppender((Appender)l.getAppender());
        }
        if (this.myProcess != null) {
            this.myProcess.terminate();
        }
        this.myProcess = null;
    }

    private List<LoggerAppenderStruct> setupProcessAndLogger() {
        this.myProcess = this.getProcess();
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        MessageConsole myConsole = null;
        if (!this.useSeparateConsoleForEachJobRun()) {
            IConsole[] existing = conMan.getConsoles();
            int i = 0;
            while (i < existing.length) {
                if (this.getClass().getSimpleName().equals(existing[i].getName())) {
                    myConsole = (MessageConsole)existing[i];
                }
                ++i;
            }
        }
        if (myConsole == null) {
            myConsole = new MessageConsole(this.getClass().getSimpleName(), null);
        }
        conMan.addConsoles(new IConsole[]{myConsole});
        MessageConsoleStreamListener streamListener = new MessageConsoleStreamListener(myConsole);
        this.myProcess.getStreamsProxy().getOutputStreamMonitor().addListener((IStreamListener)streamListener);
        this.myProcess.getStreamsProxy().getErrorStreamMonitor().addListener((IStreamListener)streamListener);
        final MessageConsole consoleForUpdate = myConsole;
        String id = "org.eclipse.ui.console.ConsoleView";
        if (this.window == null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    AbstractWorkbenchDelegate.this.window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    try {
                        IWorkbenchPage page = AbstractWorkbenchDelegate.this.window.getActivePage();
                        IConsoleView view = (IConsoleView)page.showView("org.eclipse.ui.console.ConsoleView");
                        view.display((IConsole)consoleForUpdate);
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        ArrayList<LoggerAppenderStruct> loggerList = this.setupLogging(this.getLogLevel());
        for (LoggerAppenderStruct currentLogger : loggerList) {
            this.myProcess.addAppender(currentLogger.getAppender());
        }
        return loggerList;
    }

    protected Level getLogLevel() {
        int logLevel = Level.DEBUG.toInt();
        switch (logLevel) {
            case 0: {
                return Level.TRACE;
            }
            case 1: {
                return Level.DEBUG;
            }
            case 2: {
                return Level.INFO;
            }
            case 3: {
                return Level.WARN;
            }
            case 4: {
                return Level.ERROR;
            }
            case 5: {
                return Level.ALL;
            }
        }
        return Level.INFO;
    }

    private void createAndRunWorkflow() {
        WorkflowConfigurationType workflowConfiguration;
        if (LOGGER.isEnabledFor((Priority)Level.INFO)) {
            LOGGER.info((Object)"Create workflow configuration");
        }
        if ((workflowConfiguration = this.getConfiguration()) == null) {
            if (LOGGER.isEnabledFor((Priority)Level.ERROR)) {
                LOGGER.error((Object)("No configuration instance has been created by the workflow [" + this.getClass().toString() + "]"), (Throwable)new NullPointerException());
            }
            return;
        }
        if (LOGGER.isEnabledFor((Priority)Level.INFO)) {
            LOGGER.info((Object)"Validating workflow configuration");
        }
        try {
            workflowConfiguration.validateAndFreeze();
            for (WorkflowStatusListener listener : this.workflowListener) {
                listener.notifyConfigurationValid();
            }
        }
        catch (InvalidWorkflowJobConfigurationException e) {
            if (LOGGER.isEnabledFor((Priority)Level.INFO)) {
                LOGGER.error((Object)"Configuration invalid");
                LOGGER.error((Object)e.getMessage());
            }
            return;
        }
        if (LOGGER.isEnabledFor((Priority)Level.INFO)) {
            LOGGER.info((Object)"Creating workflow engine");
        }
        WorkflowType workflow = this.createWorkflow(workflowConfiguration);
        for (WorkflowStatusListener listener : this.workflowListener) {
            listener.notifyCreated();
        }
        if (LOGGER.isEnabledFor((Priority)Level.INFO)) {
            LOGGER.info((Object)"Executing workflow");
        }
        workflow.run();
        for (WorkflowStatusListener listener : this.workflowListener) {
            listener.notifyFinished();
        }
    }

    protected WorkflowExceptionHandler createExceptionHandler(boolean interactive) {
        return new UIBasedWorkflowExceptionHandler(!interactive);
    }

    protected WorkflowType createWorkflow(WorkflowConfigurationType workflowConfiguration) {
        return (WorkflowType)new Workflow(this.createWorkflowJob(workflowConfiguration), this.progressMonitor, this.createExceptionHandler(true));
    }

    private ClassLoader configureNewClassloader() {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        URLClassLoader cl = new URLClassLoader(new URL[0], oldClassLoader);
        Thread.currentThread().setContextClassLoader(cl);
        return oldClassLoader;
    }

    protected ArrayList<LoggerAppenderStruct> setupLogging(Level logLevel) {
        ArrayList<LoggerAppenderStruct> loggerList = new ArrayList<LoggerAppenderStruct>();
        loggerList.add(this.setupLogger("de.uka.ipd.sdq.workflow", logLevel, Level.DEBUG == logLevel ? DETAILED_LOG_PATTERN : SHORT_LOG_PATTERN));
        return loggerList;
    }

    protected LoggerAppenderStruct setupLogger(String loggerName, Level logLevel, String layout) {
        Logger loggerInstance = Logger.getLogger((String)loggerName);
        StreamsProxyAppender appender = new StreamsProxyAppender();
        loggerInstance.setLevel(logLevel);
        appender.setLayout((Layout)new PatternLayout(layout));
        loggerInstance.setAdditivity(false);
        loggerInstance.addAppender((Appender)appender);
        return new LoggerAppenderStruct(loggerInstance, appender);
    }

    protected WorkflowProcess getProcess() {
        return new WorkflowProcess();
    }

    public List<WorkflowStatusListener> getWorkflowListener() {
        return this.workflowListener;
    }

    public void register(WorkflowStatusListener listner) {
        this.workflowListener.add(listner);
    }

    public void setProgressMonitor(IProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    protected abstract IJob createWorkflowJob(WorkflowConfigurationType var1);

    protected abstract boolean useSeparateConsoleForEachJobRun();

    protected abstract WorkflowConfigurationType getConfiguration();
}

