/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.repository.local.dao;

import de.uka.ipd.sdq.identifier.Identifier;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.palladiosimulator.edp2.dao.MeasurementsDaoFactory;
import org.palladiosimulator.edp2.dao.MetaDao;
import org.palladiosimulator.edp2.dao.MetaDaoDelegate;
import org.palladiosimulator.edp2.dao.exception.DataNotAccessibleException;
import org.palladiosimulator.edp2.dao.impl.MetaDaoImpl;
import org.palladiosimulator.edp2.impl.resource.EmfModelXMIResourceFactoryImpl;
import org.palladiosimulator.edp2.local.LocalDirectoryRepository;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentGroup;
import org.palladiosimulator.edp2.models.ExperimentData.util.ExperimentDataSwitch;
import org.palladiosimulator.edp2.models.Repository.RepositoryPackage;
import org.palladiosimulator.edp2.repository.local.dao.LocalDirectoryMeasurementsDaoFactory;
import org.palladiosimulator.metricspec.Description;

public class LocalDirectoryMetaDao
extends MetaDaoImpl
implements MetaDaoDelegate {
    private static final Logger LOGGER = Logger.getLogger(LocalDirectoryMetaDao.class.getCanonicalName());
    MeasurementsDaoFactory mmtDaoFactory = null;
    private LocalDirectoryRepository managedRepo;
    private final Adapter reposAdapter = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            if (msg.getFeature().equals(RepositoryPackage.Literals.REPOSITORY__REPOSITORIES) && msg.getEventType() == 1 && msg.getOldValue() != null && LocalDirectoryMetaDao.this.isOpen()) {
                String errMsg = "Repository was reassigned to another instance of Repositories while it was still open. Data might be corrupted!";
                LOGGER.log(Level.SEVERE, "Repository was reassigned to another instance of Repositories while it was still open. Data might be corrupted!");
                throw new IllegalStateException("Repository was reassigned to another instance of Repositories while it was still open. Data might be corrupted!");
            }
        }
    };

    public void setParent(MetaDao repo) {
        this.managedRepo = (LocalDirectoryRepository)repo;
        this.managedRepo.eAdapters().add((Object)this.reposAdapter);
        LocalDirectoryMetaResourceAdapter descAdapter = new LocalDirectoryMetaResourceAdapter(this.managedRepo, (EStructuralFeature)RepositoryPackage.Literals.REPOSITORY__DESCRIPTIONS, "edp2desc");
        this.managedRepo.eAdapters().add((Object)descAdapter);
        LocalDirectoryMetaResourceAdapter expGroupAdapter = new LocalDirectoryMetaResourceAdapter(this.managedRepo, (EStructuralFeature)RepositoryPackage.Literals.REPOSITORY__EXPERIMENT_GROUPS, "edp2");
        this.managedRepo.eAdapters().add((Object)expGroupAdapter);
    }

    public MeasurementsDaoFactory getMeasurementsDaoFactory() {
        return this.mmtDaoFactory;
    }

    public boolean canOpen() {
        File directory;
        block9: {
            block8: {
                if (!super.canOpen()) {
                    return false;
                }
                try {
                    if (this.managedRepo.getRepositories() != null) break block8;
                    return false;
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
            }
            directory = null;
            try {
                directory = this.managedRepo.convertUriStringToFile(this.managedRepo.getUri());
            }
            catch (DataNotAccessibleException e) {
                return false;
            }
            if (this.checkFilesContainEmfModel(directory, "edp2desc", Description.class)) break block9;
            return false;
        }
        return this.checkFilesContainEmfModel(directory, "edp2", ExperimentGroup.class);
    }

    private boolean checkFilesContainEmfModel(File directory, String fileExtension, Class<?> expectedRoot) {
        File[] files;
        assert (directory.isDirectory());
        ResourceSet resourceSet = EmfModelXMIResourceFactoryImpl.createResourceSet();
        File[] fileArray = files = directory.listFiles(new FilenameExtensionFiler(fileExtension));
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            Resource resource;
            block8: {
                File file = fileArray[n2];
                if (!file.isFile()) {
                    return false;
                }
                resource = resourceSet.createResource(URI.createFileURI((String)file.getAbsolutePath()));
                if (resource == null) {
                    return false;
                }
                try {
                    resource.load(null);
                    if (resource.getWarnings().size() == 0 && resource.getErrors().size() == 0) break block8;
                    return false;
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "File " + directory.getAbsolutePath() + "did not contain a valid EMF model. Reason: " + e.getMessage());
                    resourceSet = null;
                    return false;
                }
            }
            if (resource.getContents().size() != 1 || !expectedRoot.isInstance(resource.getContents().get(0))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void close() throws DataNotAccessibleException {
        super.close();
        try {
            this.persistMetaData(false);
            this.closeRepository();
        }
        catch (IllegalArgumentException e) {
            String msg = "URI is not valid.";
            LOGGER.log(Level.WARNING, "URI is not valid.");
            throw new DataNotAccessibleException("URI is not valid.", (Throwable)e);
        }
        assert (!this.isOpen());
    }

    private void closeRepository() {
        if (this.mmtDaoFactory.isActive()) {
            this.mmtDaoFactory.setActive(false);
        }
        this.managedRepo.getDescriptions().clear();
        this.managedRepo.resetExperimentGroups();
        this.setClosed();
    }

    private void persistMetaData(boolean flushOnly) throws DataNotAccessibleException {
        URI uri = URI.createURI((String)this.managedRepo.getUri());
        this.saveDescriptions(uri, flushOnly);
        this.saveExperimentGroups(uri, flushOnly);
    }

    public void delete() throws DataNotAccessibleException {
        super.delete();
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void open() throws DataNotAccessibleException {
        super.open();
        try {
            if (this.managedRepo.getRepositories() == null) {
                String msg = "Every repository must be attached to an instance of Repositories in order to be opened.";
                LOGGER.log(Level.SEVERE, "Every repository must be attached to an instance of Repositories in order to be opened.");
                throw new DataNotAccessibleException("Every repository must be attached to an instance of Repositories in order to be opened.", null);
            }
            this.loadDescriptions();
            this.loadExperimentGroups();
            URI repositoryURI = URI.createURI((String)this.managedRepo.getId());
            this.mmtDaoFactory = LocalDirectoryMeasurementsDaoFactory.getRegisteredFactory(repositoryURI);
            if (this.mmtDaoFactory == null) {
                this.mmtDaoFactory = new LocalDirectoryMeasurementsDaoFactory(repositoryURI);
            } else if (!this.mmtDaoFactory.isActive()) {
                this.mmtDaoFactory.setActive(true);
            }
            this.setOpen();
        }
        catch (IllegalArgumentException e) {
            String msg = "URI is not valid.";
            LOGGER.log(Level.WARNING, "URI is not valid.");
            throw new DataNotAccessibleException("URI is not valid.", (Throwable)e);
        }
        assert (this.isOpen());
    }

    private void loadDescriptions() throws DataNotAccessibleException {
        File[] descriptionFiles;
        File[] fileArray = descriptionFiles = this.managedRepo.convertUriStringToFile(this.managedRepo.getId()).listFiles(new FilenameExtensionFiler("edp2desc"));
        int n = descriptionFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File descriptionFile = fileArray[n2];
            if (!descriptionFile.isFile()) {
                String msg = "Could not load the description file " + descriptionFile.getName();
                LOGGER.log(Level.WARNING, msg);
            }
            URI descriptionFileUri = URI.createURI((String)this.managedRepo.getId()).appendSegment(descriptionFile.getName());
            this.loadDescription(descriptionFileUri);
            ++n2;
        }
    }

    private void saveDescriptions(URI uri, boolean flushOnly) {
        for (Description desc : this.managedRepo.getDescriptions()) {
            this.saveDescription(uri, desc, flushOnly);
        }
    }

    private void saveDescription(URI uri, Description desc, boolean flushOnly) {
        URI descFileURI = uri.appendSegment(desc.getId()).appendFileExtension("edp2desc");
        Resource resource = this.getResourceForURI(descFileURI);
        if (resource == null) {
            String msg = "Could not create resource to save the description file " + descFileURI;
            LOGGER.log(Level.WARNING, msg);
        } else {
            if (desc.eResource() == null) {
                resource.getContents().add((Object)desc);
            } else if (!desc.eResource().equals(resource)) {
                LOGGER.log(Level.SEVERE, "Description was assigned to resource " + desc.eResource() + "but should be assigned to " + resource);
            }
            try {
                resource.save(null);
                if (!flushOnly) {
                    resource.unload();
                }
            }
            catch (IOException e) {
                String msg = "Could not save the description file " + descFileURI;
                LOGGER.log(Level.WARNING, msg, e);
            }
        }
    }

    private void saveExperimentGroups(URI uri, boolean flushOnly) {
        for (ExperimentGroup eg : this.managedRepo.getExperimentGroups()) {
            this.saveExperimentGroup(uri, eg, flushOnly);
        }
    }

    private Resource getResourceForURI(URI uri) {
        return this.managedRepo.getRepositories().getCommonResourceSet().getResource(uri, true);
    }

    private void saveExperimentGroup(URI uri, ExperimentGroup expGroup, boolean flushOnly) {
        URI egFileURI = uri.appendSegment(expGroup.getId()).appendFileExtension("edp2");
        Resource resource = this.getResourceForURI(egFileURI);
        if (resource == null) {
            String msg = "Could not create resource to save the experiment group file " + egFileURI;
            LOGGER.log(Level.SEVERE, msg);
            throw new RuntimeException("Unable to persist experiment group: " + expGroup);
        }
        if (expGroup.eResource() == null) {
            if (resource.getContents().size() > 0) {
                throw new IllegalStateException("Persisting experiment group which should have been persisted before: " + expGroup);
            }
            resource.getContents().add((Object)expGroup);
        } else if (!expGroup.eResource().equals(resource)) {
            LOGGER.log(Level.SEVERE, "ExperimentGroup was assigned to resource " + expGroup.eResource() + "but should be assigned to " + resource);
            throw new IllegalStateException("Resource for experiment group is not the one it should be");
        }
        try {
            resource.save(null);
            if (!flushOnly) {
                resource.unload();
            }
        }
        catch (IOException e) {
            String msg = "Could not save the experiment group file " + egFileURI;
            LOGGER.log(Level.WARNING, msg, e);
        }
    }

    private void loadDescription(URI descriptionURI) {
        assert (this.managedRepo.getRepositories() != null);
        Resource resource = this.getResourceForURI(descriptionURI);
        String errorMessage = null;
        try {
            resource.load(null);
            this.logDiagnostic((EList<Resource.Diagnostic>)resource.getErrors(), Level.SEVERE);
            this.logDiagnostic((EList<Resource.Diagnostic>)resource.getWarnings(), Level.WARNING);
            if (resource != null) {
                if (resource.getContents().size() == 1 && resource.getWarnings().size() == 0 && resource.getErrors().size() == 0 && resource.getContents().get(0) instanceof Description) {
                    this.managedRepo.getDescriptions().add((Object)((Description)resource.getContents().get(0)));
                } else {
                    errorMessage = "There was more or less than one root element or there were errors parsing the file.";
                }
            }
        }
        catch (IOException e) {
            errorMessage = "Could not load EMF model. Reason: " + e.getMessage();
        }
        if (errorMessage != null) {
            LOGGER.log(Level.WARNING, String.valueOf(errorMessage) + " URI: " + descriptionURI + ".");
        }
    }

    private void logDiagnostic(EList<Resource.Diagnostic> diagnostics, Level level) {
        if (diagnostics.size() != 0) {
            for (Resource.Diagnostic diag : diagnostics) {
                LOGGER.log(level, "EMF Diagnostic message: " + diag.toString());
            }
        }
    }

    private void loadExperimentGroups() throws DataNotAccessibleException {
        File[] expGroupFiles;
        File[] fileArray = expGroupFiles = this.managedRepo.convertUriStringToFile(this.managedRepo.getId()).listFiles(new FilenameExtensionFiler("edp2"));
        int n = expGroupFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File expGroupFile = fileArray[n2];
            if (!expGroupFile.isFile()) {
                String msg = "Could not load the experiment group file " + expGroupFile.getName();
                LOGGER.log(Level.WARNING, msg);
            }
            URI descriptionFileUri = URI.createURI((String)this.managedRepo.getId()).appendSegment(expGroupFile.getName());
            this.loadExperimentGroup(descriptionFileUri);
            ++n2;
        }
    }

    private void loadExperimentGroup(URI expGroupFile) {
        Resource resource = this.getResourceForURI(expGroupFile);
        String errorMessage = null;
        try {
            resource.load(null);
            this.logDiagnostic((EList<Resource.Diagnostic>)resource.getErrors(), Level.SEVERE);
            this.logDiagnostic((EList<Resource.Diagnostic>)resource.getWarnings(), Level.WARNING);
            if (resource != null) {
                if (resource.getContents().size() == 1 && resource.getWarnings().size() == 0 && resource.getErrors().size() == 0) {
                    if (((Boolean)new ExperimentDataSwitch<Boolean>(){

                        public Boolean caseExperimentGroup(ExperimentGroup object) {
                            return true;
                        }

                        public Boolean defaultCase(EObject object) {
                            return false;
                        }
                    }.doSwitch((EObject)resource.getContents().get(0))).booleanValue()) {
                        this.managedRepo.getExperimentGroups().add((Object)((ExperimentGroup)resource.getContents().get(0)));
                    } else {
                        errorMessage = "Root model element was not of type ExperimentGroup.";
                    }
                } else {
                    errorMessage = "There was more or less than one root element or there were errors parsing the file.";
                }
            }
        }
        catch (IOException e) {
            errorMessage = "Could not load EMF model.";
        }
        if (errorMessage != null) {
            LOGGER.log(Level.WARNING, String.valueOf(errorMessage) + " URI: " + expGroupFile + ".");
        }
    }

    public void flush() {
        try {
            this.persistMetaData(true);
        }
        catch (DataNotAccessibleException e) {
            LOGGER.log(Level.SEVERE, "Flush failed.", e);
            throw new RuntimeException(e);
        }
    }

    class FilenameExtensionFiler
    implements FilenameFilter {
        private final String extension;

        public FilenameExtensionFiler(String extension) {
            this.extension = extension;
        }

        @Override
        public boolean accept(File arg0, String arg1) {
            return arg1.endsWith(this.extension);
        }
    }

    private final class LocalDirectoryMetaResourceAdapter
    extends AdapterImpl {
        private final LocalDirectoryRepository repo;
        private final EStructuralFeature feature;
        private final String fileExtension;

        private LocalDirectoryMetaResourceAdapter(LocalDirectoryRepository repo, EStructuralFeature feature, String fileExtension) {
            this.repo = repo;
            this.feature = feature;
            this.fileExtension = fileExtension;
        }

        public void notifyChanged(Notification msg) {
            if (msg.getFeature().equals(this.feature)) {
                Identifier id2;
                if (msg.getEventType() == 3) {
                    id2 = (Identifier)msg.getNewValue();
                    this.assignResource(id2);
                }
                if (msg.getEventType() == 5) {
                    for (Identifier id2 : (Collection)msg.getNewValue()) {
                        this.assignResource(id2);
                    }
                }
                if (msg.getEventType() == 4) {
                    id2 = (Identifier)msg.getOldValue();
                    this.removeResource(id2);
                }
                if (msg.getEventType() == 6) {
                    for (Identifier id2 : (Collection)msg.getOldValue()) {
                        this.removeResource(id2);
                    }
                }
            }
        }

        private void assignResource(Identifier id) {
            if (id.eResource() == null) {
                URI uri = URI.createURI((String)this.repo.getUri()).appendSegment(id.getId()).appendFileExtension(this.fileExtension);
                Resource resource = this.repo.getRepositories().getCommonResourceSet().createResource(uri);
                resource.getContents().add((Object)id);
                assert (id.eResource() != null);
            }
        }

        private void removeResource(Identifier id) {
            if (id.eResource() != null) {
                try {
                    id.eResource().delete(null);
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Could not delete file for a removed element. " + e.getMessage());
                }
            }
        }
    }
}

