/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.architecturaltemplates.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.modelversioning.emfprofile.Profile;
import org.modelversioning.emfprofile.Stereotype;
import org.modelversioning.emfprofile.registry.IProfileRegistry;
import org.modelversioning.emfprofileapplication.ProfileImport;
import org.modelversioning.emfprofileapplication.StereotypeApplication;
import org.palladiosimulator.architecturaltemplates.AT;
import org.palladiosimulator.architecturaltemplates.Catalog;
import org.palladiosimulator.architecturaltemplates.Role;
import org.palladiosimulator.commons.eclipseutils.ExtensionHelper;
import org.palladiosimulator.commons.emfutils.EMFLoadHelper;
import org.palladiosimulator.mdsdprofiles.api.ProfileAPI;
import org.palladiosimulator.mdsdprofiles.api.StereotypeAPI;
import org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment;
import org.palladiosimulator.pcm.system.System;

public final class ArchitecturalTemplateAPI {
    private static final String ARCHITECTURALTEMPLATE_ANNOTATION = "org.palladiosimulator.architecturaltemplate";
    private static final String ARCHITECTURALTEMPLATE_ANNOTATION_AT_URI = "AT";
    private static final String SYSTEM_ROLE_NAME_SUFFIX = "System";

    private ArchitecturalTemplateAPI() {
    }

    public static AT getArchitecturalTemplate(Stereotype stereotype) {
        if (!ArchitecturalTemplateAPI.isRole(stereotype)) {
            throw new RuntimeException("Stereotype \"" + stereotype + "\" is no role");
        }
        return ArchitecturalTemplateAPI.getATFromURI(ArchitecturalTemplateAPI.getArchitecturalTemplateURI(stereotype));
    }

    private static String getArchitecturalTemplateURI(Stereotype stereotype) {
        String architecturalTemplateURI = (String)ArchitecturalTemplateAPI.getArchitecturalTemplateAnnotation(stereotype).getDetails().get((Object)ARCHITECTURALTEMPLATE_ANNOTATION_AT_URI);
        if (architecturalTemplateURI == null) {
            throw new RuntimeException("The stereotype \"" + stereotype.getName() + "\" has an AT annotation but does not link an AT!");
        }
        return architecturalTemplateURI;
    }

    private static AT getATFromURI(String architecturalTemplateURI) {
        EObject architecturalTemplate = EMFLoadHelper.loadAndResolveEObject((String)architecturalTemplateURI);
        if (!(architecturalTemplate instanceof AT)) {
            throw new RuntimeException("ArchitecturalTemplateURI \"" + architecturalTemplateURI + "\" does not refer to an AT!");
        }
        return (AT)architecturalTemplate;
    }

    public static Role getRole(Stereotype stereotype) {
        AT at = ArchitecturalTemplateAPI.getArchitecturalTemplate(stereotype);
        Optional<Role> role = at.getRoles().stream().filter(r -> r.getStereotype().getName().equals(stereotype.getName())).findAny();
        if (!role.isPresent()) {
            throw new RuntimeException("Did not find AT role for stereotype \"" + stereotype + "\"!");
        }
        return role.get();
    }

    public static AT getArchitecturalTemplate(Profile profile) {
        if (!ArchitecturalTemplateAPI.isArchitecturalTemplate(profile)) {
            throw new RuntimeException("Profile \"" + profile + "\" is no Architectural Template");
        }
        return ArchitecturalTemplateAPI.getRole((Stereotype)profile.getStereotypes().get(0)).getAT();
    }

    public static boolean isRole(Stereotype stereotype) {
        return ArchitecturalTemplateAPI.getArchitecturalTemplateAnnotation(stereotype) != null;
    }

    private static EAnnotation getArchitecturalTemplateAnnotation(Stereotype stereotype) {
        return ArchitecturalTemplateAPI.getArchitecturalTemplateAnnotation(stereotype.getProfile());
    }

    private static EAnnotation getArchitecturalTemplateAnnotation(Profile profile) {
        return profile.getEAnnotation(ARCHITECTURALTEMPLATE_ANNOTATION);
    }

    public static boolean isSystemRole(Stereotype stereotype) {
        return ArchitecturalTemplateAPI.isRole(stereotype) && stereotype.getName().endsWith(SYSTEM_ROLE_NAME_SUFFIX);
    }

    public static boolean isArchitecturalTemplateStereotypeApplication(StereotypeApplication stereotypeApplication) {
        return Optional.ofNullable(stereotypeApplication).map(StereotypeApplication::getStereotype).map(ArchitecturalTemplateAPI::isArchitecturalTemplateStereotype).orElse(false);
    }

    public static boolean isArchitecturalTemplateStereotype(Stereotype stereotype) {
        return Optional.ofNullable(stereotype).map(Stereotype::getProfile).map(ArchitecturalTemplateAPI::isArchitecturalTemplate).orElse(false);
    }

    public static boolean isArchitecturalTemplate(Profile profile) {
        return ArchitecturalTemplateAPI.getArchitecturalTemplateAnnotation(profile) != null;
    }

    public static Stereotype getSystemRoleStereotype(Profile profile) {
        if (!ArchitecturalTemplateAPI.isArchitecturalTemplate(profile)) {
            throw new RuntimeException("Profile \"" + profile + "\" is no Architectural Template");
        }
        for (Stereotype s : profile.getStereotypes()) {
            if (!ArchitecturalTemplateAPI.isSystemRole(s)) continue;
            return s;
        }
        return null;
    }

    public static void applyArchitecturalTemplate(System system, AT architecturalTemplate) {
        if (architecturalTemplate.getRoles().size() == 0) {
            throw new RuntimeException("Architectural Template \"" + architecturalTemplate + "\" does not contain any roles");
        }
        ArchitecturalTemplateAPI.applyArchitecturalTemplate(system, ((Role)architecturalTemplate.getRoles().get(0)).getStereotype().getProfile());
    }

    public static void applyArchitecturalTemplate(System system, Profile profile) {
        if (!ArchitecturalTemplateAPI.isArchitecturalTemplate(profile)) {
            throw new RuntimeException("Profile \"" + profile + "\" is no Architectural Template");
        }
        Stereotype systemRoleStereotype = ArchitecturalTemplateAPI.getSystemRoleStereotype(profile);
        ProfileAPI.applyProfile((Resource)system.eResource(), (Profile)profile);
        StereotypeAPI.applyStereotype((EObject)system, (Stereotype)systemRoleStereotype);
        EPackage.Registry.INSTANCE.put((Object)profile.getNsURI(), (Object)profile);
    }

    public static void applyArchitecturalTemplate(ResourceEnvironment resourceenvironment, AT architecturalTemplate) {
        if (architecturalTemplate.getRoles().size() == 0) {
            throw new RuntimeException("Architectural Template \"" + architecturalTemplate + "\" does not contain any roles");
        }
        ArchitecturalTemplateAPI.applyArchitecturalTemplate(resourceenvironment, ((Role)architecturalTemplate.getRoles().get(0)).getStereotype().getProfile());
    }

    public static void applyArchitecturalTemplate(ResourceEnvironment resourceenvironment, Profile profile) {
        if (!ArchitecturalTemplateAPI.isArchitecturalTemplate(profile)) {
            throw new RuntimeException("Profile \"" + profile + "\" is no Architectural Template");
        }
        ProfileAPI.applyProfile((Resource)resourceenvironment.eResource(), (Profile)profile);
        EPackage.Registry.INSTANCE.put((Object)profile.getNsURI(), (Object)profile);
    }

    public static void unapplyArchitecturalTemplate(System system, AT architecturalTemplate) {
        if (architecturalTemplate.getRoles().size() == 0) {
            throw new RuntimeException("Architectural Template \"" + architecturalTemplate + "\" does not contain any roles");
        }
        ArchitecturalTemplateAPI.unapplyArchitecturalTemplate(system, ((Role)architecturalTemplate.getRoles().get(0)).getStereotype().getProfile());
    }

    public static void unapplyArchitecturalTemplate(System system, Profile profile) {
        if (!ArchitecturalTemplateAPI.isArchitecturalTemplate(profile)) {
            throw new RuntimeException("Profile \"" + profile + "\" is no Architectural Template");
        }
        ProfileAPI.unapplyProfile((Resource)system.eResource(), (Profile)profile);
    }

    public static void unapplyArchitecturalTemplate(ResourceEnvironment resourceenvironment, AT architecturalTemplate) {
        if (architecturalTemplate.getRoles().size() == 0) {
            throw new RuntimeException("Architectural Template \"" + architecturalTemplate + "\" does not contain any roles");
        }
        ArchitecturalTemplateAPI.unapplyArchitecturalTemplate(resourceenvironment, ((Role)architecturalTemplate.getRoles().get(0)).getStereotype().getProfile());
    }

    public static void unapplyArchitecturalTemplate(ResourceEnvironment resourceenvironment, Profile profile) {
        if (!ArchitecturalTemplateAPI.isArchitecturalTemplate(profile)) {
            throw new RuntimeException("Profile \"" + profile + "\" is no Architectural Template");
        }
        ProfileAPI.unapplyProfile((Resource)resourceenvironment.eResource(), (Profile)profile);
    }

    public static void applyRole(EObject eObject, Role role) {
        StereotypeAPI.applyStereotype((EObject)eObject, (Stereotype)role.getStereotype());
    }

    public static void applyRole(EObject eObject, Stereotype stereotype) {
        if (!ArchitecturalTemplateAPI.isRole(stereotype)) {
            throw new RuntimeException("Stereotype \"" + stereotype + "\" is no role");
        }
        StereotypeAPI.applyStereotype((EObject)eObject, (Stereotype)stereotype);
    }

    public static void unapplyRole(EObject eObject, Role role) {
        StereotypeAPI.unapplyStereotype((EObject)eObject, (Stereotype)role.getStereotype());
    }

    public static void unapplyRole(EObject eObject, Stereotype stereotype) {
        if (!ArchitecturalTemplateAPI.isRole(stereotype)) {
            throw new RuntimeException("Stereotype \"" + stereotype + "\" is no role");
        }
        StereotypeAPI.unapplyStereotype((EObject)eObject, (Stereotype)stereotype);
    }

    public static Collection<AT> getAppliedArchitecturalTemplates(Resource resource) {
        LinkedList<AT> appliedATs = new LinkedList<AT>();
        for (Profile appliedProfile : ProfileAPI.getAppliedProfiles((Resource)resource)) {
            if (!ArchitecturalTemplateAPI.isArchitecturalTemplate(appliedProfile)) continue;
            appliedATs.add(ArchitecturalTemplateAPI.getArchitecturalTemplate(appliedProfile));
        }
        return appliedATs;
    }

    public static Collection<StereotypeApplication> getArchitecturalTemplateApplications(System system) {
        LinkedList<StereotypeApplication> systemRoleStereotypeApplications = new LinkedList<StereotypeApplication>();
        for (StereotypeApplication stereotypeApplication : StereotypeAPI.getStereotypeApplications((EObject)system)) {
            if (!ArchitecturalTemplateAPI.isSystemRole(stereotypeApplication.getStereotype())) continue;
            systemRoleStereotypeApplications.add(stereotypeApplication);
        }
        return Collections.unmodifiableCollection(systemRoleStereotypeApplications);
    }

    public static Collection<AT> getATsFromSystem(System system) {
        LinkedList<AT> ATs = new LinkedList<AT>();
        if (system != null) {
            for (Stereotype stereotype : StereotypeAPI.getAppliedStereotypes((EObject)system)) {
                if (!ArchitecturalTemplateAPI.isSystemRole(stereotype)) continue;
                ATs.add(ArchitecturalTemplateAPI.getRole(stereotype).getAT());
            }
        }
        return Collections.unmodifiableCollection(ATs);
    }

    public static Collection<Role> getAppliedRoles(EObject eObject) {
        ArrayList<Role> appliedRoles = new ArrayList<Role>();
        for (Stereotype stereotype : StereotypeAPI.getAppliedStereotypes((EObject)eObject)) {
            if (!ArchitecturalTemplateAPI.isRole(stereotype)) continue;
            appliedRoles.add(ArchitecturalTemplateAPI.getRole(stereotype));
        }
        return appliedRoles;
    }

    public static Collection<StereotypeApplication> getRoleApplications(EObject eObject) {
        ArrayList<StereotypeApplication> roleStereotypeApplications = new ArrayList<StereotypeApplication>();
        for (StereotypeApplication stereotypeApplication : StereotypeAPI.getStereotypeApplications((EObject)eObject)) {
            if (!ArchitecturalTemplateAPI.isRole(stereotypeApplication.getStereotype())) continue;
            roleStereotypeApplications.add(stereotypeApplication);
        }
        return roleStereotypeApplications;
    }

    public static Collection<StereotypeApplication> getATStereotypeApplicationsWithoutRoles(EObject eObject) {
        ArrayList<StereotypeApplication> roleStereotypeApplications = new ArrayList<StereotypeApplication>();
        for (StereotypeApplication stereotypeApplication : StereotypeAPI.getStereotypeApplications((EObject)eObject)) {
            if (!ArchitecturalTemplateAPI.isArchitecturalTemplateStereotypeApplication(stereotypeApplication) || ArchitecturalTemplateAPI.isRole(stereotypeApplication.getStereotype())) continue;
            roleStereotypeApplications.add(stereotypeApplication);
        }
        return roleStereotypeApplications;
    }

    public static final Collection<ProfileImport> getATProfileImports(EObject eObject) {
        if (ProfileAPI.hasProfileApplication((Resource)eObject.eResource())) {
            return Collections.unmodifiableCollection(ProfileAPI.getProfileApplication((Resource)eObject.eResource()).getImportedProfiles().stream().filter(pi -> ArchitecturalTemplateAPI.isArchitecturalTemplate(pi.getProfile())).collect(Collectors.toList()));
        }
        return Collections.emptyList();
    }

    public static Collection<AT> getRegisteredArchitecturalTemplates() {
        ArrayList<AT> registeredATs = new ArrayList<AT>();
        for (Profile profile : IProfileRegistry.eINSTANCE.getRegisteredProfiles()) {
            if (!ArchitecturalTemplateAPI.isArchitecturalTemplate(profile)) continue;
            registeredATs.add(ArchitecturalTemplateAPI.getArchitecturalTemplate(profile));
        }
        return registeredATs;
    }

    public static Collection<Role> getApplicableRoles(EObject eObject) {
        ArrayList<Role> applicableRoles = new ArrayList<Role>();
        for (Stereotype applicableStereotype : StereotypeAPI.getApplicableStereotypes((EObject)eObject)) {
            if (!ArchitecturalTemplateAPI.isRole(applicableStereotype) || StereotypeAPI.isStereotypeApplied((EObject)eObject, (Stereotype)applicableStereotype)) continue;
            applicableRoles.add(ArchitecturalTemplateAPI.getRole(applicableStereotype));
        }
        return applicableRoles;
    }

    public static boolean hasRoles(EObject eObject) {
        return !ArchitecturalTemplateAPI.getAppliedRoles(eObject).isEmpty();
    }

    public static Set<AT> getInitiatorATs() {
        return ArchitecturalTemplateAPI.getRegisteredATCatlogs().stream().flatMap(catalog -> catalog.getATs().stream()).filter(at -> at.getDefaultInstanceURI() != null && !at.getDefaultInstanceURI().isEmpty()).collect(Collectors.toSet());
    }

    public static Set<Catalog> getRegisteredATCatlogs() {
        List catalogURIs = ExtensionHelper.getAttributes((String)"org.palladiosimulator.architecturaltemplates.catalogs", (String)"ATCatalog", (String)"catalogURI");
        return catalogURIs.stream().map(EMFLoadHelper::loadAndResolveEObject).map(eObject -> (Catalog)eObject).collect(Collectors.toSet());
    }
}

