/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.workflow.mdsd.xtext.generator;

import de.uka.ipd.sdq.workflow.mdsd.blackboard.ModelLocation;
import de.uka.ipd.sdq.workflow.mdsd.xtext.generator.BlackboardReader;
import de.uka.ipd.sdq.workflow.mdsd.xtext.generator.XTextGeneratorModule;
import de.uka.ipd.sdq.workflow.mdsd.xtext.generator.XTextGeneratorSetup;
import de.uka.ipd.sdq.workflow.mdsd.xtext.generator.XTextGeneratorSupport;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.emf.mwe.utils.StandaloneSetup;
import org.eclipse.xtext.ISetup;
import org.eclipse.xtext.generator.GeneratorComponent;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.mwe.AbstractReader;
import org.eclipse.xtext.mwe.Reader;
import org.eclipse.xtext.mwe.ResourceLoadingSlotEntry;

public class XTextGeneratorConfiguration {
    private XTextGeneratorModule module;
    private ISetup setup;
    private final Class<? extends IGenerator> generatorClass;
    private final String languageName;
    private final String fileExtension;
    private final String outputPackageName;
    private ModelLocation modelLocation;
    private final Set<String> slots = new TreeSet<String>();
    private final Set<GeneratorComponent.Outlet> outlets = new TreeSet<GeneratorComponent.Outlet>();
    private final Set<String> readerPathes = new TreeSet<String>();
    private final Set<ResourceLoadingSlotEntry> loadEntries = new TreeSet<ResourceLoadingSlotEntry>();
    private GeneratorComponent generator;

    public void initMWEBean() {
        StandaloneSetup standaloneSetup = new StandaloneSetup();
        standaloneSetup.addRegisterGeneratedEPackage(this.outputPackageName);
        standaloneSetup.setScanClassPath(true);
    }

    public void setModelFilePath(String modelPath) {
        this.readerPathes.add(modelPath);
    }

    public void setTargetDir(String targetDir) {
        GeneratorComponent.Outlet o = new GeneratorComponent.Outlet();
        o.setPath(targetDir);
        this.outlets.add(o);
    }

    public void setSourceSlot(String slotName) {
        this.slots.add(slotName);
        ResourceLoadingSlotEntry loadEntry = new ResourceLoadingSlotEntry();
        loadEntry.setSlot(slotName);
        this.loadEntries.add(loadEntry);
    }

    public Class<? extends IGenerator> getGeneratorClass() {
        return this.generatorClass;
    }

    public String getLanguageName() {
        return this.languageName;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public XTextGeneratorConfiguration(Class<? extends IGenerator> generatorClass, String languageName, String fileExtension, String outputPackageName) {
        this.generatorClass = generatorClass;
        this.languageName = languageName;
        this.fileExtension = fileExtension;
        this.outputPackageName = outputPackageName;
    }

    public Reader createReader() {
        if (this.readerPathes.isEmpty()) {
            throw new RuntimeException("XText Reader requires a path!");
        }
        Reader reader = new Reader();
        this.setupReader((AbstractReader)reader);
        for (String path : this.readerPathes) {
            reader.addPath(path);
        }
        return reader;
    }

    private void setupReader(AbstractReader reader) {
        reader.addRegister(this.setup);
        for (ResourceLoadingSlotEntry entry : this.loadEntries) {
            reader.addLoadResource(entry);
        }
    }

    public GeneratorComponent createGenerator() {
        this.generator = new GeneratorComponent();
        this.generator.setRegister(this.setup);
        for (String slot : this.slots) {
            this.generator.addSlot(slot);
        }
        for (GeneratorComponent.Outlet outlet : this.outlets) {
            this.generator.addOutlet(outlet);
        }
        return this.generator;
    }

    public void initGeneratorModuleAndGeneratorSetup() {
        this.module = new XTextGeneratorModule(this.generatorClass, this.languageName, this.fileExtension);
        this.setup = new XTextGeneratorSetup(this.module);
    }

    public XTextGeneratorSupport createGeneratorSupport() {
        return new XTextGeneratorSupport(this.module);
    }

    public Set<String> getSlots() {
        return this.slots;
    }

    public ModelLocation getBlackboardModelLocation() {
        return this.modelLocation;
    }

    public void setBlackboardModelLocation(ModelLocation modelLocation) {
        this.modelLocation = modelLocation;
    }

    public BlackboardReader createBlackboardReader() {
        if (this.modelLocation == null) {
            throw new RuntimeException("XText BlackboardReader requires a modelLocation!");
        }
        BlackboardReader reader = new BlackboardReader(this.modelLocation);
        this.setupReader(reader);
        return reader;
    }
}

