/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simulation.abstractsimengine;

import de.uka.ipd.sdq.simulation.abstractsimengine.ISimulationControl;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimulationModel;
import de.uka.ipd.sdq.simulation.abstractsimengine.SimCondition;
import java.util.ArrayList;
import java.util.Observer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class AbstractExperiment
implements ISimulationControl {
    private static final Logger LOGGER = Logger.getLogger(AbstractExperiment.class);
    private final ArrayList<SimCondition> stopConditions = new ArrayList();
    private final ArrayList<Observer> timeObservers = new ArrayList();
    private final AtomicBoolean isRunning = new AtomicBoolean();
    private double lastNotificationTime = 0.0;
    protected final ISimulationModel model;

    public AbstractExperiment(ISimulationModel model) {
        this.model = model;
    }

    @Override
    public void addStopCondition(SimCondition condition) {
        this.stopConditions.add(condition);
    }

    @Override
    public void start() {
        this.isRunning.set(true);
        this.model.init();
        double start = System.nanoTime();
        if (LOGGER.isEnabledFor((Priority)Level.INFO)) {
            LOGGER.info((Object)"Starting simulation...");
        }
        this.startSimulator();
        if (LOGGER.isEnabledFor((Priority)Level.INFO)) {
            LOGGER.info((Object)("Simulation terminated. Took " + ((double)System.nanoTime() - start) / Math.pow(10.0, 9.0) + " real time seconds."));
        }
    }

    @Override
    public void stop() {
        if (this.isRunning.compareAndSet(true, false)) {
            if (LOGGER.isEnabledFor((Priority)Level.INFO)) {
                LOGGER.info((Object)"Simulation stop requested!");
            }
            this.stopSimulator();
            this.model.finalise();
        } else if (LOGGER.isEnabledFor((Priority)Level.WARN)) {
            LOGGER.warn((Object)"Tried to stop the simulation, which has already been stopped.");
        }
    }

    @Override
    public boolean isRunning() {
        return this.isRunning.get();
    }

    public boolean checkStopConditions() {
        this.notifyTimeObservers();
        for (SimCondition c : this.stopConditions) {
            if (!c.check()) continue;
            LOGGER.debug((Object)("Found matching stop condition: " + c.getClass().getCanonicalName()));
            return true;
        }
        return false;
    }

    @Override
    public void addTimeObserver(Observer observer) {
        this.timeObservers.add(observer);
    }

    public abstract void startSimulator();

    public abstract void stopSimulator();

    protected void notifyTimeObservers() {
        if (this.lastNotificationTime != this.getCurrentSimulationTime()) {
            this.lastNotificationTime = this.getCurrentSimulationTime();
            for (Observer o : this.timeObservers) {
                o.update(null, this.lastNotificationTime);
            }
        }
    }
}

