/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simulation.abstractsimengine;

import de.uka.ipd.sdq.simulation.abstractsimengine.AbstractSimEntityDelegator;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimProcess;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimProcessListener;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimulationModel;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AbstractSimProcessDelegator
extends AbstractSimEntityDelegator
implements ISimProcess {
    private static AtomicLong processIdGenerator = new AtomicLong(0L);
    private ISimProcess delegate;
    private long id;

    public AbstractSimProcessDelegator(ISimulationModel model, String name) {
        super(model, name);
        this.delegate = model.getSimEngineFactory().createSimProcess(this, name);
        this.id = AbstractSimProcessDelegator.generateNextID();
    }

    public long getRawId() {
        return this.id;
    }

    public String getId() {
        return String.valueOf(this.getName()) + "_" + this.id;
    }

    private static long generateNextID() {
        return processIdGenerator.incrementAndGet();
    }

    public abstract void lifeCycle();

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public void passivate() {
        this.delegate.passivate();
    }

    @Override
    public void scheduleAt(double d) {
        this.delegate.scheduleAt(d);
    }

    @Override
    public void passivate(double delay) {
        this.delegate.passivate(delay);
    }

    @Override
    public void addProcessListener(ISimProcessListener l) {
        this.delegate.addProcessListener(l);
    }

    @Override
    public void removeProcessListener(ISimProcessListener l) {
        this.delegate.removeProcessListener(l);
    }

    @Override
    public void preempt() {
        this.delegate.preempt();
    }
}

