/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.pcm.extension.ui.table;

import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public abstract class EditorSection {
    private Composite composite;
    private ToolItem addButton;
    private ToolItem deleteButton;
    protected TableViewer viewer;
    private EObject selectedObject = null;

    public EditorSection(Composite composite) {
        this.composite = composite.getParent().getParent();
        GridLayout parentLayout = (GridLayout)this.composite.getLayout();
        this.composite.setLayoutData((Object)new GridData(4, 4, true, true));
        parentLayout.numColumns = 2;
        this.createEditorSection();
    }

    private void createEditorSection() {
        ToolBar toolBar = this.createToolBar();
        this.createTableSection(toolBar);
    }

    protected ToolBar createToolBar() {
        ToolBar toolBar = new ToolBar(this.composite, 512);
        GridData data = new GridData(16384, 4, false, true);
        toolBar.setLayoutData((Object)data);
        if (this.canAddButonCreated()) {
            this.addButton = new ToolItem(toolBar, 8);
            this.addButton.addSelectionListener(this.createAddButtonActionListener());
        }
        if (this.canDeleteButonCreated()) {
            this.deleteButton = new ToolItem(toolBar, 8);
            this.deleteButton.setEnabled(false);
        }
        return toolBar;
    }

    protected void createTableSection(ToolBar toolBar) {
        int style = 101124;
        Table table = new Table(this.composite, style);
        GridData data = new GridData(4, 4, true, true);
        table.setLayoutData((Object)data);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.moveAbove(this.composite.getChildren()[0]);
        toolBar.moveBelow(this.composite.getChildren()[0]);
        this.viewer = new TableViewer(table);
        this.viewer.setUseHashlookup(true);
        this.viewer.setColumnProperties(this.getTableColumnNames());
        this.viewer.setCellEditors(this.createViewerCellEditors(table));
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object input = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (input instanceof EObject) {
                    EditorSection.this.selectedObject = (EObject)input;
                    EditorSection.this.setDeleteButtonEnabled(EditorSection.this.inputValidation(EditorSection.this.selectedObject));
                } else {
                    EditorSection.this.setDeleteButtonEnabled(false);
                }
            }
        });
        this.setDeleteButtonListener(this.viewer);
        this.createTableColumns(table);
    }

    protected abstract void createTableColumns(Table var1);

    protected abstract boolean inputValidation(EObject var1);

    protected void setDeleteButtonListener(TableViewer viewer) {
        SelectionListener listener = this.createDeleteButtonListener();
        viewer.addSelectionChangedListener((ISelectionChangedListener)listener);
        if (this.canDeleteButonCreated()) {
            this.deleteButton.addSelectionListener(listener);
        }
    }

    protected abstract SelectionListener createDeleteButtonListener();

    protected abstract String[] getTableColumnNames();

    protected abstract boolean canAddButonCreated();

    protected abstract boolean canDeleteButonCreated();

    protected abstract CellEditor[] createViewerCellEditors(Table var1);

    public void setViewerCellModifier(ICellModifier modifier) {
        Assert.isNotNull((Object)this.viewer);
        this.viewer.setCellModifier(modifier);
    }

    public void addViewerSelectionChangedListener(ISelectionChangedListener listener) {
        Assert.isNotNull((Object)this.viewer);
        this.viewer.addSelectionChangedListener(listener);
    }

    protected abstract SelectionListener createAddButtonActionListener();

    public void setViewerInput(Object input) {
        Assert.isNotNull((Object)this.viewer);
        this.viewer.setInput(input);
    }

    public void setViewerContentProvider(IContentProvider contentProvider) {
        Assert.isNotNull((Object)this.viewer);
        this.viewer.setContentProvider(contentProvider);
    }

    public void setViewerLabelProvider(IBaseLabelProvider labelProvider) {
        Assert.isNotNull((Object)this.viewer);
        this.viewer.setLabelProvider(labelProvider);
    }

    public void refresh() {
        Assert.isNotNull((Object)this.viewer);
        this.viewer.refresh();
    }

    protected void setDeleteButtonEnabled(boolean enabled) {
        this.deleteButton.setEnabled(enabled);
    }

    public EObject getSelectedObject() {
        return this.selectedObject;
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    public void setEnabled(boolean isEnabled) {
        if (!this.viewer.getTable().isDisposed()) {
            this.viewer.getTable().setEnabled(isEnabled);
        }
        if (!this.addButton.isDisposed()) {
            this.addButton.setEnabled(isEnabled);
        }
        if (!this.deleteButton.isDisposed()) {
            this.deleteButton.setEnabled(isEnabled);
        }
    }
}

