/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.ui.wizards;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.palladiosimulator.edp2.dao.exception.DataNotAccessibleException;
import org.palladiosimulator.edp2.ui.wizards.datasource.FileSystemButtonSelectionAdater;
import org.palladiosimulator.edp2.ui.wizards.datasource.WorkspaceButtonSelectionAdapter;

public class TargetDirectoryPage
extends WizardPage {
    private static final Logger LOGGER = Logger.getLogger(TargetDirectoryPage.class.getCanonicalName());
    private Text locationText;

    protected TargetDirectoryPage() {
        super("wizardPage");
        this.setTitle("Select File Export Location");
        this.setDescription("Please select the location to which you want to export the selected repository.");
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        this.locationText = new Text(container, 2048);
        this.createDirectoryInputSection(container, "Location: ", this.locationText);
        this.locationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (TargetDirectoryPage.this.isFolder(TargetDirectoryPage.this.locationText.getText())) {
                    TargetDirectoryPage.this.setPageComplete(true);
                } else {
                    TargetDirectoryPage.this.setPageComplete(false);
                }
            }
        });
        GridLayoutFactory.swtDefaults().numColumns(2).spacing(10, 5).generateLayout(container);
    }

    private boolean isFolder(String uriString) {
        try {
            return this.convertUriStringToFileInternal(uriString).isDirectory();
        }
        catch (DataNotAccessibleException e) {
            return false;
        }
    }

    private File convertUriStringToFileInternal(String uriString) throws DataNotAccessibleException {
        String fileLocation;
        URI uri = URI.createURI((String)uriString);
        if (uri.isPlatform()) {
            URL urlToFoo = null;
            try {
                urlToFoo = FileLocator.toFileURL((URL)new URL(uri.toString()));
                fileLocation = urlToFoo.getFile();
            }
            catch (MalformedURLException e) {
                throw new DataNotAccessibleException("The URI is not well-formed.", (Throwable)e);
            }
            catch (IOException e) {
                throw new DataNotAccessibleException("The URI could not be converted.", (Throwable)e);
            }
        } else {
            fileLocation = uri.toFileString();
        }
        if (fileLocation == null) {
            throw new DataNotAccessibleException("The URI could not be converted to a local file.", null);
        }
        File directory = new File(fileLocation);
        if (!directory.isDirectory()) {
            throw new DataNotAccessibleException("The URI does not point to a directory.", null);
        }
        return directory;
    }

    public void createDirectoryInputSection(Composite container, String modelFileLabel, Text textFileNameToLoad) {
        Group fileInputGroup = new Group(container, 0);
        GridLayout glFileInputGroup = new GridLayout();
        glFileInputGroup.numColumns = 3;
        fileInputGroup.setLayout((Layout)glFileInputGroup);
        fileInputGroup.setText(modelFileLabel);
        fileInputGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        textFileNameToLoad.setParent((Composite)fileInputGroup);
        GridData gd_textFileName = new GridData(4, 0x1000000, true, false);
        gd_textFileName.widthHint = 200;
        textFileNameToLoad.setLayoutData((Object)gd_textFileName);
        Button workspaceButton = new Button((Composite)fileInputGroup, 0);
        workspaceButton.setText("Workspace...");
        workspaceButton.addSelectionListener((SelectionListener)new WorkspaceButtonSelectionAdapter(this.getShell(), textFileNameToLoad));
        Button buttonUsage = new Button((Composite)fileInputGroup, 0);
        buttonUsage.setText("File System...");
        buttonUsage.addSelectionListener((SelectionListener)new FileSystemButtonSelectionAdater(this.getShell(), textFileNameToLoad));
    }

    public String getTargetDirectoryOnFinish() {
        try {
            return this.convertUriStringToFileInternal(this.locationText.getText()).getAbsolutePath();
        }
        catch (DataNotAccessibleException e) {
            LOGGER.log(Level.SEVERE, "Access to specified URL failed.");
            e.printStackTrace();
            return null;
        }
    }
}

