/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.datastream.elementfactories;

import org.eclipse.ui.IMemento;
import org.palladiosimulator.edp2.EDP2Plugin;
import org.palladiosimulator.edp2.datastream.configurable.IPropertyConfigurable;
import org.palladiosimulator.edp2.datastream.configurable.PropertyConfigurableElementFactory;
import org.palladiosimulator.edp2.datastream.edp2source.Edp2DataTupleDataSource;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentGroup;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentGroupRun;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentRun;
import org.palladiosimulator.edp2.models.ExperimentData.RawMeasurements;
import org.palladiosimulator.edp2.models.ExperimentData.Run;
import org.palladiosimulator.edp2.models.Repository.Repository;

public class Edp2DataTupleDataSourceFactory
extends PropertyConfigurableElementFactory {
    private static final String MEASUREMENTS_UUID = "MeasurementsUUID";
    private static final String REPOSITORY_UUID = "RepositoryUUID";
    public static final String FACTORY_ID = Edp2DataTupleDataSourceFactory.class.getCanonicalName();

    @Override
    protected IPropertyConfigurable createElementInternal(IMemento memento) {
        String repoID = memento.getString(REPOSITORY_UUID);
        String measurementID = memento.getString(MEASUREMENTS_UUID);
        Repository repo = null;
        for (Repository r : EDP2Plugin.INSTANCE.getRepositories().getAvailableRepositories()) {
            if (!r.getId().equals(repoID)) continue;
            repo = r;
            break;
        }
        RawMeasurements measurements = (RawMeasurements)((ExperimentGroup)repo.getExperimentGroups().get(0)).eResource().getEObject(measurementID);
        return new Edp2DataTupleDataSource(measurements);
    }

    public static void saveState(IMemento memento, Edp2DataTupleDataSource edp2DataTupleDataSource) {
        ExperimentGroup experimentGroup;
        RawMeasurements measurements = edp2DataTupleDataSource.getRawMeasurements();
        Run run = measurements.getMeasurementRange().getMeasurement().getRun();
        if (run instanceof ExperimentRun) {
            experimentGroup = ((ExperimentRun)run).getExperimentSetting().getExperimentGroup();
        } else if (run instanceof ExperimentGroupRun) {
            experimentGroup = ((ExperimentGroupRun)run).getExperimentgroup();
        } else {
            throw new IllegalArgumentException("Unknown run type");
        }
        if (experimentGroup != null && experimentGroup.getRepository() != null) {
            memento.putString(REPOSITORY_UUID, experimentGroup.getRepository().getId());
        }
        if (measurements != null) {
            memento.putString(MEASUREMENTS_UUID, measurements.getId());
        }
    }
}

