/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.util;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.Measure;
import javax.measure.quantity.Quantity;
import javax.measure.unit.Unit;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.palladiosimulator.edp2.dao.BinaryMeasurementsDao;
import org.palladiosimulator.edp2.dao.MeasurementsDao;
import org.palladiosimulator.edp2.dao.MeasurementsDaoFactory;
import org.palladiosimulator.edp2.dao.MeasurementsDaoRegistry;
import org.palladiosimulator.edp2.dao.exception.DataNotAccessibleException;
import org.palladiosimulator.edp2.models.ExperimentData.DataSeries;
import org.palladiosimulator.edp2.models.ExperimentData.DoubleBinaryMeasurements;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentDataFactory;
import org.palladiosimulator.edp2.models.ExperimentData.FixedIntervals;
import org.palladiosimulator.edp2.models.ExperimentData.FixedWidthAggregatedMeasurements;
import org.palladiosimulator.edp2.models.ExperimentData.IdentifierBasedMeasurements;
import org.palladiosimulator.edp2.models.ExperimentData.JSXmlMeasurements;
import org.palladiosimulator.edp2.models.ExperimentData.LongBinaryMeasurements;
import org.palladiosimulator.edp2.models.ExperimentData.Measurement;
import org.palladiosimulator.edp2.models.ExperimentData.MeasurementRange;
import org.palladiosimulator.edp2.models.ExperimentData.MeasuringType;
import org.palladiosimulator.edp2.models.ExperimentData.RawMeasurements;
import org.palladiosimulator.edp2.models.ExperimentData.util.ExperimentDataSwitch;
import org.palladiosimulator.edp2.models.Repository.Repository;
import org.palladiosimulator.edp2.util.visitors.DAOFromBelowRawMeasurementSwitch;
import org.palladiosimulator.edp2.util.visitors.DataSeriesFromRawMeasurementsSwitch;
import org.palladiosimulator.edp2.util.visitors.EmfmodelAddMeasurementToDataSeriesSwitch;
import org.palladiosimulator.edp2.util.visitors.EmfmodelDataSeriesFromReferenceSwitch;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.MetricSetDescription;
import org.palladiosimulator.metricspec.TextualBaseMetricDescription;

public class MeasurementsUtility {
    public static final String SLIDING_WINDOW_BASED_MEASUREMENT_TAG_KEY = "SLIDING_WINDOW_BASED";
    public static final Boolean SLIDING_WINDOW_BASED_MEASUREMENT_TAG_VALUE = true;
    private static final Logger LOGGER = Logger.getLogger(MeasurementsUtility.class.getCanonicalName());
    private static final ExperimentDataFactory FACTORY = ExperimentDataFactory.eINSTANCE;

    public static MeasurementRange addMeasurementRange(Measurement measurement) {
        MeasurementsDaoFactory daoFactory = measurement.getMeasuringType().getExperimentGroup().getRepository().getMeasurementsDaoFactory();
        MeasurementRange mr = FACTORY.createMeasurementRange(measurement);
        if (measurement.getMeasurementRanges().size() > 1) {
            MeasurementRange template = (MeasurementRange)measurement.getMeasurementRanges().get(0);
            if (template.getRawMeasurements() != null) {
                FACTORY.createRawMeasurements(mr);
            }
            Iterator iter = template.getAggregatedMeasurements().iterator();
            while (iter.hasNext()) {
                FixedWidthAggregatedMeasurements fwam = FACTORY.createFixedWidthAggregatedMeasurements();
                FixedWidthAggregatedMeasurements fwtemplate = (FixedWidthAggregatedMeasurements)iter.next();
                fwam.setIntervals((FixedIntervals)EcoreUtil.copy((EObject)fwtemplate.getIntervals()));
                fwam.setAggregationOn(fwtemplate.getAggregationOn());
                Iterator iter2 = fwtemplate.getDataSeries().iterator();
                while (iter2.hasNext()) {
                    fwam.getDataSeries().add((Object)((DataSeries)new EmfmodelDataSeriesFromReferenceSwitch(daoFactory).doSwitch((EObject)iter2.next())));
                }
            }
        }
        return mr;
    }

    public static void createDAOsForRawMeasurements(RawMeasurements rm) {
        String errorMsg = "Could not create DAOs for raw measurements. A link to the DAO FACTORY was missing: ";
        errorMsg = rm.getMeasurementRange() == null ? "RawMeasurements must be assigned to a measurement range." : (rm.getMeasurementRange().getMeasurement() == null ? "RawMeasurements must be (indirectly) assigned to a measurement." : (rm.getMeasurementRange().getMeasurement().getMeasuringType() == null ? "RawMeasuremnts must be (indirectly) assigned to a measure (definition)." : (rm.getMeasurementRange().getMeasurement().getMeasuringType().getExperimentGroup() == null ? "RawMeasuremnts must be (indirectly) assigned to an experiment group." : (rm.getMeasurementRange().getMeasurement().getMeasuringType().getExperimentGroup().getRepository() == null ? "RawMeasuremnts must be (indirectly) assigned to an experiment group which must be assigned to a repository." : null))));
        if (errorMsg != null) {
            LOGGER.log(Level.SEVERE, errorMsg);
            throw new IllegalArgumentException(errorMsg);
        }
        new DataSeriesFromRawMeasurementsSwitch(rm).doSwitch((EObject)rm.getMeasurementRange().getMeasurement().getMeasuringType().getMetric());
        new DAOFromBelowRawMeasurementSwitch().doSwitch((EObject)rm);
    }

    public static void storeMeasurement(Measurement measurement, MeasuringValue measuringValue) {
        int size = measurement.getMeasurementRanges().size();
        if (size == 0) {
            throw new IllegalArgumentException("Measurements have to include measurements ranges");
        }
        MeasurementRange lastRange = (MeasurementRange)measurement.getMeasurementRanges().get(size - 1);
        RawMeasurements rm = lastRange.getRawMeasurements();
        if (rm != null) {
            if (!measuringValue.getMetricDesciption().getId().equals(measurement.getMeasuringType().getMetric().getId())) {
                String msg = "Tried to store measurement with a wrong metric. Expected: " + measurement.getMeasuringType().getMetric().getName() + ", provided: " + measuringValue.getMetricDesciption().getName() + ".";
                LOGGER.log(Level.SEVERE, msg);
                throw new IllegalArgumentException(msg);
            }
            Iterator iter = rm.getDataSeries().iterator();
            int index = -1;
            MeasurementsDaoRegistry daoRegistry = measurement.getMeasuringType().getExperimentGroup().getRepository().getMeasurementsDaoFactory().getDaoRegistry();
            EmfmodelAddMeasurementToDataSeriesSwitch addMmt = new EmfmodelAddMeasurementToDataSeriesSwitch(daoRegistry);
            while (iter.hasNext()) {
                DataSeries ds = (DataSeries)iter.next();
                addMmt.setMeasurementToAdd((Measure)measuringValue.asList().get(++index));
                addMmt.doSwitch((EObject)ds);
                if (ds.getNumericalStatistics() != null) {
                    ds.setNumericalStatistics(null);
                }
                if (ds.getTextualStatistics() == null) continue;
                ds.setTextualStatistics(null);
            }
        }
    }

    public static <Q extends Quantity> MeasurementsDao<?, Q> getMeasurementsDao(final DataSeries ds) {
        final MeasurementsDaoFactory daoFactory = ds.getRawMeasurements().getMeasurementRange().getMeasurement().getMeasuringType().getExperimentGroup().getRepository().getMeasurementsDaoFactory();
        MeasurementsDao omd = daoFactory.getDaoRegistry().isRegistered(ds.getValuesUuid()) ? daoFactory.getDaoRegistry().getMeasurementsDao(ds.getValuesUuid()) : (MeasurementsDao)new ExperimentDataSwitch<MeasurementsDao<?, Q>>(){

            public MeasurementsDao<?, Q> caseIdentifierBasedMeasurements(IdentifierBasedMeasurements object) {
                BinaryMeasurementsDao bmd = daoFactory.createNominalMeasurementsDao(ds.getValuesUuid(), MeasurementsUtility.getTextualBaseMetricDescriptionFromIdentifierMeasurement(object));
                bmd.setUnit(Unit.ONE);
                return bmd;
            }

            public MeasurementsDao<?, Q> caseJSXmlMeasurements(JSXmlMeasurements object) {
                return daoFactory.createJScienceXmlMeasurementsDao(ds.getValuesUuid());
            }

            public MeasurementsDao<?, Q> caseDoubleBinaryMeasurements(DoubleBinaryMeasurements object) {
                BinaryMeasurementsDao bmd = daoFactory.createDoubleMeasurementsDao(ds.getValuesUuid());
                bmd.setUnit(object.getStorageUnit());
                return bmd;
            }

            public MeasurementsDao<?, Q> caseLongBinaryMeasurements(LongBinaryMeasurements object) {
                BinaryMeasurementsDao bmd = daoFactory.createLongMeasurementsDao(ds.getValuesUuid());
                bmd.setUnit(object.getStorageUnit());
                return bmd;
            }
        }.doSwitch((EObject)ds);
        if (!omd.isOpen() && omd.canOpen()) {
            try {
                omd.open();
            }
            catch (DataNotAccessibleException e) {
                throw new RuntimeException(e);
            }
        }
        return omd;
    }

    public static MeasuringType getMeasuringTypeFromRawMeasurements(RawMeasurements rawMeasurements) {
        return rawMeasurements.getMeasurementRange().getMeasurement().getMeasuringType();
    }

    public static MetricDescription getMetricDescriptionFromRawMeasurements(RawMeasurements rawMeasurements) {
        return MeasurementsUtility.getMeasuringTypeFromRawMeasurements(rawMeasurements).getMetric();
    }

    public static TextualBaseMetricDescription getTextualBaseMetricDescriptionFromIdentifierMeasurement(IdentifierBasedMeasurements idBasedMeasurement) {
        RawMeasurements rawMeasurements = idBasedMeasurement.getRawMeasurements();
        int position = rawMeasurements.getDataSeries().indexOf((Object)idBasedMeasurement);
        MetricDescription metricDescription = MeasurementsUtility.getMetricDescriptionFromRawMeasurements(rawMeasurements);
        if (metricDescription instanceof MetricSetDescription) {
            MetricSetDescription msd = (MetricSetDescription)metricDescription;
            return (TextualBaseMetricDescription)msd.getSubsumedMetrics().get(position);
        }
        return (TextualBaseMetricDescription)metricDescription;
    }

    public static void ensureOpenRepository(Repository repo) throws DataNotAccessibleException {
        if (!repo.isOpen()) {
            repo.open();
        }
        if (!repo.isOpen()) {
            String msg = "Repository could not be opened.";
            LOGGER.severe("Repository could not be opened.");
            throw new DataNotAccessibleException("Repository could not be opened.", null);
        }
    }

    public static void ensureClosedRepository(Repository repo) throws DataNotAccessibleException {
        if (repo.isOpen()) {
            repo.close();
        }
        if (repo.isOpen()) {
            String msg = "Repository could not be closed.";
            LOGGER.severe("Repository could not be closed.");
            throw new DataNotAccessibleException("Repository could not be closed.", null);
        }
    }
}

