/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.util.visitors;

import javax.measure.unit.Unit;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.edp2.dao.MeasurementsDaoFactory;
import org.palladiosimulator.edp2.models.ExperimentData.DataSeries;
import org.palladiosimulator.edp2.models.ExperimentData.DoubleBinaryMeasurements;
import org.palladiosimulator.edp2.models.ExperimentData.IdentifierBasedMeasurements;
import org.palladiosimulator.edp2.models.ExperimentData.JSXmlMeasurements;
import org.palladiosimulator.edp2.models.ExperimentData.LongBinaryMeasurements;
import org.palladiosimulator.edp2.models.ExperimentData.RawMeasurements;
import org.palladiosimulator.edp2.models.ExperimentData.util.ExperimentDataSwitch;
import org.palladiosimulator.edp2.util.MeasurementsUtility;

public class DAOFromBelowRawMeasurementSwitch
extends ExperimentDataSwitch<Boolean> {
    public Boolean caseRawMeasurements(RawMeasurements object) {
        boolean success = true;
        for (DataSeries dataSeries : object.getDataSeries()) {
            success &= ((Boolean)this.doSwitch((EObject)dataSeries)).booleanValue();
        }
        return success;
    }

    public Boolean caseIdentifierBasedMeasurements(IdentifierBasedMeasurements object) {
        MeasurementsDaoFactory daoFactory = this.getMeasurementsDaoFactoryFromMeasurements((DataSeries)object);
        if (daoFactory.createNominalMeasurementsDao(object.getValuesUuid(), MeasurementsUtility.getTextualBaseMetricDescriptionFromIdentifierMeasurement(object), Unit.ONE) != null) {
            return true;
        }
        return false;
    }

    public Boolean caseLongBinaryMeasurements(LongBinaryMeasurements object) {
        MeasurementsDaoFactory daoFactory = this.getMeasurementsDaoFactoryFromMeasurements((DataSeries)object);
        if (daoFactory.createLongMeasurementsDao(object.getValuesUuid(), object.getStorageUnit()) != null) {
            return true;
        }
        return false;
    }

    public Boolean caseDoubleBinaryMeasurements(DoubleBinaryMeasurements object) {
        MeasurementsDaoFactory daoFactory = this.getMeasurementsDaoFactoryFromMeasurements((DataSeries)object);
        if (daoFactory.createDoubleMeasurementsDao(object.getValuesUuid(), object.getStorageUnit()) != null) {
            return true;
        }
        return false;
    }

    public Boolean caseJSXmlMeasurements(JSXmlMeasurements object) {
        MeasurementsDaoFactory daoFactory = this.getMeasurementsDaoFactoryFromMeasurements((DataSeries)object);
        if (daoFactory.createJScienceXmlMeasurementsDao(object.getValuesUuid()) != null) {
            return true;
        }
        return false;
    }

    protected MeasurementsDaoFactory getMeasurementsDaoFactoryFromMeasurements(DataSeries dataSeries) {
        return dataSeries.getRawMeasurements().getMeasurementRange().getMeasurement().getMeasuringType().getExperimentGroup().getRepository().getMeasurementsDaoFactory();
    }
}

