/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.codegen.simucontroller;

import de.uka.ipd.sdq.codegen.simucontroller.dockmodel.DocksModel;
import de.uka.ipd.sdq.codegen.simucontroller.gui.DockStatusViewer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;

public class SimuControllerPlugin
extends AbstractUIPlugin {
    private static final Logger LOGGER = Logger.getLogger(SimuControllerPlugin.class);
    public static final String PLUGIN_ID = "de.uka.ipd.sdq.codegen.simucontroller";
    private static SimuControllerPlugin plugin;
    private static DocksModel dockModel;

    static {
        dockModel = null;
    }

    public SimuControllerPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        context.addBundleListener(new BundleListener(){

            public void bundleChanged(BundleEvent event) {
                event.getType();
            }
        });
        super.start(context);
        this.ensurePluginLoaded(context, "org.eclipse.equinox.event");
        this.ensurePluginLoaded(context, "org.eclipse.equinox.log");
        this.ensurePluginLoaded(context, "ch.ethz.iks.slp");
        this.ensurePluginLoaded(context, "ch.ethz.iks.r_osgi.remote");
        this.ensurePluginLoaded(context, "ch.ethz.iks.r_osgi.service_discovery.slp");
        dockModel = new DocksModel(context);
        try {
            DockStatusViewer.showSimuDockView();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void ensurePluginLoaded(BundleContext context, String bundleName) {
        Bundle[] bundleArray = context.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                Bundle b = bundleArray[n2];
                if (b.getSymbolicName().equals(bundleName) && b.getState() != 32) {
                    try {
                        b.start();
                        while (b.getState() != 32) {
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException e) {
                                if (!LOGGER.isEnabledFor((Priority)Level.WARN)) continue;
                                LOGGER.warn((Object)"Waiting for initalization was aborted unexpectedly.", (Throwable)e);
                            }
                        }
                    }
                    catch (BundleException e) {
                        if (!LOGGER.isEnabledFor((Priority)Level.ERROR)) break block7;
                        LOGGER.error((Object)"Error while starting the OSGI bundle occured.", (Throwable)e);
                    }
                }
            }
            ++n2;
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static SimuControllerPlugin getDefault() {
        return plugin;
    }

    public static void log(int severity, String message) {
        plugin.getLog().log((IStatus)new Status(severity, PLUGIN_ID, message));
    }

    public static DocksModel getDockModel() {
        return dockModel;
    }
}

