/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.codegen.simucontroller.runconfig;

import de.uka.ipd.sdq.codegen.simucontroller.SimuControllerImages;
import de.uka.ipd.sdq.simucomframework.SimuComConfig;
import de.uka.ipd.sdq.workflow.launchconfig.tabs.TabHelper;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTabGroup;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.palladiosimulator.editors.commons.dialogs.selection.PalladioSelectEObjectDialog;
import org.palladiosimulator.pcm.ui.provider.PalladioItemProviderAdapterFactory;
import org.palladiosimulator.pcm.usagemodel.UsageModel;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.pcm.usagemodel.provider.UsagemodelItemProviderAdapterFactory;
import org.palladiosimulator.recorderframework.launch.RecorderTabGroup;
import org.palladiosimulator.recorderframework.utils.RecorderExtensionHelper;

public class SimuComConfigurationTab
extends AbstractLaunchConfigurationTab {
    private static final Logger LOGGER = Logger.getLogger(SimuComConfigurationTab.class);
    private Text nameField;
    private Text variationField;
    private Text timeField;
    private Text maxMeasurementsField;
    private Button checkLoggingButton;
    private Button breakOnInvalidModelsButton;
    private Button useConfidenceCheckBox;
    private Label levelLabel;
    private Text levelField;
    private Label halfWidthLabel;
    private Text halfWidthField;
    private Label selectModelElementLabel;
    private Text selectModelElementField;
    private Button selectModelElementButton;
    private String selectedModelElementName;
    private URI selectedModelElementURI;
    private Button useAutomatedBatchMeansCheckBox;
    private Label batchSizeLabel;
    private Text batchSizeField;
    private Label minNumberOfBatchesLabel;
    private Text minNumberOfBatchesField;
    private Button fixedSeedButton;
    private Text[] seedText;
    private Combo persistenceCombo;
    private final ArrayList<String> modelFiles = new ArrayList();
    private RecorderTabGroup recorderTabGroup;
    protected Composite container;

    public void createControl(Composite parent) {
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SimuComConfigurationTab.this.setDirty(true);
                SimuComConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        };
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout());
        this.setControl((Control)this.container);
        this.createExperimentRunGroup(modifyListener);
        this.createDataSetGroup();
        this.createStopConditionGroup(modifyListener);
        this.createConfidenceStopConditionGroup(modifyListener);
        this.createLoggingGroup();
        this.createModelValidationGroup();
        this.createGeneratorSeedsGroup(modifyListener);
    }

    protected void createExperimentRunGroup(ModifyListener modifyListener) {
        Group experimentrunGroup = new Group(this.container, 0);
        experimentrunGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        experimentrunGroup.setLayout((Layout)gridLayout);
        experimentrunGroup.setText("Experiment Run");
        Label nameLabel = new Label((Composite)experimentrunGroup, 0);
        nameLabel.setText("Experiment Name:");
        this.nameField = new Text((Composite)experimentrunGroup, 2048);
        GridData gd_nameField = new GridData(4, 0x1000000, true, false);
        gd_nameField.widthHint = 70;
        this.nameField.setLayoutData((Object)gd_nameField);
        this.nameField.addModifyListener(modifyListener);
        Label variationLabel = new Label((Composite)experimentrunGroup, 0);
        variationLabel.setText("Variation Name:");
        this.variationField = new Text((Composite)experimentrunGroup, 2048);
        GridData gd_variationField = new GridData(4, 0x1000000, true, false);
        gd_variationField.widthHint = 70;
        this.variationField.setLayoutData((Object)gd_variationField);
        this.variationField.addModifyListener(modifyListener);
    }

    protected void createDataSetGroup() {
        Group persistenceGroup = new Group(this.container, 0);
        persistenceGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        persistenceGroup.setLayout((Layout)new GridLayout(2, false));
        persistenceGroup.setText("Simulation Results");
        Label persistenceLabel = new Label((Composite)persistenceGroup, 0);
        persistenceLabel.setText("Persistence Framework:");
        List recorderNames = RecorderExtensionHelper.getRecorderNames();
        this.persistenceCombo = new Combo((Composite)persistenceGroup, 8);
        this.persistenceCombo.setItems(recorderNames.toArray(new String[recorderNames.size()]));
        this.persistenceCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.persistenceCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimuComConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.recorderTabGroup = new RecorderTabGroup();
        CTabFolder tabFolder = TabHelper.createTabFolder((ILaunchConfigurationTabGroup)this.recorderTabGroup, (ILaunchConfigurationDialog)this.getLaunchConfigurationDialog(), (String)this.getLaunchConfigurationDialog().getMode(), (Composite)persistenceGroup, (int)0x800800);
        tabFolder.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
    }

    protected void createStopConditionGroup(ModifyListener modifyListener) {
        Group stopConditionsGroup = new Group(this.container, 0);
        stopConditionsGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 3;
        stopConditionsGroup.setLayout((Layout)gridLayout_1);
        stopConditionsGroup.setText("Stop Conditions");
        Label timeLabel = new Label((Composite)stopConditionsGroup, 0);
        timeLabel.setText("Maximum simulation time:");
        this.timeField = new Text((Composite)stopConditionsGroup, 2048);
        this.timeField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.timeField.addModifyListener(modifyListener);
        Label secLabel = new Label((Composite)stopConditionsGroup, 0);
        secLabel.setText("Simulated Time Units");
        Label maxLabel = new Label((Composite)stopConditionsGroup, 0);
        maxLabel.setText("Maximum measurements count:");
        this.maxMeasurementsField = new Text((Composite)stopConditionsGroup, 2048);
        this.maxMeasurementsField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.maxMeasurementsField.addModifyListener(modifyListener);
    }

    protected void createConfidenceStopConditionGroup(ModifyListener modifyListener) {
        Group confidenceGroup = new Group(this.container, 0);
        confidenceGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout confidenceLayout = new GridLayout();
        confidenceLayout.numColumns = 3;
        confidenceGroup.setLayout((Layout)confidenceLayout);
        confidenceGroup.setText("Confidence Stop Condition");
        this.useConfidenceCheckBox = new Button((Composite)confidenceGroup, 32);
        this.useConfidenceCheckBox.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.useConfidenceCheckBox.setText("Stop when reaching confidence");
        this.useConfidenceCheckBox.setSelection(false);
        this.useConfidenceCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = SimuComConfigurationTab.this.useConfidenceCheckBox.getSelection();
                SimuComConfigurationTab.this.levelLabel.setEnabled(selected);
                SimuComConfigurationTab.this.levelField.setEnabled(selected);
                SimuComConfigurationTab.this.halfWidthLabel.setEnabled(selected);
                SimuComConfigurationTab.this.halfWidthField.setEnabled(selected);
                SimuComConfigurationTab.this.selectModelElementLabel.setEnabled(selected);
                SimuComConfigurationTab.this.selectModelElementField.setEnabled(selected);
                SimuComConfigurationTab.this.selectModelElementButton.setEnabled(selected);
                SimuComConfigurationTab.this.enableBatchMeansSettings(selected);
                SimuComConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.levelLabel = new Label((Composite)confidenceGroup, 0);
        this.levelLabel.setText("Confidence level (%):");
        this.levelLabel.setEnabled(false);
        this.levelField = new Text((Composite)confidenceGroup, 2048);
        this.levelField.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.levelField.addModifyListener(modifyListener);
        this.levelField.setEnabled(false);
        this.halfWidthLabel = new Label((Composite)confidenceGroup, 0);
        this.halfWidthLabel.setText("Confidence interval half-width (%):");
        this.halfWidthLabel.setEnabled(false);
        this.halfWidthField = new Text((Composite)confidenceGroup, 2048);
        this.halfWidthField.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.halfWidthField.addModifyListener(modifyListener);
        this.halfWidthField.setEnabled(false);
        this.selectModelElementLabel = new Label((Composite)confidenceGroup, 0);
        this.selectModelElementLabel.setText("Monitor Response Time of:");
        this.selectModelElementLabel.setEnabled(false);
        this.selectModelElementField = new Text((Composite)confidenceGroup, 2048);
        this.selectModelElementField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.selectModelElementField.addModifyListener(modifyListener);
        this.selectModelElementField.setEditable(false);
        this.selectModelElementField.setEnabled(false);
        this.selectModelElementButton = new Button((Composite)confidenceGroup, 0);
        this.selectModelElementButton.setText("Select Model Element...");
        this.selectModelElementButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimuComConfigurationTab.this.showSelectModelElementDialog();
            }
        });
        this.useAutomatedBatchMeansCheckBox = new Button((Composite)confidenceGroup, 32);
        this.useAutomatedBatchMeansCheckBox.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.useAutomatedBatchMeansCheckBox.setText("Automatically determine batch size (Beware: Manual batch size can lead to invalid results, only use it care).");
        this.useAutomatedBatchMeansCheckBox.setSelection(false);
        this.useAutomatedBatchMeansCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = SimuComConfigurationTab.this.useAutomatedBatchMeansCheckBox.getSelection();
                SimuComConfigurationTab.this.batchSizeLabel.setEnabled(!selected);
                SimuComConfigurationTab.this.batchSizeField.setEnabled(!selected);
                SimuComConfigurationTab.this.minNumberOfBatchesLabel.setEnabled(!selected);
                SimuComConfigurationTab.this.minNumberOfBatchesField.setEnabled(!selected);
                SimuComConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.batchSizeLabel = new Label((Composite)confidenceGroup, 0);
        this.batchSizeLabel.setText("Batch size:");
        this.batchSizeLabel.setEnabled(false);
        this.batchSizeField = new Text((Composite)confidenceGroup, 2048);
        this.batchSizeField.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.batchSizeField.addModifyListener(modifyListener);
        this.batchSizeField.setEnabled(false);
        this.minNumberOfBatchesLabel = new Label((Composite)confidenceGroup, 0);
        this.minNumberOfBatchesLabel.setText("Minimum number of batches:");
        this.minNumberOfBatchesLabel.setEnabled(false);
        this.minNumberOfBatchesField = new Text((Composite)confidenceGroup, 2048);
        this.minNumberOfBatchesField.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.minNumberOfBatchesField.addModifyListener(modifyListener);
        this.minNumberOfBatchesField.setEnabled(false);
    }

    protected void createLoggingGroup() {
        Group loggingGroup = new Group(this.container, 0);
        loggingGroup.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        loggingGroup.setText("Logging");
        loggingGroup.setLayout((Layout)new GridLayout());
        this.checkLoggingButton = new Button((Composite)loggingGroup, 32);
        this.checkLoggingButton.setText("Enable verbose logging");
        this.checkLoggingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimuComConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.checkLoggingButton.setSelection(false);
    }

    protected void createModelValidationGroup() {
        Group loggingGroup = new Group(this.container, 0);
        loggingGroup.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        loggingGroup.setText("Model validation");
        loggingGroup.setLayout((Layout)new GridLayout());
        this.breakOnInvalidModelsButton = new Button((Composite)loggingGroup, 32);
        this.breakOnInvalidModelsButton.setText("Break on invalid models");
        this.breakOnInvalidModelsButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(it -> this.updateLaunchConfigurationDialog()));
        this.breakOnInvalidModelsButton.setSelection(SimuComConfig.DEFAULT_SHOULD_THROW_EXCEPTION.booleanValue());
    }

    protected void createGeneratorSeedsGroup(ModifyListener modifyListener) {
        Group randomNumberGeneratorParametersGroup = new Group(this.container, 0);
        randomNumberGeneratorParametersGroup.setText("Random Number Generator Seed");
        GridData gd_randomNumberGeneratorParametersGroup = new GridData(4, 0x1000000, true, false);
        randomNumberGeneratorParametersGroup.setLayoutData((Object)gd_randomNumberGeneratorParametersGroup);
        GridLayout gridLayout_3 = new GridLayout();
        gridLayout_3.numColumns = 12;
        randomNumberGeneratorParametersGroup.setLayout((Layout)gridLayout_3);
        this.fixedSeedButton = new Button((Composite)randomNumberGeneratorParametersGroup, 32);
        this.fixedSeedButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 12, 1));
        this.fixedSeedButton.setText("Use a fixed seed in simulation run");
        this.fixedSeedButton.setSelection(false);
        this.fixedSeedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimuComConfigurationTab.this.setDirty(true);
                SimuComConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.seedText = new Text[6];
        Label[] seedLabel = new Label[6];
        int i = 0;
        while (i < 6) {
            seedLabel[i] = new Label((Composite)randomNumberGeneratorParametersGroup, 0);
            seedLabel[i].setText("Seed " + i);
            this.seedText[i] = new Text((Composite)randomNumberGeneratorParametersGroup, 2048);
            this.seedText[i].setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.seedText[i].addModifyListener(modifyListener);
            this.seedText[i].setText(String.valueOf(i));
            ++i;
        }
    }

    private void enableBatchMeansSettings(boolean parentSelected) {
        this.useAutomatedBatchMeansCheckBox.setEnabled(parentSelected);
        this.batchSizeLabel.setEnabled(parentSelected && !this.useAutomatedBatchMeansCheckBox.getSelection());
        this.batchSizeField.setEnabled(parentSelected && !this.useAutomatedBatchMeansCheckBox.getSelection());
        this.minNumberOfBatchesLabel.setEnabled(parentSelected && !this.useAutomatedBatchMeansCheckBox.getSelection());
        this.minNumberOfBatchesField.setEnabled(parentSelected && !this.useAutomatedBatchMeansCheckBox.getSelection());
    }

    private void showSelectModelElementDialog() {
        ResourceSet rs = this.loadModelFiles();
        ArrayList<Class> filter = new ArrayList<Class>();
        filter.add(UsageModel.class);
        filter.add(UsageScenario.class);
        PalladioSelectEObjectDialog dialog = new PalladioSelectEObjectDialog(this.getShell(), filter, (Object)rs);
        if (dialog.open() == 0) {
            EObject modelElement = dialog.getResult();
            if (modelElement instanceof UsageScenario) {
                UsageScenario usageScenario = (UsageScenario)modelElement;
                this.selectedModelElementURI = EcoreUtil.getURI((EObject)modelElement);
                this.selectedModelElementName = usageScenario.getEntityName();
                this.updateModelElementField(usageScenario);
            } else {
                MessageBox warningBox = new MessageBox(this.selectModelElementField.getShell(), 40);
                warningBox.setText("Warning");
                warningBox.setMessage("No response times will be available for the selected model element. Please select a suitable model element.");
                warningBox.open();
            }
        }
    }

    private void updateModelElementField(UsageScenario modelElement) {
        AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)new PalladioItemProviderAdapterFactory((AdapterFactory)new UsagemodelItemProviderAdapterFactory()));
        this.selectModelElementField.setText(labelProvider.getText((Object)modelElement));
    }

    public String getName() {
        return "Simulation";
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        block36: {
            this.recorderTabGroup.initializeFrom(configuration);
            try {
                this.nameField.setText(configuration.getAttribute("experimentRun", ""));
            }
            catch (CoreException coreException) {
                this.nameField.setText("MyRun");
            }
            try {
                this.variationField.setText(configuration.getAttribute("variationId", ""));
            }
            catch (CoreException coreException) {
                this.variationField.setText("Default Variation");
            }
            try {
                this.timeField.setText(configuration.getAttribute("simTime", ""));
            }
            catch (CoreException coreException) {
                this.timeField.setText("150000");
            }
            try {
                this.maxMeasurementsField.setText(configuration.getAttribute("maximumMeasurementCount", ""));
            }
            catch (CoreException coreException) {
                this.maxMeasurementsField.setText("10000");
            }
            try {
                String persistenceFrameworkName = configuration.getAttribute("persistenceFramework", "");
                String[] items = this.persistenceCombo.getItems();
                int i = 0;
                while (i < items.length) {
                    String str = items[i];
                    if (str.equals(persistenceFrameworkName)) {
                        this.persistenceCombo.select(i);
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                if (!LOGGER.isEnabledFor((Priority)Level.WARN)) break block36;
                LOGGER.warn((Object)"Could not access persistency recorder name.", (Throwable)e);
            }
        }
        try {
            this.checkLoggingButton.setSelection(configuration.getAttribute("verboseLogging", false));
        }
        catch (CoreException coreException) {
            this.checkLoggingButton.setSelection(false);
        }
        try {
            this.breakOnInvalidModelsButton.setSelection(configuration.getAttribute("shouldThrowException", SimuComConfig.DEFAULT_SHOULD_THROW_EXCEPTION.booleanValue()));
        }
        catch (CoreException coreException) {
            this.breakOnInvalidModelsButton.setSelection(SimuComConfig.DEFAULT_SHOULD_THROW_EXCEPTION.booleanValue());
        }
        try {
            this.levelField.setText(configuration.getAttribute("confidenceLevel", "95"));
        }
        catch (CoreException coreException) {
            this.levelField.setText("" + SimuComConfig.DEFAULT_CONFIDENCE_LEVEL);
        }
        try {
            this.halfWidthField.setText(configuration.getAttribute("confidenceHalfWidth", "10"));
        }
        catch (CoreException coreException) {
            this.halfWidthField.setText("" + SimuComConfig.DEFAULT_CONFIDENCE_HALFWIDTH);
        }
        String defaultBatchSize = "" + SimuComConfig.DEFAULT_CONFIDENCE_BATCH_SIZE;
        try {
            this.batchSizeField.setText(configuration.getAttribute("confidenceBatchSize", defaultBatchSize));
        }
        catch (CoreException coreException) {
            this.batchSizeField.setText(defaultBatchSize);
        }
        String defaultMinNumberOfBatches = "" + SimuComConfig.DEFAULT_CONFIDENCE_MIN_NUMBER_OF_BATCHES;
        try {
            this.minNumberOfBatchesField.setText(configuration.getAttribute("confidenceMinNumberOfBatches", defaultMinNumberOfBatches));
        }
        catch (CoreException coreException) {
            this.minNumberOfBatchesField.setText(defaultMinNumberOfBatches);
        }
        try {
            String usageFile = configuration.getAttribute("usageFile", "");
            this.modelFiles.clear();
            if (!usageFile.isEmpty()) {
                this.modelFiles.add(usageFile);
            }
        }
        catch (CoreException coreException) {}
        try {
            this.selectedModelElementURI = URI.createURI((String)configuration.getAttribute("confidenceModelElementURI", ""));
            UsageScenario usageScenario = this.getUsageScenarioFromURI(this.selectedModelElementURI);
            this.selectedModelElementName = usageScenario.getEntityName();
            this.updateModelElementField(usageScenario);
        }
        catch (Exception exception) {
            this.selectedModelElementURI = null;
            this.selectedModelElementName = "";
            this.selectModelElementField.setText("");
        }
        try {
            boolean isAutomaticBatches = configuration.getAttribute("confidenceUseAutomaticBatches", false);
            this.useAutomatedBatchMeansCheckBox.setSelection(isAutomaticBatches);
            boolean select = configuration.getAttribute("useConfidenceStopCondition", false);
            this.useConfidenceCheckBox.setSelection(select);
            this.levelLabel.setEnabled(select);
            this.levelField.setEnabled(select);
            this.halfWidthLabel.setEnabled(select);
            this.halfWidthField.setEnabled(select);
            this.selectModelElementLabel.setEnabled(select);
            this.selectModelElementField.setEnabled(select);
            this.selectModelElementButton.setEnabled(select);
            this.enableBatchMeansSettings(select);
        }
        catch (CoreException coreException) {
            this.useConfidenceCheckBox.setSelection(false);
            this.levelLabel.setEnabled(false);
            this.levelField.setEnabled(false);
            this.halfWidthLabel.setEnabled(false);
            this.halfWidthField.setEnabled(false);
            this.selectModelElementLabel.setEnabled(false);
            this.selectModelElementField.setEnabled(false);
            this.selectModelElementButton.setEnabled(false);
            this.enableBatchMeansSettings(false);
        }
        try {
            this.fixedSeedButton.setSelection(configuration.getAttribute("useFixedSeed", false));
        }
        catch (CoreException coreException) {
            this.fixedSeedButton.setSelection(false);
        }
        int i = 0;
        while (i < 6) {
            try {
                this.seedText[i].setText(configuration.getAttribute("fixedSeed" + i, String.valueOf(i)));
            }
            catch (CoreException coreException) {
                this.seedText[i].setText(String.valueOf(i));
            }
            ++i;
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.recorderTabGroup.performApply(configuration);
        configuration.setAttribute("experimentRun", this.nameField.getText());
        configuration.setAttribute("variationId", this.variationField.getText());
        configuration.setAttribute("simTime", this.timeField.getText());
        configuration.setAttribute("maximumMeasurementCount", this.maxMeasurementsField.getText());
        configuration.setAttribute("persistenceFramework", this.persistenceCombo.getText());
        configuration.setAttribute("verboseLogging", this.checkLoggingButton.getSelection());
        configuration.setAttribute("useConfidenceStopCondition", this.useConfidenceCheckBox.getSelection());
        configuration.setAttribute("confidenceLevel", this.levelField.getText());
        configuration.setAttribute("confidenceHalfWidth", this.halfWidthField.getText());
        configuration.setAttribute("confidenceModelElementName", this.selectedModelElementName);
        configuration.setAttribute("useFixedSeed", this.fixedSeedButton.getSelection());
        int i = 0;
        while (i < 6) {
            configuration.setAttribute("fixedSeed" + i, this.seedText[i].getText());
            ++i;
        }
        if (this.selectedModelElementURI != null) {
            configuration.setAttribute("confidenceModelElementURI", this.selectedModelElementURI.toString());
        } else {
            configuration.setAttribute("confidenceModelElementURI", "");
        }
        configuration.setAttribute("confidenceUseAutomaticBatches", this.useAutomatedBatchMeansCheckBox.getSelection());
        configuration.setAttribute("confidenceBatchSize", this.batchSizeField.getText());
        configuration.setAttribute("confidenceMinNumberOfBatches", this.minNumberOfBatchesField.getText());
        configuration.setAttribute("shouldThrowException", this.breakOnInvalidModelsButton.getSelection());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        if (this.recorderTabGroup != null) {
            this.recorderTabGroup.setDefaults(configuration);
        }
        configuration.setAttribute("simulatorId", "de.uka.ipd.sdq.codegen.simucontroller.simucom");
        configuration.setAttribute("experimentRun", "MyRun");
        configuration.setAttribute("variationId", "Default Variation");
        configuration.setAttribute("simTime", "150000");
        configuration.setAttribute("maximumMeasurementCount", "10000");
        configuration.setAttribute("persistenceFramework", "");
        configuration.setAttribute("useConfidenceStopCondition", (Object)SimuComConfig.DEFAULT_USE_CONFIDENCE);
        configuration.setAttribute("confidenceLevel", (Object)SimuComConfig.DEFAULT_CONFIDENCE_LEVEL);
        configuration.setAttribute("confidenceHalfWidth", (Object)SimuComConfig.DEFAULT_CONFIDENCE_HALFWIDTH);
        configuration.setAttribute("confidenceModelElementName", "");
        configuration.setAttribute("confidenceModelElementURI", "");
        configuration.setAttribute("confidenceUseAutomaticBatches", (Object)SimuComConfig.DEFAULT_CONFIDENCE_USE_AUTOMATIC_BATCHES);
        configuration.setAttribute("confidenceBatchSize", (Object)SimuComConfig.DEFAULT_CONFIDENCE_BATCH_SIZE);
        configuration.setAttribute("confidenceMinNumberOfBatches", (Object)SimuComConfig.DEFAULT_CONFIDENCE_MIN_NUMBER_OF_BATCHES);
        configuration.setAttribute("shouldThrowException", (Object)SimuComConfig.DEFAULT_SHOULD_THROW_EXCEPTION);
        List recorderNames = RecorderExtensionHelper.getRecorderNames();
        if (recorderNames.size() > 0) {
            configuration.setAttribute("persistenceFramework", (String)recorderNames.get(0));
        }
    }

    public Image getImage() {
        return SimuControllerImages.imageRegistry.get("simucom_conf");
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        ILaunchConfigurationTab[] recorderTabs;
        this.setErrorMessage(null);
        if (this.nameField.getText().equals("")) {
            this.setErrorMessage("ExperimentRun name is missing!");
            return false;
        }
        if (this.timeField.getText().equals("")) {
            this.setErrorMessage("Simulation time is missing!");
            return false;
        }
        if (this.maxMeasurementsField.getText().equals("")) {
            this.setErrorMessage("Maximum Measurement counter is missing!");
            return false;
        }
        String persistenceFrameworkName = this.persistenceCombo.getText();
        if (persistenceFrameworkName == null || persistenceFrameworkName.isEmpty()) {
            this.setErrorMessage("Persistence Framework is missing!");
            return false;
        }
        ILaunchConfigurationTab[] iLaunchConfigurationTabArray = recorderTabs = this.recorderTabGroup.getTabs();
        int n = recorderTabs.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfigurationTab tab = iLaunchConfigurationTabArray[n2];
            if (persistenceFrameworkName.contains(tab.getName()) && !tab.isValid(launchConfig)) {
                this.setErrorMessage(String.valueOf(persistenceFrameworkName) + ": " + tab.getErrorMessage());
                return false;
            }
            ++n2;
        }
        if (this.useConfidenceCheckBox.getSelection() && "".equals(this.levelField.getText())) {
            this.setErrorMessage("Confidence level is missing!");
            return false;
        }
        if (this.useConfidenceCheckBox.getSelection() && "".equals(this.halfWidthField.getText())) {
            this.setErrorMessage("Confidence interval half-width is missing!");
            return false;
        }
        if (this.useConfidenceCheckBox.getSelection() && "".equals(this.selectModelElementField.getText())) {
            this.setErrorMessage("Specify the usage scenario for which the confidence interval should be determined.");
            return false;
        }
        if (this.useConfidenceCheckBox.getSelection() && !"".equals(this.levelField.getText())) {
            try {
                double level = Double.parseDouble(this.levelField.getText());
                if (level < 0.0 || level > 100.0) {
                    this.setErrorMessage("Confidence level has to be a percentage!");
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage("Confidence level has to be an number!");
                return false;
            }
        }
        if (this.useConfidenceCheckBox.getSelection() && this.halfWidthField.getText().equals("")) {
            this.setErrorMessage("Confidence interval half-width is missing!");
            return false;
        }
        if (this.useConfidenceCheckBox.getSelection() && this.halfWidthField.getText().length() > 0) {
            try {
                int halfWidth = Integer.parseInt(this.halfWidthField.getText());
                if (halfWidth < 0 || halfWidth > 100) {
                    this.setErrorMessage("Half-width has to be a percentage!");
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage("Half-width has to be an integer!");
                return false;
            }
        }
        if (this.useConfidenceCheckBox.getSelection() && this.selectedModelElementURI == null) {
            this.setErrorMessage("Select a model element whose response times are to be monitored!");
        }
        if (this.useConfidenceCheckBox.getSelection() && !this.useAutomatedBatchMeansCheckBox.getSelection()) {
            if ("".equals(this.batchSizeField.getText())) {
                this.setErrorMessage("Batch size has to be specified if not determined automatically.");
                return false;
            }
            if ("".equals(this.minNumberOfBatchesField.getText())) {
                this.setErrorMessage("Minimum number of batches have to be specified if not determined automatically.");
                return false;
            }
            try {
                Integer.parseInt(this.batchSizeField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage("Batch size has to be an integer!");
                return false;
            }
            try {
                Integer.parseInt(this.minNumberOfBatchesField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage("Minimum number of batches has to be an integer!");
                return false;
            }
        }
        return true;
    }

    public void activated(ILaunchConfigurationWorkingCopy configuration) {
        try {
            String usageFile = configuration.getAttribute("usageFile", "");
            if (!usageFile.isEmpty() && !this.modelFiles.contains(usageFile)) {
                this.modelFiles.clear();
                this.modelFiles.add(usageFile);
                this.selectedModelElementURI = URI.createURI((String)configuration.getAttribute("confidenceModelElementURI", ""));
                UsageScenario usageScenario = this.getUsageScenarioFromURI(this.selectedModelElementURI);
                this.selectedModelElementName = usageScenario.getEntityName();
                this.updateModelElementField(usageScenario);
            }
        }
        catch (Exception exception) {
            this.selectedModelElementURI = null;
            this.selectedModelElementName = "";
            this.selectModelElementField.setText("");
        }
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    private ResourceSet loadModelFiles() {
        ResourceSetImpl rs = new ResourceSetImpl();
        for (String file : this.modelFiles) {
            try {
                rs.getResource(URI.createURI((String)file), true);
            }
            catch (Exception exception) {
                try {
                    rs.getResource(URI.createFileURI((String)file), true);
                }
                catch (Exception exception2) {}
            }
        }
        EcoreUtil.resolveAll((ResourceSet)rs);
        return rs;
    }

    private UsageScenario getUsageScenarioFromURI(URI selectedModelElementURI) throws Exception {
        ResourceSet rs = this.loadModelFiles();
        EObject selectedModelElement = rs.getEObject(selectedModelElementURI, false);
        if (selectedModelElement != null && selectedModelElement instanceof UsageScenario) {
            return (UsageScenario)selectedModelElement;
        }
        throw new RuntimeException("selectedModelElement is null or of wrong type");
    }
}

