/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.codegen.simucontroller.workflow.jobs;

import de.uka.ipd.sdq.codegen.simucontroller.debug.IDebugListener;
import de.uka.ipd.sdq.codegen.simucontroller.runconfig.AbstractSimulationWorkflowConfiguration;
import de.uka.ipd.sdq.codegen.simucontroller.workflow.jobs.TransformPCMForSensitivityAnalysisJob;
import de.uka.ipd.sdq.codegen.simucontroller.workflow.jobs.WorkflowHooks;
import de.uka.ipd.sdq.pcm.transformations.ApplyConnectorCompletionsJob;
import de.uka.ipd.sdq.workflow.extension.AbstractExtendableJob;
import de.uka.ipd.sdq.workflow.extension.ExtendableJobConfiguration;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import org.eclipse.core.runtime.CoreException;
import org.palladiosimulator.analyzer.accuracy.jobs.TransformPCMForAccuracyInfluenceAnalysisJob;
import org.palladiosimulator.analyzer.workflow.jobs.CreatePluginProjectJob;
import org.palladiosimulator.analyzer.workflow.jobs.CreateWorkingCopyOfModelsJob;
import org.palladiosimulator.analyzer.workflow.jobs.EventsTransformationJob;
import org.palladiosimulator.analyzer.workflow.jobs.LoadMiddlewareConfigurationIntoBlackboardJob;
import org.palladiosimulator.analyzer.workflow.jobs.LoadPCMModelsIntoBlackboardJob;
import org.palladiosimulator.analyzer.workflow.jobs.StoreAllPCMModelsJob;
import org.palladiosimulator.analyzer.workflow.jobs.ValidatePCMModelsJob;

public abstract class AbstractSimulationJob<C extends AbstractSimulationWorkflowConfiguration>
extends AbstractExtendableJob<MDSDBlackboard> {
    protected IDebugListener debugListener = null;

    public AbstractSimulationJob(C configuration, IDebugListener listener) throws CoreException {
        this(configuration, listener, true);
    }

    public AbstractSimulationJob(C configuration) throws CoreException {
        this(configuration, null);
    }

    public AbstractSimulationJob(C configuration, IDebugListener listener, boolean loadModels) throws CoreException {
        super(false);
        if (listener == null && configuration.isDebug()) {
            throw new IllegalArgumentException("Debug listener has to be non-null for debug runs");
        }
        this.debugListener = listener;
        this.add((IJob)new CreatePluginProjectJob(configuration));
        if (loadModels) {
            this.addJob((IJob)new LoadPCMModelsIntoBlackboardJob(configuration));
            this.addJob((IJob)new LoadMiddlewareConfigurationIntoBlackboardJob(configuration));
        }
        this.add((IJob)new CreateWorkingCopyOfModelsJob(configuration));
        this.addJob((IJob)new ValidatePCMModelsJob(configuration));
        this.handleJobExtensions(WorkflowHooks.WORKFLOW_ID_AFTER_LOAD_VALIDATE, (ExtendableJobConfiguration)configuration);
        if (configuration.isAccuracyInfluenceAnalysisEnabled()) {
            this.add((IJob)new TransformPCMForAccuracyInfluenceAnalysisJob(configuration));
        }
        if (configuration.isSensitivityAnalysisEnabled()) {
            this.add((IJob)new TransformPCMForSensitivityAnalysisJob((AbstractSimulationWorkflowConfiguration)configuration));
        }
        this.add((IJob)new EventsTransformationJob(configuration.getStoragePluginID(), configuration.getEventMiddlewareFile(), false));
        if (((AbstractSimulationWorkflowConfiguration)configuration).getSimulateLinkingResources()) {
            this.addJob((IJob)new ApplyConnectorCompletionsJob((AbstractSimulationWorkflowConfiguration)configuration));
        }
        this.add((IJob)new StoreAllPCMModelsJob(configuration));
        this.addSimulatorSpecificJobs(configuration);
    }

    protected abstract void addSimulatorSpecificJobs(C var1);
}

