/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.codegen.simucontroller.workflow.jobs;

import de.uka.ipd.sdq.codegen.simucontroller.SimuControllerPlugin;
import de.uka.ipd.sdq.codegen.simucontroller.debug.IDebugListener;
import de.uka.ipd.sdq.codegen.simucontroller.dockmodel.DockModel;
import de.uka.ipd.sdq.codegen.simucontroller.runconfig.AbstractSimulationWorkflowConfiguration;
import de.uka.ipd.sdq.codegen.simucontroller.workflow.jobs.AbstractSimuComExtensionJob;
import de.uka.ipd.sdq.codegen.simucontroller.workflow.jobs.BuildPluginJarJob;
import de.uka.ipd.sdq.codegen.simucontroller.workflow.jobs.WorkflowHooks;
import de.uka.ipd.sdq.simucomframework.simulationdock.SimulationDockService;
import de.uka.ipd.sdq.simucomframework.simulationdock.SimulationDockServiceImpl;
import de.uka.ipd.sdq.workflow.extension.AbstractExtendableJob;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import org.eclipse.core.runtime.IProgressMonitor;
import org.palladiosimulator.analyzer.workflow.configurations.AbstractPCMWorkflowRunConfiguration;

public class TransferSimulationBundleToDock
extends AbstractExtendableJob<MDSDBlackboard> {
    private BuildPluginJarJob myCreatePluginProjectJob;
    private AbstractSimulationWorkflowConfiguration myConfig;
    private boolean isDebug;
    private IDebugListener debugListener;

    public TransferSimulationBundleToDock(AbstractSimulationWorkflowConfiguration configuration, IDebugListener debugListener, BuildPluginJarJob createPluginJarJob) {
        this.myCreatePluginProjectJob = createPluginJarJob;
        this.myConfig = configuration;
        this.debugListener = debugListener;
        this.isDebug = configuration.isDebug();
        if (this.isSimuComSimulationRun()) {
            this.handleJobExtensions(WorkflowHooks.WORKFLOW_ID_AFTER_DOCK, configuration);
        }
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        assert (this.myCreatePluginProjectJob != null);
        try {
            try {
                DockModel dock = SimuControllerPlugin.getDockModel().getBestFreeDock();
                SimulationDockService simService = dock.getService();
                if (this.isDebug) {
                    this.debugListener.simulationStartsInDock(dock);
                }
                simService.load(this.myConfig.getSimulationConfiguration(), this.myCreatePluginProjectJob.getResult(), dock.isRemote());
                for (IJob extensionJob : this.myJobs) {
                    if (!this.isSimuComSimulationRun() || !(extensionJob instanceof AbstractSimuComExtensionJob)) continue;
                    ((AbstractSimuComExtensionJob)extensionJob).setSimuComModel(((SimulationDockServiceImpl)simService).getSimuComModel());
                    ((AbstractSimuComExtensionJob)extensionJob).initialize(this.myConfig);
                    ((AbstractSimuComExtensionJob)extensionJob).setConfiguration((AbstractPCMWorkflowRunConfiguration)this.myConfig);
                }
                super.execute(monitor);
                simService.simulate(this.myConfig.getSimulationConfiguration(), this.myCreatePluginProjectJob.getResult(), dock.isRemote());
            }
            catch (InterruptedException e) {
                throw new JobFailedException("Job failed while waiting for a dock to become available", (Throwable)e);
            }
            catch (Exception e) {
                throw new JobFailedException("Simulation run failed.", (Throwable)e);
            }
        }
        finally {
            if (this.isDebug) {
                this.debugListener.simulationStoppedInDock();
            }
        }
    }

    private boolean isSimuComSimulationRun() {
        return this.myConfig.getSimulationConfiguration().getSimulatorId().equals("de.uka.ipd.sdq.codegen.simucontroller.simucom");
    }

    public String getName() {
        return "Transfer Plugin to Dock and Simulate";
    }
}

