/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.codegen.simucontroller.workflow.jobs;

import de.uka.ipd.sdq.workflow.jobs.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.SequentialBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import de.uka.ipd.sdq.workflow.mdsd.oaw.XpandGeneratorJob;
import java.util.HashMap;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xpand2.output.Outlet;
import org.eclipse.xtend.expression.AbstractExpressionsUsingWorkflowComponent;
import org.palladiosimulator.analyzer.quality.QualityPackage;
import org.palladiosimulator.analyzer.quality.parameters.ParametersPackage;
import org.palladiosimulator.analyzer.quality.parameters.pcm.PCMPackage;
import org.palladiosimulator.analyzer.quality.qualityannotation.QualityAnnotationPackage;
import org.palladiosimulator.analyzer.workflow.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.analyzer.workflow.configurations.AbstractCodeGenerationWorkflowRunConfiguration;
import org.palladiosimulator.analyzer.workflow.configurations.AbstractPCMWorkflowRunConfiguration;

public class TransformPCMToCodeJob
extends SequentialBlackboardInteractingJob<MDSDBlackboard>
implements IJob,
IBlackboardInteractingJob<MDSDBlackboard> {
    private static final String REPOSITORY_ROOT_EXPAND_EXPRESSION = "m2t_transforms::repository::Root FOR pcmmodel";
    private static final String SYSTEM_ROOT_EXPAND_EXPRESSION = "m2t_transforms::system::Root FOR system";
    private static final String ALLOCATION_ROOT_EXPAND_EXPRESSION = "m2t_transforms::allocation::AllocationTM FOR allocation";
    private static final String USAGE_ROOT_EXPAND_EXPRESSION = "m2t_transforms::usage::UsageModel(allocation) FOR usage";
    private static final String GLOBAL_VARIABLE_NAME_QUALITY_ANNOTATION_REPOSITORY = "qualityAnnotationRepository";
    private static final String SLOT_NAME_QUALITY_ANNOTATION_MODEL = "qualityannotationmodel";
    private AbstractCodeGenerationWorkflowRunConfiguration configuration = null;

    public TransformPCMToCodeJob(AbstractCodeGenerationWorkflowRunConfiguration configuration) {
        this.configuration = configuration;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        AbstractExpressionsUsingWorkflowComponent.GlobalVarDef[] globalVars = new AbstractExpressionsUsingWorkflowComponent.GlobalVarDef[]{new AbstractExpressionsUsingWorkflowComponent.GlobalVarDef()};
        globalVars[0].setName(GLOBAL_VARIABLE_NAME_QUALITY_ANNOTATION_REPOSITORY);
        if (this.configuration.isAccuracyInfluenceAnalysisEnabled()) {
            globalVars[0].setValue(SLOT_NAME_QUALITY_ANNOTATION_MODEL);
        } else {
            globalVars[0].setValue("null");
        }
        int repositoryIndex = 0;
        while (repositoryIndex < this.getRepositoryCount()) {
            this.addJob((IJob)this.getGeneratorJob(this.getRepositoryTransformationSlots(repositoryIndex), REPOSITORY_ROOT_EXPAND_EXPRESSION, globalVars));
            ++repositoryIndex;
        }
        if (this.configuration.isLoadMiddlewareAndCompletionFiles()) {
            this.addJob((IJob)this.getGeneratorJob(this.getMiddlewareRepositorySlots(), REPOSITORY_ROOT_EXPAND_EXPRESSION));
            this.addJob((IJob)this.getGeneratorJob(this.getCompletionRepositorySlots(), REPOSITORY_ROOT_EXPAND_EXPRESSION));
        }
        this.addJob((IJob)this.getGeneratorJob(this.getSystemTransformationSlots(), SYSTEM_ROOT_EXPAND_EXPRESSION));
        this.addJob((IJob)this.getGeneratorJob(this.getSystemTransformationSlots(), ALLOCATION_ROOT_EXPAND_EXPRESSION));
        this.addJob((IJob)this.getGeneratorJob(this.getSystemTransformationSlots(), USAGE_ROOT_EXPAND_EXPRESSION));
        super.execute(monitor);
    }

    private HashMap<String, Object> getCompletionRepositorySlots() {
        HashMap<String, Object> sC2 = new HashMap<String, Object>();
        ResourceSetPartition completionRepositoryPartition = (ResourceSetPartition)((MDSDBlackboard)this.myBlackboard).getPartition("de.uka.ipd.sdq.pcm.completionRepositoryPartition");
        sC2.put("pcmmodel", ((Resource)completionRepositoryPartition.getResourceSet().getResources().get(0)).getContents().get(0));
        return sC2;
    }

    private HashMap<String, Object> getMiddlewareRepositorySlots() {
        HashMap<String, Object> sC2 = new HashMap<String, Object>();
        ResourceSetPartition mwRepositoryPartition = (ResourceSetPartition)((MDSDBlackboard)this.myBlackboard).getPartition("de.uka.ipd.sdq.pcmmodels.partition.rmimiddleware");
        sC2.put("pcmmodel", ((Resource)mwRepositoryPartition.getResourceSet().getResources().get(0)).getContents().get(0));
        return sC2;
    }

    private XpandGeneratorJob getGeneratorJob(HashMap<String, Object> slots, String expression, AbstractExpressionsUsingWorkflowComponent.GlobalVarDef[] globalVarDefs) {
        EPackage[] pcmAndAccuracyPackages = new EPackage[AbstractPCMWorkflowRunConfiguration.PCM_EPACKAGES.length + 3];
        System.arraycopy(AbstractPCMWorkflowRunConfiguration.PCM_EPACKAGES, 0, pcmAndAccuracyPackages, 0, AbstractPCMWorkflowRunConfiguration.PCM_EPACKAGES.length);
        pcmAndAccuracyPackages[pcmAndAccuracyPackages.length - 4] = QualityPackage.eINSTANCE;
        pcmAndAccuracyPackages[pcmAndAccuracyPackages.length - 3] = QualityAnnotationPackage.eINSTANCE;
        pcmAndAccuracyPackages[pcmAndAccuracyPackages.length - 2] = ParametersPackage.eINSTANCE;
        pcmAndAccuracyPackages[pcmAndAccuracyPackages.length - 1] = PCMPackage.eINSTANCE;
        XpandGeneratorJob job = new XpandGeneratorJob(slots, pcmAndAccuracyPackages, this.getPCMOutlets(), expression, globalVarDefs);
        job.getAdvices().add(this.configuration.getCodeGenerationAdvicesFile());
        for (String advice : this.configuration.getCodeGenerationAdvices()) {
            job.getAdvices().add(advice);
        }
        job.setCheckProtectedRegions(true);
        return job;
    }

    private XpandGeneratorJob getGeneratorJob(HashMap<String, Object> slots, String expression) {
        return this.getGeneratorJob(slots, expression, null);
    }

    private Outlet[] getPCMOutlets() {
        Outlet defaultOutlet = new Outlet(this.getBasePath());
        Outlet interfaces = new Outlet(this.getBasePath());
        interfaces.setName("INTERFACES");
        return new Outlet[]{defaultOutlet, interfaces};
    }

    private HashMap<String, Object> getSystemTransformationSlots() {
        HashMap<String, Object> sC2 = new HashMap<String, Object>();
        PCMResourceSetPartition pcmPartition = (PCMResourceSetPartition)((MDSDBlackboard)this.myBlackboard).getPartition("org.palladiosimulator.pcmmodels.partition");
        sC2.put("middleware", pcmPartition.getMiddlewareRepository());
        if (this.configuration.isLoadMiddlewareAndCompletionFiles()) {
            sC2.put("featureConfig", pcmPartition.getFeatureConfig());
        }
        sC2.put("system", pcmPartition.getSystem());
        sC2.put("allocation", pcmPartition.getAllocation());
        sC2.put("usage", pcmPartition.getUsageModel());
        return sC2;
    }

    private HashMap<String, Object> getRepositoryTransformationSlots(int repositoryIndex) {
        HashMap<String, Object> sC2 = new HashMap<String, Object>();
        PCMResourceSetPartition pcmPartition = (PCMResourceSetPartition)((MDSDBlackboard)this.myBlackboard).getPartition("org.palladiosimulator.pcmmodels.partition");
        sC2.put("pcmmodel", pcmPartition.getRepositories().get(repositoryIndex));
        if (this.configuration.isAccuracyInfluenceAnalysisEnabled()) {
            sC2.put(SLOT_NAME_QUALITY_ANNOTATION_MODEL, pcmPartition.getElement(QualityPackage.eINSTANCE.getQualityRepository()).get(0));
        }
        return sC2;
    }

    private int getRepositoryCount() {
        PCMResourceSetPartition pcmPartition = (PCMResourceSetPartition)((MDSDBlackboard)this.myBlackboard).getPartition("org.palladiosimulator.pcmmodels.partition");
        return pcmPartition.getRepositories().size();
    }

    private String getBasePath() {
        String basePath = String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString()) + "/" + this.configuration.getStoragePluginID() + "/" + "src";
        return basePath;
    }

    public String getName() {
        return "Generate SimuCom Plugin Code";
    }
}

