/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.pcm.transformations;

import com.google.common.collect.Streams;
import de.uka.ipd.sdq.codegen.simucontroller.runconfig.AbstractSimulationWorkflowConfiguration;
import de.uka.ipd.sdq.featureconfig.Configuration;
import de.uka.ipd.sdq.pcm.transformations.builder.IBuilder;
import de.uka.ipd.sdq.pcm.transformations.builder.connectors.ConnectorReplacingBuilder;
import de.uka.ipd.sdq.pcm.transformations.builder.util.PCMAndCompletionModelHolder;
import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import java.io.IOException;
import java.util.Iterator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.resource.Resource;
import org.palladiosimulator.analyzer.workflow.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.analyzer.workflow.jobs.CreatePluginProjectJob;
import org.palladiosimulator.pcm.allocation.AllocationContext;
import org.palladiosimulator.pcm.allocation.AllocationFactory;
import org.palladiosimulator.pcm.core.composition.AssemblyConnector;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.CompositionFactory;
import org.palladiosimulator.pcm.core.composition.CompositionPackage;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.repository.RepositoryFactory;
import org.palladiosimulator.pcm.repository.RepositoryPackage;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourceenvironment.ResourceenvironmentPackage;

public class ApplyConnectorCompletionsJob
implements IBlackboardInteractingJob<MDSDBlackboard> {
    private static final Logger LOGGER = Logger.getLogger(ApplyConnectorCompletionsJob.class);
    public static final String COMPLETION_REPOSITORY_PARTITION = "de.uka.ipd.sdq.pcm.completionRepositoryPartition";
    private static final String COMPLETIONS_FOLDER = "model/connector-completion";
    protected MDSDBlackboard blackboard;
    private final AbstractSimulationWorkflowConfiguration configuration;

    public ApplyConnectorCompletionsJob(AbstractSimulationWorkflowConfiguration configuration) {
        this.configuration = configuration;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        PCMResourceSetPartition pcmModels = (PCMResourceSetPartition)this.blackboard.getPartition("org.palladiosimulator.pcmmodels.partition");
        if (LOGGER.isEnabledFor((Priority)Level.INFO)) {
            LOGGER.info((Object)"Create completion repository...");
        }
        Repository middlewareRepo = this.getMiddlewareRepository();
        ResourceSetPartition completionsRepositoryPartition = this.getPartitionForCompletedMiddleware();
        Repository completionRepository = this.createCompletionRepository(completionsRepositoryPartition, middlewareRepo);
        PCMAndCompletionModelHolder models = new PCMAndCompletionModelHolder(pcmModels.getResourceTypeRepository(), null, pcmModels.getSystem(), pcmModels.getAllocation(), null, completionRepository, middlewareRepo);
        Streams.stream((Iterator)models.getAllocation().getTargetResourceEnvironment_Allocation().eAllContents()).filter(arg_0 -> ((EClass)ResourceenvironmentPackage.Literals.RESOURCE_CONTAINER).isInstance(arg_0)).map(ResourceContainer.class::cast).forEach(container -> this.addOneMiddlewareInstancePerResourceContainer(models, (ResourceContainer)container));
        if (LOGGER.isEnabledFor((Priority)Level.INFO)) {
            LOGGER.info((Object)"Replace connectors with completions...");
        }
        Configuration featureConfiguration = pcmModels.getFeatureConfig();
        Streams.stream((Iterator)models.getSystem().eAllContents()).filter(arg_0 -> ((EClass)CompositionPackage.Literals.ASSEMBLY_CONNECTOR).isInstance(arg_0)).map(AssemblyConnector.class::cast).map(connector -> new ConnectorReplacingBuilder(models, (AssemblyConnector)connector, featureConfiguration.getDefaultConfig())).forEach(IBuilder::build);
        this.postProcessCompletedMiddlewarePartition(completionsRepositoryPartition);
    }

    protected Repository getMiddlewareRepository() {
        ResourceSetPartition middlewareRepository = (ResourceSetPartition)this.blackboard.getPartition("de.uka.ipd.sdq.pcmmodels.partition.rmimiddleware");
        return (Repository)middlewareRepository.getElement(RepositoryPackage.Literals.REPOSITORY).stream().findAny().orElseThrow(() -> new IllegalStateException("The middleware model is expected to contain a PCM Repository, but it does not."));
    }

    protected Repository createCompletionRepository(ResourceSetPartition completionRepositoryPartition, Repository middlewareRepository) throws JobFailedException {
        Repository completionRepository = RepositoryFactory.eINSTANCE.createRepository();
        completionRepository.setEntityName(String.format("CompletionRepository<%s>", middlewareRepository.getId()));
        String fileName = String.format("completion-%s.repository", middlewareRepository.getId());
        URI completionRepositoryURI = this.getCompletionResourceURI(fileName);
        Resource r = completionRepositoryPartition.getResourceSet().createResource(completionRepositoryURI);
        r.getContents().add((Object)completionRepository);
        return completionRepository;
    }

    protected ResourceSetPartition getPartitionForCompletedMiddleware() {
        ResourceSetPartition completionRepositoryPartition = new ResourceSetPartition();
        this.blackboard.addPartition(COMPLETION_REPOSITORY_PARTITION, (Object)completionRepositoryPartition);
        return completionRepositoryPartition;
    }

    protected void postProcessCompletedMiddlewarePartition(ResourceSetPartition partition) {
        try {
            partition.storeAllResources();
        }
        catch (IOException e) {
            LOGGER.error((Object)"Unable to serialize the working copy of the completion models.", (Throwable)e);
        }
    }

    protected URI getCompletionResourceURI(String resourceName) throws JobFailedException {
        IFolder completionFolder = this.getOrCreateCompletionFolder();
        URI completionFolderURI = URI.createFileURI((String)completionFolder.getLocation().toOSString());
        return completionFolderURI.appendSegment(resourceName);
    }

    private IFolder getOrCreateCompletionFolder() throws JobFailedException {
        assert (this.configuration != null);
        IProject project = CreatePluginProjectJob.getProject((String)this.configuration.getStoragePluginID());
        assert (project != null);
        return CreatePluginProjectJob.getOrCreateFolder((IProject)project, (String)COMPLETIONS_FOLDER);
    }

    private void addOneMiddlewareInstancePerResourceContainer(PCMAndCompletionModelHolder models, ResourceContainer resContainer) {
        AssemblyContext ctx = CompositionFactory.eINSTANCE.createAssemblyContext();
        ctx.setEntityName("AssCtx Middleware " + resContainer.getEntityName() + " " + resContainer.getId());
        ctx.setEncapsulatedComponent__AssemblyContext((RepositoryComponent)models.getMiddlewareRepository().getComponents__Repository().get(0));
        models.getSystem().getAssemblyContexts__ComposedStructure().add((Object)ctx);
        models.getSystem().getAssemblyContexts__ComposedStructure().add((Object)ctx);
        AllocationContext allocCtx = AllocationFactory.eINSTANCE.createAllocationContext();
        allocCtx.setEntityName("AllocCtx Middleware " + resContainer.getEntityName() + " " + resContainer.getId());
        allocCtx.setAssemblyContext_AllocationContext(ctx);
        allocCtx.setResourceContainer_AllocationContext(resContainer);
        models.getAllocation().getAllocationContexts_Allocation().add((Object)allocCtx);
        if (LOGGER.isEnabledFor((Priority)Level.INFO)) {
            LOGGER.info((Object)("Added middleware component >" + ctx.getEncapsulatedComponent__AssemblyContext().getEntityName() + "< to resource container >" + resContainer.getEntityName() + " (" + resContainer.getId() + ")" + "<"));
        }
    }

    public void setBlackboard(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }

    public String getName() {
        return "Add connector completions job";
    }

    public void cleanup(IProgressMonitor monitor) throws CleanupFailedException {
    }
}

