/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.pcm.extension.editor.sirius.assignments;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.dataflowanalysis.pcm.extension.editor.sirius.assignments.ObservableResourceValidator;
import org.dataflowanalysis.pcm.extension.editor.sirius.assignments.SerializationHelper;
import org.dataflowanalysis.pcm.extension.editor.sirius.assignments.ViewerConfiguration;
import org.dataflowanalysis.pcm.extension.model.confidentiality.ConfidentialityVariableCharacterisation;
import org.dataflowanalysis.pcm.extension.model.confidentiality.behaviour.ReusableBehaviour;
import org.dataflowanalysis.pcm.extension.model.confidentiality.characteristics.CharacteristicTypeDictionary;
import org.dataflowanalysis.pcm.extension.model.confidentiality.dictionary.PCMDataDictionary;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditor;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorFactory;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorModelAccess;
import org.eclipse.xtext.ui.editor.embedded.IEditedResourceProvider;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;
import org.palladiosimulator.pcm.parameter.VariableUsage;

public class AssignmentsEditorImpl
extends TitleAreaDialog {
    @Inject
    private ViewerConfiguration configuration;
    @Inject
    private EmbeddedEditorFactory embeddedEditorFactory;
    @Inject
    private IResourceValidator originalValidator;
    @Inject
    private IEditedResourceProvider editedResourceProvider;
    private final String outputName;
    private final Collection<String> usableInputs;
    private final Collection<CharacteristicTypeDictionary> dictionaries;
    private final VariableUsage existingUsage;
    private EmbeddedEditorModelAccess modelAccess;
    private Collection<VariableUsage> result;
    private SerializationHelper serializationHelper;

    public AssignmentsEditorImpl(Shell parentShell, String outputName, Collection<String> usableInputs, Collection<CharacteristicTypeDictionary> dictionaries, VariableUsage existingUsage) {
        super(parentShell);
        this.outputName = outputName;
        this.usableInputs = usableInputs;
        this.dictionaries = dictionaries;
        this.existingUsage = existingUsage;
    }

    public Collection<VariableUsage> getResult() {
        return this.result;
    }

    protected Control createDialogArea(Composite parent) {
        this.serializationHelper = new SerializationHelper(this.editedResourceProvider);
        Composite composite = (Composite)super.createDialogArea(parent);
        ObservableResourceValidator observableValidator = new ObservableResourceValidator(this.originalValidator);
        EmbeddedEditor embeddedEditor = this.embeddedEditorFactory.newEditor(this.editedResourceProvider).showErrorAndWarningAnnotations().withResourceValidator((IResourceValidator)observableValidator).withParent(composite);
        try {
            String prefix = this.getPrefix();
            String content = this.getContent();
            String postfix = this.getPostfix();
            this.modelAccess = embeddedEditor.createPartialEditor(prefix, content, postfix, true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.configuration.getHighlightingHelper().install(embeddedEditor.getConfiguration(), embeddedEditor.getViewer());
        embeddedEditor.getViewer().getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        observableValidator.addValidationListener(this::processValidationResult);
        composite.pack();
        return composite;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.getShell().setText("Edit assignments");
        this.setTitle("Edit assignments");
        return control;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        this.setResultVariables();
        super.okPressed();
    }

    protected PCMDataDictionary buildSerializationModel(Consumer<ReusableBehaviour> behaviourBuilder) {
        return this.serializationHelper.buildSerializationModel(behaviourBuilder, this.outputName, this.usableInputs, this.dictionaries);
    }

    protected String getPrefix() throws IOException {
        PCMDataDictionary dict = this.buildSerializationModel(behaviour -> {});
        String serializedDict = this.serializationHelper.serializeDict(dict, this.dictionaries);
        return serializedDict.substring(0, serializedDict.lastIndexOf("}") - 1);
    }

    protected String getContent() throws IOException {
        block3: {
            block2: {
                if (this.existingUsage == null) break block2;
                if (this.existingUsage.getVariableCharacterisation_VariableUsage().stream().anyMatch(ConfidentialityVariableCharacterisation.class::isInstance)) break block3;
            }
            return "";
        }
        PCMDataDictionary dict = this.buildSerializationModel(behaviour -> {
            VariableUsage variableUsageToEdit = (VariableUsage)EcoreUtil.copy((EObject)this.existingUsage);
            behaviour.getVariableUsages().add((Object)variableUsageToEdit);
        });
        String serializedDict = this.serializationHelper.serializeDict(dict, Arrays.asList(dict));
        int behaviorIndex = serializedDict.indexOf("behavior ");
        String behaviorText = serializedDict.substring(behaviorIndex, serializedDict.length()).trim();
        int behaviorBlockOpenIndex = behaviorText.indexOf("{");
        String behaviorContentText = behaviorText.substring(behaviorBlockOpenIndex + 1, behaviorText.length() - 1);
        String assignments = behaviorContentText.replaceAll("\\s*((input)|(output))\\s+[^\\s]+", "").trim();
        List<String> assignmentLines = Arrays.asList(assignments.split("\r?\n"));
        return assignmentLines.stream().map(line -> {
            if (line.startsWith("\t")) {
                return line.substring(1);
            }
            return line;
        }).collect(Collectors.joining(System.lineSeparator()));
    }

    protected String getPostfix() {
        return "}";
    }

    protected void processValidationResult(Collection<Issue> issues) {
        Display.getDefault().asyncExec(() -> {
            Button okButton = this.getButton(0);
            if (issues.isEmpty()) {
                okButton.setEnabled(true);
            } else {
                okButton.setEnabled(false);
            }
            this.createAndSetErrorMessage(issues);
        });
    }

    protected void createAndSetErrorMessage(Collection<Issue> issues) {
        this.setErrorMessage(null);
        ArrayList<String> errorMessages = new ArrayList<String>();
        for (Issue issue : issues) {
            if (issue.getMessage().contains("input '}'")) continue;
            if (issue.getMessage().contains("The required feature") && issue.getMessage().contains("must be set")) {
                errorMessages.add(issue.getMessage().replaceFirst(" of '[^']+'", ""));
                continue;
            }
            errorMessages.add(String.valueOf(issue.getMessage()) + " (line " + issue.getLineNumber() + ", column " + issue.getColumn() + ")");
        }
        if (!errorMessages.isEmpty()) {
            String fullMessage = errorMessages.stream().collect(Collectors.joining(System.lineSeparator()));
            this.setErrorMessage(fullMessage);
        }
    }

    protected void setResultVariables() {
        String resultText = this.modelAccess.getSerializedModel();
        try {
            PCMDataDictionary dict = this.serializationHelper.parseDict(resultText, this.dictionaries);
            this.result = Collections.unmodifiableCollection(((ReusableBehaviour)dict.getReusableBehaviours().get(0)).getVariableUsages());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

